/*
 * Decompiled with CFR 0.152.
 */
package org.jgroups.debug;

import java.io.Serializable;
import org.jgroups.Event;
import org.jgroups.Message;
import org.jgroups.log.Trace;
import org.jgroups.stack.Configurator;
import org.jgroups.stack.Protocol;
import org.jgroups.util.Util;

public class ProtocolTester {
    Protocol harness = null;
    Protocol top;
    Protocol bottom;
    String props = null;
    Configurator config = null;

    public ProtocolTester(String prot_spec, Protocol harness, boolean trace) throws Exception {
        if (prot_spec == null || harness == null) {
            throw new Exception("ProtocolTester(): prot_spec or harness is null");
        }
        this.props = prot_spec;
        this.harness = harness;
        this.props = "LOOPBACK:" + this.props;
        if (trace) {
            Trace.init();
        }
        this.config = new Configurator();
        this.top = this.config.setupProtocolStack(this.props, null);
        harness.setDownProtocol(this.top);
        this.top.setUpProtocol(harness);
        this.bottom = this.getBottomProtocol(this.top);
        this.config.startProtocolStack(this.bottom);
    }

    public String getProtocolSpec() {
        return this.props;
    }

    public void stop() {
        if (this.harness != null) {
            for (Protocol p = this.harness; p != null; p = p.getDownProtocol()) {
                p.stop();
            }
            this.config.stopProtocolStack(this.harness);
        } else if (this.top != null) {
            for (Protocol p = this.top; p != null; p = p.getDownProtocol()) {
                p.stop();
            }
            this.config.stopProtocolStack(this.top);
        }
    }

    Protocol getBottomProtocol(Protocol top) {
        if (top == null) {
            return null;
        }
        Protocol tmp = top;
        while (tmp.getDownProtocol() != null) {
            tmp = tmp.getDownProtocol();
        }
        return tmp;
    }

    public static void main(String[] args) {
        boolean trace = false;
        if (args.length < 1 || args.length > 2) {
            System.out.println("ProtocolTester <protocol stack spec> [-trace]");
            return;
        }
        String props = args[0];
        if (args.length == 2 && args[1].equals("-trace")) {
            trace = true;
        }
        try {
            Harness h = new Harness();
            ProtocolTester t = new ProtocolTester(props, h, trace);
            System.out.println("protocol specification is " + t.getProtocolSpec());
            h.down(new Event(16));
            for (int i = 0; i < 5; ++i) {
                System.out.println("Sending msg #" + i);
                h.down(new Event(1, new Message(null, null, (Serializable)((Object)("Hello world #" + i)))));
            }
            Util.sleep(500L);
            t.stop();
        }
        catch (Exception ex) {
            System.err.println(ex);
        }
    }

    private static class Harness
    extends Protocol {
        private Harness() {
        }

        public String getName() {
            return "Harness";
        }

        public void up(Event evt) {
            System.out.println("Harness.up(): " + evt);
        }
    }
}

