/*
 * Decompiled with CFR 0.152.
 */
package org.jgroups.protocols;

import java.util.Vector;
import org.jgroups.Address;
import org.jgroups.View;
import org.jgroups.ViewId;
import org.jgroups.blocks.MethodCall;
import org.jgroups.log.Trace;
import org.jgroups.protocols.GMS;
import org.jgroups.protocols.GmsImpl;

public class ParticipantGmsImpl
extends GmsImpl {
    boolean leaving = false;
    boolean received_final_view = false;
    Object leave_mutex = new Object();
    Vector suspected_mbrs = new Vector();
    Vector new_mbrs = new Vector();
    static /* synthetic */ Class class$org$jgroups$Address;

    public ParticipantGmsImpl(GMS g) {
        this.gms = g;
        this.init();
    }

    public void init() {
        this.leaving = false;
        this.received_final_view = false;
        this.suspected_mbrs.removeAllElements();
        this.new_mbrs.removeAllElements();
        if (this.gms.members != null) {
            for (int i = 0; i < this.gms.members.size(); ++i) {
                this.new_mbrs.addElement(this.gms.members.elementAt(i));
            }
        }
    }

    public void join(Address mbr) {
        this.wrongMethod("join");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void leave(Address mbr) {
        Address coord;
        Object retval = null;
        if (mbr.equals(this.gms.local_addr)) {
            this.leaving = true;
        }
        while ((coord = this.gms.determineCoordinator()) != null && !this.received_final_view) {
            Object object = this.leave_mutex;
            synchronized (object) {
                if (this.gms.local_addr.equals(coord)) {
                    this.gms.becomeCoordinator();
                    this.gms.handleLeave(mbr, false);
                } else {
                    try {
                        if (Trace.trace) {
                            Trace.info("Participant.leave()", "sending LEAVE request to " + coord);
                        }
                        MethodCall call = new MethodCall("handleLeave", new Object[]{mbr, new Boolean(false)}, new String[]{(class$org$jgroups$Address == null ? ParticipantGmsImpl.class$("org.jgroups.Address") : class$org$jgroups$Address).getName(), Boolean.TYPE.getName()});
                        this.gms.callRemoteMethod(coord, call, 6, 0L);
                    }
                    catch (Exception e) {
                        // empty catch block
                    }
                }
                try {
                    this.leave_mutex.wait(this.gms.leave_timeout);
                }
                catch (Exception e) {
                    // empty catch block
                }
            }
        }
        this.gms.becomeClient();
    }

    public void suspect(Address mbr) {
        this.handleSuspect(mbr);
    }

    public void merge(Vector other_coords) {
        this.wrongMethod("merge");
    }

    public boolean handleJoin(Address mbr) {
        this.wrongMethod("handleJoin");
        return false;
    }

    public void handleLeave(Address mbr, boolean suspected) {
        this.wrongMethod("handleLeave");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void handleViewChange(ViewId new_view, Vector mbrs) {
        if (Trace.trace) {
            Trace.info("ParticipantGmsImpl.handleViewChange()", "mbrs are " + mbrs);
        }
        this.suspected_mbrs.removeAllElements();
        this.new_mbrs.removeAllElements();
        if (mbrs != null) {
            for (int i = 0; i < mbrs.size(); ++i) {
                this.new_mbrs.addElement(mbrs.elementAt(i));
            }
        }
        if (this.leaving) {
            if (mbrs.contains(this.gms.local_addr)) {
                Trace.warn("ParticipantGmsImpl.handleViewChange()", "received view in which I'm still a member, cannot quit yet");
                this.gms.installView(new_view, mbrs);
            } else {
                Object object = this.leave_mutex;
                synchronized (object) {
                    this.received_final_view = true;
                    this.leave_mutex.notify();
                }
            }
            return;
        }
        this.gms.installView(new_view, mbrs);
    }

    public View handleMerge(ViewId other_view, Vector other_members) {
        this.wrongMethod("handleMerge");
        return null;
    }

    public void handleSuspect(Address mbr) {
        Vector suspects = null;
        if (mbr == null) {
            return;
        }
        if (!this.suspected_mbrs.contains(mbr)) {
            this.suspected_mbrs.addElement(mbr);
        }
        this.new_mbrs.removeElement(mbr);
        if (Trace.trace) {
            Trace.info("ParticipantGmsImpl.handleSuspect()", "suspected mbr=" + mbr + "\nsuspected_mbrs=" + this.suspected_mbrs + "\nnew_mbrs=" + this.new_mbrs);
        }
        if (this.new_mbrs.size() > 0 && this.new_mbrs.elementAt(0).equals(this.gms.local_addr)) {
            if (Trace.trace) {
                Trace.info("ParticipantGmsImpl.handleSuspect()", "suspected mbr=" + mbr + ", members are " + this.gms.members + ", coord=" + this.gms.local_addr + ": I'm the new coord !");
            }
            suspects = (Vector)this.suspected_mbrs.clone();
            this.suspected_mbrs.removeAllElements();
            this.new_mbrs.removeAllElements();
            this.gms.becomeCoordinator();
            this.gms.castViewChange(null, null, suspects);
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

