/*
 * Decompiled with CFR 0.152.
 */
package org.jgroups.service;

import java.util.LinkedList;
import org.jgroups.Address;
import org.jgroups.Channel;
import org.jgroups.MembershipListener;
import org.jgroups.MessageListener;
import org.jgroups.Transport;
import org.jgroups.View;
import org.jgroups.blocks.PullPushAdapter;
import org.jgroups.log.Trace;

public abstract class AbstractService
implements MembershipListener {
    protected Channel serviceChannel;
    protected PullPushAdapter serviceAdapter;
    protected Channel clientChannel;
    protected LinkedList members = new LinkedList();
    protected boolean blocked;
    protected Object blockMonitor = new Object();
    protected Object threadMonitor = new Object();
    protected boolean runThread;

    public AbstractService(Channel serviceChannel, Channel clientChannel) {
        this.serviceChannel = serviceChannel;
        this.serviceAdapter = new PullPushAdapter((Transport)serviceChannel, this);
        this.clientChannel = clientChannel;
        try {
            serviceChannel.getState(null, 1000L);
        }
        catch (Exception ex) {
            Trace.error("AbstractService.AbstractService()", "exception fetching state: " + ex);
        }
    }

    public abstract String getName();

    protected void setMessageListener(MessageListener listener) {
        this.serviceAdapter.setListener(listener);
    }

    public Address getAddress() {
        return this.serviceChannel.getLocalAddress();
    }

    public boolean isCoordinator() {
        return this.getAddress().equals(this.members.getFirst());
    }

    public boolean isBlocked() {
        return this.blocked;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void waitOnBlocked() throws InterruptedException {
        Object object = this.blockMonitor;
        synchronized (object) {
            this.blockMonitor.wait();
        }
    }

    public void block() {
        this.blocked = true;
    }

    public void suspect(Address suspectedMember) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void viewAccepted(View view) {
        Object object = this.members;
        synchronized (object) {
            this.members.clear();
            this.members.addAll(view.getMembers());
        }
        object = this.blockMonitor;
        synchronized (object) {
            this.blocked = false;
            this.blockMonitor.notifyAll();
        }
    }

    public void start() {
        this.runThread = true;
        Runnable runnable = new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                while (AbstractService.this.runThread) {
                    Object object = AbstractService.this.threadMonitor;
                    synchronized (object) {
                        try {
                            AbstractService.this.threadMonitor.wait();
                        }
                        catch (InterruptedException interruptedException) {
                            // empty catch block
                        }
                    }
                }
            }
        };
        Thread thread = new Thread(runnable, this.getName() + " Thread [" + this.getAddress() + "]");
        thread.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop() {
        if (!this.runThread) {
            return;
        }
        this.runThread = false;
        Object object = this.threadMonitor;
        synchronized (object) {
            this.threadMonitor.notifyAll();
        }
    }
}

