/*
 * Decompiled with CFR 0.152.
 */
package org.jgroups.stack;

import java.util.Enumeration;
import org.jgroups.Address;
import org.jgroups.Message;
import org.jgroups.log.Trace;
import org.jgroups.stack.Retransmitter;
import org.jgroups.util.List;
import org.jgroups.util.RWLock;
import org.jgroups.util.TimeScheduler;

public class NakReceiverWindow {
    private RWLock lock = new RWLock();
    private long head = 0L;
    private long tail = 0L;
    private long lowest_seen = 0L;
    private long highest_seen = 0L;
    private List msgs = new List();
    private List delivered_msgs = new List();
    private Retransmitter retransmitter = null;

    public NakReceiverWindow(Address sender, Retransmitter.RetransmitCommand cmd, long start_seqno, TimeScheduler sched) {
        this.tail = this.head = start_seqno;
        if (cmd != null) {
            this.retransmitter = sched == null ? new Retransmitter(sender, cmd) : new Retransmitter(sender, cmd, sched);
        }
    }

    public NakReceiverWindow(Address sender, Retransmitter.RetransmitCommand cmd, long start_seqno) {
        this(sender, cmd, start_seqno, null);
    }

    public NakReceiverWindow(Address sender, long start_seqno) {
        this(sender, null, start_seqno);
    }

    public void setRetransmitTimeouts(long[] timeouts) {
        if (this.retransmitter != null) {
            this.retransmitter.setRetransmitTimeouts(timeouts);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void add(long seqno, Message msg) {
        Entry current = null;
        this.lock.writeLock();
        try {
            block10: {
                block11: {
                    long old_tail;
                    block9: {
                        old_tail = this.tail;
                        if (seqno < this.head) {
                            return;
                        }
                        if (seqno != this.tail) break block9;
                        this.msgs.add(new Entry(seqno, msg));
                        ++this.tail;
                        break block10;
                    }
                    if (seqno <= this.tail) break block11;
                    for (long i = this.tail; i < seqno; ++i) {
                        this.msgs.add(new Entry(i, null));
                        ++this.tail;
                    }
                    this.msgs.add(new Entry(seqno, msg));
                    this.tail = seqno + 1L;
                    if (this.retransmitter == null) break block10;
                    this.retransmitter.add(old_tail, seqno - 1L);
                    break block10;
                }
                if (seqno < this.tail) {
                    Enumeration en = this.msgs.elements();
                    while (en.hasMoreElements()) {
                        current = (Entry)en.nextElement();
                        if (seqno != current.seqno) continue;
                        if (current.msg != null) break;
                        current.msg = msg;
                        if (this.retransmitter == null) break;
                        this.retransmitter.remove(seqno);
                        break;
                    }
                }
            }
            this._updateLowestSeen();
            this._updateHighestSeen();
        }
        finally {
            this.lock.writeUnlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Message remove() {
        Message retval = null;
        this.lock.writeLock();
        try {
            Entry e = (Entry)this.msgs.peekAtHead();
            if (e != null && e.msg != null) {
                retval = e.msg;
                this.msgs.removeFromHead();
                this.delivered_msgs.add(new Entry(e.seqno, e.msg));
                ++this.head;
            }
            Message message = retval;
            return message;
        }
        finally {
            this.lock.writeUnlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stable(long seqno) {
        this.lock.writeLock();
        try {
            Entry e;
            while ((e = (Entry)this.delivered_msgs.peekAtHead()) != null && e.seqno <= seqno) {
                this.delivered_msgs.removeFromHead();
            }
            this._updateLowestSeen();
            this._updateHighestSeen();
        }
        finally {
            this.lock.writeUnlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void reset() {
        this.lock.writeLock();
        try {
            if (this.retransmitter != null) {
                this.retransmitter.reset();
            }
            this._reset();
        }
        finally {
            this.lock.writeUnlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void destroy() {
        this.lock.writeLock();
        try {
            if (this.retransmitter != null) {
                this.retransmitter.stop();
            }
            this._reset();
        }
        finally {
            this.lock.writeUnlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getHighestDelivered() {
        this.lock.readLock();
        try {
            long l = Math.max(this.head - 1L, -1L);
            return l;
        }
        finally {
            this.lock.readUnlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getLowestSeen() {
        this.lock.readLock();
        try {
            long l = this.lowest_seen;
            return l;
        }
        finally {
            this.lock.readUnlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getHighestSeen() {
        this.lock.readLock();
        try {
            long l = this.highest_seen;
            return l;
        }
        finally {
            this.lock.readUnlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List getMissingMessages(long low, long high) {
        List retval = new List();
        if (low > high) {
            if (Trace.trace) {
                Trace.error("NakReceiverWindow.getMissingMessages()", "invalid range: low (" + low + ") is higher than high (" + high + ")");
            }
            return null;
        }
        this.lock.readLock();
        try {
            Entry entry;
            long my_high = Math.max(this.head - 1L, 0L);
            Enumeration e = this.msgs.elements();
            while (e.hasMoreElements()) {
                entry = (Entry)e.nextElement();
                if (entry.seqno < low || entry.seqno > high || entry.msg != null) continue;
                retval.add(new Long(entry.seqno));
            }
            if (this.msgs.size() > 0 && (entry = (Entry)this.msgs.peek()) != null) {
                my_high = entry.seqno;
            }
            for (long i = my_high + 1L; i <= high; ++i) {
                retval.add(new Long(i));
            }
            List list = retval.size() == 0 ? null : retval;
            return list;
        }
        finally {
            this.lock.readUnlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getHighestReceived() {
        this.lock.readLock();
        try {
            long l = Math.max(this.tail - 1L, -1L);
            return l;
        }
        finally {
            this.lock.readUnlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List getMessagesHigherThan(long seqno) {
        List retval = new List();
        this.lock.readLock();
        try {
            Entry entry;
            Enumeration e = this.msgs.elements();
            while (e.hasMoreElements()) {
                entry = (Entry)e.nextElement();
                if (entry.seqno <= seqno) continue;
                retval.add(entry.msg);
            }
            e = this.delivered_msgs.elements();
            while (e.hasMoreElements()) {
                entry = (Entry)e.nextElement();
                if (entry.seqno <= seqno || entry.msg == null) continue;
                retval.add(entry.msg.copy());
            }
            List list = retval;
            return list;
        }
        finally {
            this.lock.readUnlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List getMessagesInRange(long lower, long upper) {
        List retval = new List();
        this.lock.readLock();
        try {
            Entry entry;
            Enumeration e = this.msgs.elements();
            while (e.hasMoreElements()) {
                entry = (Entry)e.nextElement();
                if (entry.seqno <= lower || entry.seqno > upper) continue;
                retval.add(entry.msg);
            }
            e = this.delivered_msgs.elements();
            while (e.hasMoreElements()) {
                entry = (Entry)e.nextElement();
                if (entry.seqno <= lower || entry.seqno > upper || entry.msg == null) continue;
                retval.add(entry.msg.copy());
            }
            List list = retval.size() == 0 ? null : retval;
            return list;
        }
        finally {
            this.lock.readUnlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List getMessagesInList(List missing_msgs) {
        List ret = new List();
        if (missing_msgs == null) {
            if (Trace.trace) {
                Trace.error("NakReceiverWindow.getMessagesInList()", "argument list is null");
            }
            return ret;
        }
        this.lock.readLock();
        try {
            Entry entry;
            Enumeration e = this.delivered_msgs.elements();
            while (e.hasMoreElements()) {
                entry = (Entry)e.nextElement();
                if (!missing_msgs.contains(new Long(entry.seqno)) || entry.msg == null) continue;
                ret.add(entry.msg.copy());
            }
            e = this.msgs.elements();
            while (e.hasMoreElements()) {
                entry = (Entry)e.nextElement();
                if (!missing_msgs.contains(new Long(entry.seqno)) || entry.msg == null) continue;
                ret.add(entry.msg.copy());
            }
            List list = ret;
            return list;
        }
        finally {
            this.lock.readUnlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int size() {
        this.lock.readLock();
        try {
            int n = this.msgs.size();
            return n;
        }
        finally {
            this.lock.readUnlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String toString() {
        StringBuffer sb = new StringBuffer();
        this.lock.readLock();
        try {
            sb.append("delivered_msgs: " + this.delivered_msgs);
            sb.append("\nreceived_msgs: " + this.msgs);
        }
        finally {
            this.lock.readUnlock();
        }
        return sb.toString();
    }

    private void _updateLowestSeen() {
        Entry entry = null;
        if (this.delivered_msgs.size() == 0 && this.msgs.size() == 0) {
            this.lowest_seen = 0L;
            return;
        }
        entry = (Entry)this.delivered_msgs.peekAtHead();
        if (entry != null) {
            this.lowest_seen = entry.seqno;
        } else if (this.msgs.size() != 0 && (entry = (Entry)this.msgs.peekAtHead()) != null && entry.msg != null) {
            this.lowest_seen = entry.seqno;
        }
    }

    private void _updateHighestSeen() {
        long ret = 0L;
        Entry entry = null;
        if (this.delivered_msgs.size() == 0 && this.msgs.size() == 0) {
            this.highest_seen = 0L;
            return;
        }
        entry = (Entry)this.delivered_msgs.peek();
        ret = entry != null ? entry.seqno : Math.max(this.head - 1L, 0L);
        Enumeration e = this.msgs.elements();
        while (e.hasMoreElements() && (entry = (Entry)e.nextElement()).msg != null) {
            ret = entry.seqno;
        }
        this.highest_seen = Math.max(ret, 0L);
    }

    private void _reset() {
        this.msgs.removeAll();
        this.delivered_msgs.removeAll();
        this.head = 0L;
        this.tail = 0L;
        this.lowest_seen = 0L;
        this.highest_seen = 0L;
    }

    private static class Entry {
        private long seqno = 0L;
        private Message msg = null;

        public Entry() {
            this.seqno = 0L;
            this.msg = null;
        }

        public Entry(long seqno, Message msg) {
            this.seqno = seqno;
            this.msg = msg;
        }

        public Entry copy() {
            Entry retval = new Entry();
            retval.seqno = this.seqno;
            if (this.msg != null) {
                retval.msg = this.msg.copy();
            }
            return retval;
        }

        public String toString() {
            StringBuffer ret = new StringBuffer();
            ret.append(this.seqno);
            if (this.msg == null) {
                ret.append("-");
            } else {
                ret.append("+");
            }
            return ret.toString();
        }
    }
}

