/*
 * Decompiled with CFR 0.152.
 */
package org.jgroups.tests;

import java.util.Vector;
import org.jgroups.Address;
import org.jgroups.Channel;
import org.jgroups.JChannel;
import org.jgroups.Message;
import org.jgroups.View;
import org.jgroups.log.Trace;
import org.jgroups.util.Util;

public class FragTestUnicast {
    int mode = 0;
    Channel channel;
    String props;
    int i = 1;
    Message msg;
    Object obj;
    int MSG_SIZE;
    String groupname = "FragTestUnicastGroup";
    char sendingChar;
    int num_msgs = 10;
    long timeout = 3000L;
    int frag_size = 20000;
    Address local_addr;

    public FragTestUnicast(char character, int mode, int msg_size, int num_msgs, long timeout, int frag_size) {
        this.sendingChar = character;
        this.mode = mode;
        this.MSG_SIZE = msg_size;
        this.num_msgs = num_msgs;
        this.timeout = timeout;
        this.frag_size = frag_size;
        this.props = "UDP(mcast_addr=224.10.20.3;mcast_port=45566;ip_ttl=32;ucast_send_buf_size=" + frag_size * 2 + ";ucast_recv_buf_size=" + frag_size * 4 + "):" + "PING(timeout=3000;num_initial_members=2):" + "FD(timeout=5000):" + "VERIFY_SUSPECT(timeout=1500):" + "pbcast.NAKACK(gc_lag=20;retransmit_timeout=2000):" + "UNICAST(timeout=4000):" + "pbcast.STABLE(desired_avg_gossip=10000):" + "FRAG(frag_size=" + frag_size + "):" + "pbcast.GMS(join_timeout=5000;join_retry_timeout=2000;" + "shun=false;print_local_addr=true)";
    }

    public void start() throws Exception {
        Address receiver = null;
        Trace.init();
        this.channel = new JChannel(this.props);
        this.channel.connect(this.groupname);
        this.local_addr = this.channel.getLocalAddress();
        if (this.mode == 1) {
            Vector mbrs = this.channel.getView().getMembers();
            if (mbrs.size() < 2) {
                View view;
                Object obj;
                System.out.println("Waiting for receiver to join group");
                while (!((obj = this.channel.receive(0L)) instanceof View) || (mbrs = (view = (View)obj).getMembers()).size() < 2) {
                }
            }
            for (int i = 0; i < mbrs.size(); ++i) {
                if (mbrs.elementAt(i).equals(this.local_addr)) continue;
                receiver = (Address)mbrs.elementAt(i);
                break;
            }
            System.out.println("Receiver joined group: I'm starting to send messages to " + receiver);
            for (int j = 0; j < this.num_msgs; ++j) {
                this.msg = this.createBigMessage(this.MSG_SIZE);
                this.msg.setDest(receiver);
                System.out.println("Sending msg (" + this.MSG_SIZE + " bytes) to " + receiver);
                this.channel.send(this.msg);
                System.out.println("Done Sending msg (" + this.MSG_SIZE + " bytes)");
                Util.sleep(this.timeout);
            }
        } else {
            System.out.println("Waiting for messages:");
            while (true) {
                try {
                    while (true) {
                        Object obj;
                        if (!((obj = this.channel.receive(0L)) instanceof Message)) continue;
                        System.out.println("Received message: " + obj);
                        Message tmp = (Message)obj;
                        byte[] buf = tmp.getBuffer();
                        for (int i = 0; i < (10 < this.MSG_SIZE ? 10 : this.MSG_SIZE); ++i) {
                            System.out.print((char)buf[i]);
                        }
                        System.out.println();
                    }
                }
                catch (Exception e) {
                    System.err.println(e);
                    continue;
                }
                break;
            }
        }
        System.out.println("Press [return] to exit");
        System.in.read();
        this.channel.close();
    }

    Message createBigMessage(int size) {
        byte[] buf = new byte[size];
        for (int i = 0; i < buf.length; ++i) {
            buf[i] = (byte)this.sendingChar;
        }
        return new Message(null, null, buf);
    }

    public static void main(String[] args) {
        char defaultChar = 'A';
        int default_mode = 0;
        int MSG_SIZE = 30000;
        int num_msgs = 5;
        long timeout = 1000L;
        int frag_size = 8195;
        for (int i = 0; i < args.length; ++i) {
            if (args[i].equals("-help")) {
                FragTestUnicast.usage();
                return;
            }
            if (args[i].equals("-sender")) {
                default_mode = 1;
                continue;
            }
            if (args[i].equals("-size")) {
                MSG_SIZE = Integer.parseInt(args[++i]);
                continue;
            }
            if (args[i].equals("-num_msgs")) {
                num_msgs = Integer.parseInt(args[++i]);
                continue;
            }
            if (args[i].equals("-frag_size")) {
                frag_size = Integer.parseInt(args[++i]);
                continue;
            }
            if (args[i].equals("-timeout")) {
                timeout = Long.parseLong(args[++i]);
                continue;
            }
            if (args[i].equals("-char")) {
                defaultChar = args[++i].charAt(0);
                continue;
            }
            FragTestUnicast.usage();
            return;
        }
        try {
            new FragTestUnicast(defaultChar, default_mode, MSG_SIZE, num_msgs, timeout, frag_size).start();
        }
        catch (Exception e) {
            System.err.println(e);
        }
    }

    static void usage() {
        System.out.println("FragTestUnicast [-sender] [-size <message size (in bytes)>] [-timeout <msecs>] [-num_msgs <number of messages>] [-char <frag character>] [-frag_size <fragmentation size>] [-help]");
    }
}

