/*
 * Decompiled with CFR 0.152.
 */
package org.jgroups.tests.adapttcp;

import java.io.BufferedReader;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.util.ArrayList;
import java.util.List;
import java.util.StringTokenizer;
import org.apache.log4j.Logger;
import org.jgroups.log.Trace;
import org.jgroups.tests.adapttcp.TcpTester;

public class Test {
    public static int srv_port = 7777;
    public static int grpMembers = 4;
    static /* synthetic */ Class class$org$jgroups$tests$adapttcp$Test;

    public static void main(String[] args) {
        String config;
        boolean sender = false;
        long msgs_burst = 50L;
        long sleep_msec = 50L;
        int num_bursts = 50;
        int msg_size = 500;
        int num_senders = 1;
        String props = null;
        long log_interval = 1000L;
        List nodes = new ArrayList();
        try {
            config = args[0];
        }
        catch (Exception e) {
            config = "config.txt";
        }
        Trace.init();
        try {
            String line;
            BufferedReader fileReader = new BufferedReader(new FileReader(config));
            while ((line = fileReader.readLine()) != null) {
                String gnuplot_output;
                if (line.startsWith("#")) continue;
                if (line.startsWith("SENDER=")) {
                    sender = new Boolean(line.substring(line.indexOf(61) + 1, line.indexOf(59)));
                    continue;
                }
                if (line.startsWith("MSGS_BURST=")) {
                    msgs_burst = Long.parseLong(line.substring(line.indexOf(61) + 1, line.indexOf(59)));
                    continue;
                }
                if (line.startsWith("SLEEP_MSEC=")) {
                    sleep_msec = Long.parseLong(line.substring(line.indexOf(61) + 1, line.indexOf(59)));
                    continue;
                }
                if (line.startsWith("NUM_BURSTS=")) {
                    num_bursts = Integer.parseInt(line.substring(line.indexOf(61) + 1, line.indexOf(59)));
                    continue;
                }
                if (line.startsWith("MSG_SIZE=")) {
                    msg_size = Integer.parseInt(line.substring(line.indexOf(61) + 1, line.indexOf(59)));
                    continue;
                }
                if (line.startsWith("GRPMEMBERS=")) {
                    grpMembers = Integer.parseInt(line.substring(line.indexOf(61) + 1, line.indexOf(59)));
                    continue;
                }
                if (line.startsWith("NUM_SENDERS=")) {
                    num_senders = Integer.parseInt(line.substring(line.indexOf(61) + 1, line.indexOf(59)));
                    continue;
                }
                if (line.startsWith("LOG_INTERVAL=")) {
                    log_interval = Long.parseLong(line.substring(line.indexOf(61) + 1, line.indexOf(59)));
                    continue;
                }
                if (line.startsWith("PROPS=")) {
                    props = line.substring(line.indexOf(61) + 1, line.indexOf(59)).trim();
                    continue;
                }
                if (line.startsWith("CLUSTER=")) {
                    nodes = Test.parseCommaDelimitedList(line.substring(line.indexOf(61) + 1, line.indexOf(59)).trim());
                    continue;
                }
                if (!line.startsWith("GNUPLOT_OUTPUT=") || System.getProperty("gnuplot_output") != null || (gnuplot_output = line.substring(line.indexOf(61) + 1, line.indexOf(59)).trim()) == null) continue;
                System.setProperty("gnuplot_output", gnuplot_output);
            }
            fileReader.close();
            System.out.println("Javagroups test:");
            String s = "Initial params parsing completed. Starting test with these values:\nSender:" + sender + "  Msgs/Burst:" + msgs_burst + "  Sleep(ms):" + sleep_msec + "  # Bursts:" + num_bursts + "  Size(bytes):" + msg_size + "  # Mbrs:" + grpMembers + "  Senders: " + num_senders + "\nLog interval: " + log_interval + "\n";
            System.out.println(s);
            Logger.getLogger((Class)(class$org$jgroups$tests$adapttcp$Test == null ? (class$org$jgroups$tests$adapttcp$Test = Test.class$("org.jgroups.tests.adapttcp.Test")) : class$org$jgroups$tests$adapttcp$Test)).info((Object)("main(): " + s));
            ServerSocket srv_sock = new ServerSocket(srv_port);
            new TcpTester(sender, msgs_burst, sleep_msec, num_bursts, msg_size, grpMembers, num_senders, log_interval, srv_sock, nodes).initialize();
        }
        catch (FileNotFoundException notFound) {
            System.err.println("File not found.\n" + notFound);
        }
        catch (IOException ioError) {
            System.err.println(ioError);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public static List parseCommaDelimitedList(String s) throws Exception {
        ArrayList<InetAddress> retval = new ArrayList<InetAddress>();
        if (s == null) {
            return null;
        }
        StringTokenizer tok = new StringTokenizer(s, ",");
        while (tok.hasMoreTokens()) {
            InetAddress host = InetAddress.getByName(tok.nextToken());
            retval.add(host);
        }
        return retval;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

