/*
 * Decompiled with CFR 0.152.
 */
package com.funambol.commons.web.monitor;

import com.funambol.commons.collections.CircularFifoBuffer;
import com.funambol.commons.web.monitor.PerformanceStats;
import com.funambol.commons.web.monitor.RequestSample;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.Vector;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.collections.Buffer;
import org.apache.commons.collections.BufferUtils;

public class PerformanceMonitor
implements Filter {
    public static String INIT_PARAM_ENABLED = "enabled";
    public static String INIT_PARAM_DEBUG = "debug";
    public static String INIT_PARAM_HISTORY_LENGTH = "history_length";
    public static String URL_PARAM_RESET = "reset";
    private static boolean debug = false;
    private static boolean enabled = false;
    private static int historyLength = 25;
    private static long initTimestamp = 0L;
    private static long resetTimestamp = 0L;
    private static int totRequestCount = 0;
    private static int requestCount = 0;
    private static long totLatency = 0L;
    private static long latency = 0L;
    private static Vector currentRequests = null;
    private static Buffer lastRequests = null;
    private FilterConfig filterConfig = null;

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        if (debug) {
            this.log("PerformanceMonitor:doFilter()");
        }
        if (!enabled) {
            chain.doFilter(request, response);
            return;
        }
        if (request.getParameter(URL_PARAM_RESET) != null) {
            PerformanceMonitor.reset();
        }
        RequestSample currentRequest = this.doBeforeProcessing((HttpServletRequest)request, (HttpServletResponse)response);
        Throwable problem = null;
        try {
            chain.doFilter(request, response);
        }
        catch (Throwable t) {
            problem = t;
            t.printStackTrace();
        }
        this.doAfterProcessing((HttpServletRequest)request, (HttpServletResponse)response, currentRequest);
        if (problem != null) {
            if (problem instanceof ServletException) {
                throw (ServletException)problem;
            }
            if (problem instanceof IOException) {
                throw (IOException)problem;
            }
            this.sendProcessingError(problem, response);
        }
    }

    public FilterConfig getFilterConfig() {
        return this.filterConfig;
    }

    public void setFilterConfig(FilterConfig filterConfig) {
        this.filterConfig = filterConfig;
    }

    public void destroy() {
    }

    public void init(FilterConfig filterConfig) throws ServletException {
        this.filterConfig = filterConfig;
        if (filterConfig == null) {
            return;
        }
        String value = filterConfig.getInitParameter(INIT_PARAM_DEBUG);
        if (value != null) {
            debug = Boolean.valueOf(value);
        }
        if ((value = filterConfig.getInitParameter(INIT_PARAM_ENABLED)) != null) {
            enabled = Boolean.valueOf(value);
        }
        if ((value = filterConfig.getInitParameter(INIT_PARAM_HISTORY_LENGTH)) != null) {
            try {
                historyLength = Integer.valueOf(value);
            }
            catch (NumberFormatException e) {
                this.log("Error: " + value + " is not an int value");
                throw new ServletException((Throwable)e);
            }
        }
        if (debug) {
            this.log("PerformanceMonitor: Initializing filter");
            this.log("enabled: " + enabled);
            this.log("historyLength: " + historyLength);
        }
        currentRequests = new Vector();
        lastRequests = BufferUtils.synchronizedBuffer((Buffer)new CircularFifoBuffer(historyLength));
        initTimestamp = resetTimestamp = System.currentTimeMillis();
    }

    public String toString() {
        if (this.filterConfig == null) {
            return "PerformanceMonitor()";
        }
        StringBuffer sb = new StringBuffer("PerformanceMonitor(");
        sb.append(this.filterConfig);
        sb.append(")");
        return sb.toString();
    }

    public static PerformanceStats getPerformanceStats() {
        return new PerformanceStats(currentRequests, lastRequests, initTimestamp, resetTimestamp, totLatency, latency, totRequestCount, requestCount);
    }

    public static void reset() {
        resetTimestamp = System.currentTimeMillis();
        requestCount = 0;
        latency = 0L;
        lastRequests.clear();
    }

    private RequestSample doBeforeProcessing(HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        if (debug) {
            this.log("PerformanceMonitor:DoBeforeProcessing");
        }
        RequestSample currentRequest = new RequestSample(request, System.currentTimeMillis());
        ++totRequestCount;
        ++requestCount;
        currentRequests.add(currentRequest);
        return currentRequest;
    }

    private void doAfterProcessing(HttpServletRequest request, HttpServletResponse response, RequestSample currentRequest) throws IOException, ServletException {
        if (debug) {
            this.log("PerformanceMonitor:DoAfterProcessing");
        }
        long timestamp = System.currentTimeMillis();
        currentRequest.setEndTimestamp(timestamp);
        currentRequests.remove(currentRequest);
        lastRequests.add((Object)currentRequest);
        long elapsed = timestamp - currentRequest.getStartTimestamp();
        totLatency += elapsed;
        latency += elapsed;
    }

    private void sendProcessingError(Throwable t, ServletResponse response) {
        String stackTrace = PerformanceMonitor.getStackTrace(t);
        if (stackTrace != null && !stackTrace.equals("")) {
            try {
                response.setContentType("text/html");
                PrintStream ps = new PrintStream((OutputStream)response.getOutputStream());
                PrintWriter pw = new PrintWriter(ps);
                pw.print("<html>\n<head>\n</head>\n<body>\n");
                pw.print("<h1>The resource did not process correctly</h1>\n<pre>\n");
                pw.print(stackTrace);
                pw.print("</pre></body>\n</html>");
                pw.close();
                ps.close();
                response.getOutputStream().close();
            }
            catch (Exception ex) {}
        } else {
            try {
                PrintStream ps = new PrintStream((OutputStream)response.getOutputStream());
                t.printStackTrace(ps);
                ps.close();
                response.getOutputStream().close();
            }
            catch (Exception ex) {
                // empty catch block
            }
        }
    }

    public static String getStackTrace(Throwable t) {
        String stackTrace = null;
        try {
            StringWriter sw = new StringWriter();
            PrintWriter pw = new PrintWriter(sw);
            t.printStackTrace(pw);
            pw.close();
            sw.close();
            stackTrace = sw.getBuffer().toString();
        }
        catch (Exception exception) {
            // empty catch block
        }
        return stackTrace;
    }

    private void log(String msg) {
        this.filterConfig.getServletContext().log(msg);
    }
}

