#ifndef __SFJP_MYU__AGH_3D_H__
#define __SFJP_MYU__AGH_3D_H__

//	I3dCameraImplBase
class I3dCameraImpl{
public:
	//virtual bool Load(const char* szImageFilePath){return false;};
	virtual bool Load(const char* szImageFilePath)=0;

_AGH_EVENT_ACCESS_MODIFIER:
	virtual void OnDraw()=0;

};
typedef I3dCameraImpl I3dCameraImplBase;

///////////////////////////////////////////////////////////////////

//	C3dCameraBaseT
template <typename _VEC3_T = agh::CVector3, typename _BASE = CVisualControlBase>
class C3dCameraBaseT : public _BASE
{
protected:
	I3dCameraImpl *m_pImpl;

	agh::CVector3 m_cameraPos;
	agh::CVector3 m_targetPos;

public:
	C3dCameraBaseT()
		: m_cameraPos(0,0,-1),
		  m_targetPos(0,0,0)
	{
	}
	virtual ~C3dCameraBaseT(){}

	//////////////////////////////////////////////////////////////////////////////

	//	J̈ʒuݒ
	virtual void SetPos(float x, float y, float z){ SetCameraPos(agh::CVector3(x,y,z)); }
	virtual void SetPos(agh::CVector3 &vec3){ m_cameraPos = vec; }
	
	//	Ώۂ̈ʒuݒ
	virtual void SetTargetPos(float x, float y, float z){ SetTargetPos(agh::CVector3(x,y,z)); }
	virtual void SetTargetPos(agh::CVector3 &vec3){ m_targetPos = vec; }

	//	Jw苗ړ
	virtual void MoveCamera(float x, float y, float z){ MoveCamera(agh::CVector3(x,y,z)); }
	virtual void MoveCamera(agh::CVector3 &vec3){ m_cameraPos += vec; }

	//	Ώۂw苗ړ
	virtual void MoveTarget(float x, float y, float z){ MoveTarget(agh::CVector3(x,y,z)); }
	virtual void MoveTarget(agh::CVector3 &vec3){ m_targetPos += vec; }

	//	ʑŜړiΏۂƃJړj
	virtual void Shift(float x, float y, float z){ Shift(agh::CVector3(x,y,z)); }
	virtual void Shift(agh::CVector3 &vec3){ MoveCamera(vec); MoveTarget(vec); }
	//void Shift(float fAngleX, float fAngleY, float fAngleZ, float x, float y, float z){ Shift(agh::CVector3(x,y,z)); }
	//void Shift(agh::CVector3 &vecAngle, agh::CVector3 &vec3){ MoveCamera(vec); MoveTarget(vec); }

	//////////////////////////////////////////////////////////////////////////////

	//	JiΏۂɁj]ړ
	virtual void RotateCamera(float fAngleX, float fAngleY, float fAngleZ){ RotateCamera(agh::CVector3(fAngleX,fAngleY,fAngleZ)); }
	virtual void RotateCamera(agh::CVector3 &vecAngles){ m_vecRotateCamera += vecAngles; }

	//	ΏۂiJɁj]ړ
	virtual void RotateTarget(float fAngleX, float fAngleY, float fAngleZ){ RotateTarget(agh::CVector3(fAngleX,fAngleY,fAngleZ)); }
	virtual void RotateTarget(agh::CVector3 &vecAngles){ m_vecRotateTarget += vecAngles; }

	//	J́iΏۂɂjΊpxݒ
	virtual void SetRotateAngleCamera(float fAngleX, float fAngleY, float fAngleZ){ SetRotateAngleCamera(agh::CVector3(fAngleX,fAngleY,fAngleZ)); }
	virtual void SetRotateAngleCamera(agh::CVector3 &vecAngles){ m_vecRotateCamera = vecAngles; }

	//	Ώۂ́iJɂjΊpxݒ
	virtual void SetRotateAngleTarget(float fAngleX, float fAngleY, float fAngleZ){ SetRotateAngleTarget(agh::CVector3(fAngleX,fAngleY,fAngleZ)); }
	virtual void SetRotateAngleTarget(agh::CVector3 &vecAngles){ m_vecRotateTarget = vecAngles; }
	
	//	Y[CƃY[AEg
	virtual void ZoomIn(float fDistance);
	virtual void ZoomOut(float fDistance);
};
typedef C3dCameraBaseT<> C3dCameraBase;

///////////////////////////////////////////////////////////////////

//	C3dViewBaseT
template <typename _CAMERA_CTRL, typename _BASE = CVisualControlBase>
class C3dViewBaseT : public _BASE
{
protected:
	_CAMERA_CTRL m_camera;

_AGH_EVENT_ACCESS_MODIFIER:

	virtual void OnRegist(){
		SetValPtr(AGH_CONTROL_TYPE_3D_CAMERA, &m_camera);
	}

public:
	C3dViewBaseT(){
	}
	virtual ~C3dViewBaseT(){}	//	fXgN^ƌĂ΂邽߂̑΍


};

//typedef C3dViewBaseT<> C3dViewBase;

/*
//	C3dViewBase
class C3dViewBase : public C3dViewBaseT<> {
public:
	virtual ~C3dViewBase(){}	//	fXgN^ƌĂ΂邽߂̑΍
};

//	C3dView
typedef C3dViewBase C3dView;
*/

#endif//__SFJP_MYU__AGH_3D_H__
