#include "agh.h"
#include <time.h>
#include <windows.h>

using namespace agh;

#define CPU_CLOCK_MHZ		(2400)		//	2,400,000,000,000 Hz

#define PRINT_SPEED2()		\
	printf(" %d ms (1per %f us, %d clock)\n",	\
		clock() - prev_clock, (double)(clock() - prev_clock) / loop_count * 1000.0,	\
		(int)((clock() - prev_clock) * (CPU_CLOCK_MHZ *1000.0f / loop_count )) ), prev_clock = clock();
/*	nclc = clock() - prev_clock, printf(" %d ms (1per %f us, %d clock)\n",	\
		nclc, (double)nclc / INSTANCE_COUNT * 1000.0 /X,	\
		(int)(nclc * (CPU_CLOCK_MHZ *1000.0f / INSTANCE_COUNT/X )) ), prev_clock = clock();
*/

void test1(unsigned int loop_count)
{
	CRect rect(clock(),clock(),clock(),clock());

	int i, z=(int)&rect;
	loop_count += clock();
	//MessageBox(NULL,NULL,0,0);
	for(i=0; i<loop_count; i++){
		CRect r = rect + z;
		z += r.left;
		z -= r.right;
		z += r.top;
		z -= r.bottom;
	}
}
void test7(unsigned int loop_count)
{
	CPoint point = CPoint(2,2);
	CRect rect;
	int i, z= (int)&rect;
	//MessageBox(NULL,NULL,0,0);
	for(i=0; i<loop_count; i++)
		z += (rect * point).left;
}
void test8(unsigned int loop_count)
{
	CRect rect;
	int i, z=(int)&rect;
	//MessageBox(NULL,NULL,0,0);
	for(i=0; i<loop_count; i++){
		z += (rect * 4).left;
	}
}

void mov_test(int loop_count);

int main()
{
	int prev_clock = clock();
	printf("start.\n");
	unsigned int i, j;
	unsigned int loop_count;
	unsigned int nclc;

	printf("\n== Speed Test =================================\n");

	//==============================================================

	printf("\n//  New Instance\n");

	printf("Now Time: %d\n", prev_clock = clock());

	CRect rect;

	//	CRect : operator +=(int)
	loop_count = 0x0fffffff;
	int z;
	CPoint point = CPoint(2,2);



	// Clock Test ///////////////////////////////////////////////////
	mov_test(loop_count);
	PRINT_SPEED2();
	/////////////////////////////////////////////////////


	{
		//	+
		printf("CRect : operator +(int) (%u Loops) :", loop_count);
		test1(loop_count);
	/*	for(i=0; i<loop_count; i++)
			z += (rect + z).left;*/
		PRINT_SPEED2();
	}

	//	+=(point)
	printf("CRect : operator +=(point) (%u Loops) :", loop_count);
	for(i=0; i<loop_count; i++){
		rect += point;
	}
	PRINT_SPEED2();

	//	+=(int)
	printf("CRect : operator +=(int) (%u Loops) :", loop_count);
	for(i=0; i<loop_count; i++){
		rect += 4;
	}
	PRINT_SPEED2();

	//	*(point)
	printf("CRect : operator *(point) (%u Loops) :", loop_count);
	//MessageBox(NULL,NULL,0,0);
	test7(loop_count);
	/*for(i=0; i<loop_count; i++)
		z += (rect * point).left;*/
	PRINT_SPEED2();

	//	*(int)
	printf("CRect : operator *(int) (%u Loops) :", loop_count);
	test8(loop_count);
	/*for(i=0; i<loop_count; i++){
		z += (rect * 4).left;
	}*/
	PRINT_SPEED2();


	//==============================================================

	printf("\n");

	return 0;
}


void mov_test(int loop_count)
{
	int i;
	for(i=0; i<(loop_count/10); i++){
		__asm{
			mov eax, loop_count
			mov eax, loop_count
			mov eax, loop_count
			mov eax, loop_count
			mov eax, loop_count
			mov eax, loop_count
			mov eax, loop_count
			mov eax, loop_count
			mov eax, loop_count
			mov eax, loop_count
			mov eax, loop_count
			mov eax, loop_count
			mov eax, loop_count
			mov eax, loop_count
			mov eax, loop_count
			mov eax, loop_count
			mov eax, loop_count
			mov eax, loop_count
			mov eax, loop_count
			mov eax, loop_count
			mov eax, loop_count
			mov eax, loop_count
			mov eax, loop_count
			mov eax, loop_count
			mov eax, loop_count
			mov eax, loop_count
			mov eax, loop_count
			mov eax, loop_count
			mov eax, loop_count
			mov eax, loop_count
			mov eax, loop_count
			mov eax, loop_count
			mov eax, loop_count
			mov eax, loop_count
			mov eax, loop_count
			mov eax, loop_count
			mov eax, loop_count
			mov eax, loop_count
			mov eax, loop_count
			mov eax, loop_count
			mov eax, loop_count
			mov eax, loop_count
			mov eax, loop_count
			mov eax, loop_count
			mov eax, loop_count
			mov eax, loop_count
			mov eax, loop_count
			mov eax, loop_count
			mov eax, loop_count
			mov eax, loop_count
			mov eax, loop_count
			mov eax, loop_count
			mov eax, loop_count
			mov eax, loop_count
			mov eax, loop_count
			mov eax, loop_count
			mov eax, loop_count
			mov eax, loop_count
			mov eax, loop_count
			mov eax, loop_count
			mov eax, loop_count
			mov eax, loop_count
			mov eax, loop_count
			mov eax, loop_count
			mov eax, loop_count
			mov eax, loop_count
			mov eax, loop_count
			mov eax, loop_count
			mov eax, loop_count
			mov eax, loop_count
			mov eax, loop_count
			mov eax, loop_count
			mov eax, loop_count
			mov eax, loop_count
			mov eax, loop_count
			mov eax, loop_count
			mov eax, loop_count
			mov eax, loop_count
			mov eax, loop_count
			mov eax, loop_count
			mov eax, loop_count
			mov eax, loop_count
			mov eax, loop_count
			mov eax, loop_count
			mov eax, loop_count
			mov eax, loop_count
			mov eax, loop_count
			mov eax, loop_count
			mov eax, loop_count
			mov eax, loop_count
			mov eax, loop_count
			mov eax, loop_count
			mov eax, loop_count
			mov eax, loop_count
			mov eax, loop_count
			mov eax, loop_count
			mov eax, loop_count
			mov eax, loop_count
			mov eax, loop_count
			mov eax, loop_count
		}
	}
}
