#include "agh.h"
#include <time.h>

using namespace agh;

int point_operator_test()
{
	int error_count = 0;
	CPoint point(2,8);
	CPoint point2;
	printf("%d, %d\n", point.x, point.y );

/*	point += 2;
	printf("[point += 2] => %d, %d\n", point.x, point.y );*/
#define POINT_OPERATOR_TEST(OPERATOR,VALUE,EXPECT_X,EXPECT_Y)	\
	point OPERATOR VALUE;	\
	printf("[point %s %s] => %d, %d (expect=%d, %d)\n", #OPERATOR, #VALUE, point.x, point.y, EXPECT_X, EXPECT_Y );	\
	if ( point.x != EXPECT_X || point.y != EXPECT_Y ){ printf("Fail!\n"); error_count++; }

#define POINT_OPERATOR_TEST2(OPERATOR,VALUE,EXPECT_X,EXPECT_Y)	\
	point2 = point OPERATOR VALUE;	\
	printf("[point %s %s] => %d, %d (expect=%d, %d)\n", #OPERATOR, #VALUE, point.x, point.y, EXPECT_X, EXPECT_Y );	\
	if ( point.x != EXPECT_X || point.y != EXPECT_Y ){ printf("Fail!\n"); error_count++; }

	POINT_OPERATOR_TEST( +=, 2, 4,10 );
	POINT_OPERATOR_TEST2( +=, 2, 6,12 );
	POINT_OPERATOR_TEST( -=, 2, 4,10 );
	POINT_OPERATOR_TEST2( -=, 2, 2, 8 );
	POINT_OPERATOR_TEST( *=, 2, 4, 16 );
	POINT_OPERATOR_TEST2( *=, 2, 8, 32 );
	POINT_OPERATOR_TEST( /=, 2, 4, 16 );
	POINT_OPERATOR_TEST2( /=, 2, 2, 8 );

	POINT_OPERATOR_TEST( +=, CPoint(3,4), 5, 12 );
	POINT_OPERATOR_TEST2( +=, CPoint(3,4), 8, 16 );
	POINT_OPERATOR_TEST( -=, CPoint(3,4), 5, 12 );
	POINT_OPERATOR_TEST2( -=, CPoint(3,4), 2, 8 );
	POINT_OPERATOR_TEST( *=, CPoint(3,4), 6, 32 );
	POINT_OPERATOR_TEST2( *=, CPoint(3,4), 18, 128 );
	POINT_OPERATOR_TEST( /=, CPoint(3,4), 6, 32 );
	POINT_OPERATOR_TEST2( /=, CPoint(3,4), 2, 8 );

	return error_count;
}

int main()
{
	int error_count = 0;
	
	error_count += point_operator_test();

	printf("Failed Count = %d\n", error_count );

	/*
void hoge_func(){}
	int a,b,c,d;

#define ABCD_LUMP_OPERATOR(OPERATOR,VALUE)	a OPERATOR VALUE; b OPERATOR VALUE; c OPERATOR VALUE; d OPERATOR VALUE;

	ABCD_LUMP_OPERATOR(=, 0)
	ABCD_LUMP_OPERATOR(+=, 5)

	hoge_func();

	ABCD_LUMP_OPERATOR(++,)

	printf("%d, %d, %d, %d\n",a,b,c,d);
	*/

	return 0;
}
