/*
 * Decompiled with CFR 0.152.
 */
package org.dcm4che.net;

import org.dcm4che.data.Command;

public class DcmServiceException
extends Exception {
    private final int status;
    private int errorID = -1;
    private int actionTypeID = -1;
    private int eventTypeID = -1;

    public DcmServiceException(int status) {
        this.status = status;
    }

    public DcmServiceException(int status, String msg) {
        super(msg);
        this.status = status;
    }

    public DcmServiceException(int status, String msg, Throwable cause) {
        super(msg, cause);
        this.status = status;
    }

    public DcmServiceException(int status, Throwable cause) {
        super(cause);
        this.status = status;
    }

    public int getStatus() {
        return this.status;
    }

    public DcmServiceException setErrorID(int errorID) {
        this.errorID = errorID;
        return this;
    }

    public int getErrorID() {
        return this.errorID;
    }

    public DcmServiceException setEventTypeID(int eventTypeID) {
        this.eventTypeID = eventTypeID;
        return this;
    }

    public int getEventTypeID() {
        return this.eventTypeID;
    }

    public DcmServiceException setActionTypeID(int actionTypeID) {
        this.actionTypeID = actionTypeID;
        return this;
    }

    public int getActionTypeID() {
        return this.actionTypeID;
    }

    public void writeTo(Command cmd) {
        cmd.putUS(2304, this.status);
        String msg = this.getMessage();
        if (msg != null && msg.length() > 0) {
            cmd.putLO(2306, this.toErrorComment(msg));
        }
        if (this.errorID >= 0) {
            cmd.putUS(2307, this.errorID);
        }
        if (this.actionTypeID >= 0) {
            cmd.putUS(4104, this.actionTypeID);
        }
        if (this.eventTypeID >= 0) {
            cmd.putUS(4098, this.eventTypeID);
        }
    }

    private String toErrorComment(String msg) {
        char[] a = msg.toCharArray();
        int len = Math.min(64, a.length);
        for (int i = 0; i < len; ++i) {
            if (a[i] >= ' ' && a[i] <= '\u0126') continue;
            a[i] = 63;
        }
        return new String(a, 0, len);
    }
}

