/*
 * Decompiled with CFR 0.152.
 */
package org.dcm4cheri.net;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.dcm4che.net.CommonExtNegotiation;
import org.dcm4che.net.PDUException;
import org.dcm4cheri.net.AAbortImpl;
import org.dcm4cheri.net.AAssociateRQACImpl;

final class CommonExtNegotiationImpl
implements CommonExtNegotiation {
    private final String sopCUID;
    private final String serviceCUID;
    private final List relGenSopCUIDs;

    CommonExtNegotiationImpl(String sopCUID, String serviceCUID, String[] relGenSopCUIDs) {
        this.sopCUID = sopCUID;
        this.serviceCUID = serviceCUID;
        this.relGenSopCUIDs = relGenSopCUIDs == null ? new ArrayList(0) : new ArrayList<String>(Arrays.asList(relGenSopCUIDs));
    }

    CommonExtNegotiationImpl(DataInputStream din, int len) throws IOException {
        int remaining = len - 6;
        int uidLen = din.readUnsignedShort();
        CommonExtNegotiationImpl.checkLength(remaining -= uidLen, len);
        this.sopCUID = AAssociateRQACImpl.readASCII(din, uidLen);
        uidLen = din.readUnsignedShort();
        CommonExtNegotiationImpl.checkLength(remaining -= uidLen, len);
        this.serviceCUID = AAssociateRQACImpl.readASCII(din, uidLen);
        int uidsLen = din.readUnsignedShort();
        this.relGenSopCUIDs = new ArrayList(1);
        CommonExtNegotiationImpl.checkLength(remaining -= uidsLen, len);
        int remaining2 = uidsLen;
        while (remaining2 > 0) {
            uidLen = din.readUnsignedShort();
            CommonExtNegotiationImpl.checkRelGenSopCUIDsLen(remaining2 -= uidLen, uidsLen);
            this.relGenSopCUIDs.add(AAssociateRQACImpl.readASCII(din, uidLen));
        }
    }

    private static void checkLength(int remaining, int len) throws PDUException {
        if (remaining < 0) {
            CommonExtNegotiationImpl.throwPDUException("Common extended negotiation sub-item length: " + len + " mismatch content length: >=" + (len - remaining));
        }
    }

    private static void checkRelGenSopCUIDsLen(int remaining, int len) throws PDUException {
        if (remaining < 0) {
            CommonExtNegotiationImpl.throwPDUException("Related-general-sop-class-identification-length: " + len + " mismatch content length: >=" + (len - remaining));
        }
    }

    private static void throwPDUException(String msg) throws PDUException {
        throw new PDUException(msg, new AAbortImpl(2, 6));
    }

    public final String getSOPClassUID() {
        return this.sopCUID;
    }

    public final String getServiceClassUID() {
        return this.serviceCUID;
    }

    public final List getRelatedGeneralSOPClassUIDs() {
        return Collections.unmodifiableList(this.relGenSopCUIDs);
    }

    final int length() {
        return 6 + this.sopCUID.length() + this.serviceCUID.length() + this.relGenSopCUIDsLength();
    }

    private int relGenSopCUIDsLength() {
        int len = 0;
        Iterator iter = this.relGenSopCUIDs.iterator();
        while (iter.hasNext()) {
            len += 2 + ((String)iter.next()).length();
        }
        return len;
    }

    void writeTo(DataOutputStream dout) throws IOException {
        dout.write(87);
        dout.write(0);
        dout.writeShort(this.length());
        dout.writeShort(this.sopCUID.length());
        dout.writeBytes(this.sopCUID);
        dout.writeShort(this.serviceCUID.length());
        dout.writeBytes(this.serviceCUID);
        dout.writeShort(this.relGenSopCUIDsLength());
        Iterator iter = this.relGenSopCUIDs.iterator();
        while (iter.hasNext()) {
            String uid = (String)iter.next();
            dout.writeShort(uid.length());
            dout.writeBytes(uid);
        }
    }

    public String toString() {
        StringBuffer sb = new StringBuffer(64);
        sb.append("CommonExtNegotiation[sop=").append(AAssociateRQACImpl.DICT.lookup(this.sopCUID)).append(", service=").append(AAssociateRQACImpl.DICT.lookup(this.serviceCUID));
        Iterator iter = this.relGenSopCUIDs.iterator();
        while (iter.hasNext()) {
            sb.append(", relGenSop=").append(AAssociateRQACImpl.DICT.lookup((String)iter.next()));
        }
        sb.append("]");
        return sb.toString();
    }
}

