/*
 * Decompiled with CFR 0.152.
 */
package org.dcm4cheri.srom;

import java.util.Arrays;
import org.dcm4che.data.Dataset;
import org.dcm4che.data.DcmValueException;
import org.dcm4che.srom.IconImage;

class IconImageImpl
implements IconImage {
    private final int rows;
    private final int columns;
    private final byte[] pixeldata;

    public IconImageImpl(int rows, int columns, byte[] pixeldata) {
        if (rows <= 0) {
            throw new IllegalArgumentException("Rows: " + rows);
        }
        if (columns <= 0) {
            throw new IllegalArgumentException("Columns: " + columns);
        }
        if (pixeldata != null && pixeldata.length != rows * columns) {
            throw new IllegalArgumentException("Length of Pixel Data [" + pixeldata.length + "] do not match Rows [" + rows + "] x Columns [" + columns + "]");
        }
        this.rows = rows;
        this.columns = columns;
        this.pixeldata = pixeldata != null ? pixeldata : new byte[rows * columns];
    }

    public IconImageImpl(Dataset ds) throws DcmValueException {
        this(ds.getInt(2621456, -1), ds.getInt(2621457, -1), ds.getByteBuffer(2145386512).array());
    }

    public static IconImage newIconImage(Dataset ds) throws DcmValueException {
        return ds != null ? new IconImageImpl(ds) : null;
    }

    public String toString() {
        return "Icon[" + this.columns + "x" + this.rows + "]";
    }

    public void toDataset(Dataset ds) {
        ds.putUS(0x280002, 1);
        ds.putCS(2621444, "MONOCHROME2");
        ds.putUS(2621456, this.rows);
        ds.putUS(2621457, this.columns);
        ds.putUS(2621696, 8);
        ds.putUS(2621697, 8);
        ds.putUS(2621698, 7);
        ds.putUS(2621699, 0);
        ds.putOB(2145386512, this.pixeldata);
    }

    public final boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof IconImageImpl)) {
            return false;
        }
        IconImageImpl icon = (IconImageImpl)o;
        return icon.rows == this.rows && icon.columns == this.columns && Arrays.equals(icon.pixeldata, this.pixeldata);
    }

    public final int getRows() {
        return this.rows;
    }

    public final int getColumns() {
        return this.columns;
    }

    public final byte[] getPixelData() {
        return this.pixeldata;
    }
}

