/*
 * Decompiled with CFR 0.152.
 */
package fr.apteryx.imageio.dicom;

import fr.apteryx.imageio.dicom.VOIColorModel;
import java.awt.color.ColorSpace;

public final class VOIWindowColorModelFloat
extends VOIColorModel {
    private final float cs_min;
    private final float cs_max;
    private final float w_center;
    private final float w_width;
    private final float x_low;
    private final float x_high;
    private final double slope;
    private final double intercept;
    private final double slope_unnorm;
    private final double intercept_unnorm;
    private final double slope_255;
    private final double intercept_255;

    public VOIWindowColorModelFloat(float f, float f2, ColorSpace colorSpace) {
        super(4, 32, 32, colorSpace);
        this.cs_min = colorSpace.getMinValue(0);
        this.cs_max = colorSpace.getMaxValue(0);
        this.w_center = f;
        this.w_width = f2;
        this.x_low = (float)((double)this.w_center - 0.5 - (double)((this.w_width - 1.0f) / 2.0f));
        this.x_high = (float)((double)this.w_center - 0.5 + (double)((this.w_width - 1.0f) / 2.0f));
        this.slope = (this.cs_max - this.cs_min) / (this.w_width - 1.0f);
        this.intercept = (double)(this.cs_max - this.cs_min) * (0.5 - ((double)this.w_center - 0.5) / (double)(this.w_width - 1.0f)) + (double)this.cs_min;
        this.slope_unnorm = (float)this.unnorm_max_long / (this.w_width - 1.0f);
        this.intercept_unnorm = (double)this.unnorm_max_long * (0.5 - ((double)this.w_center - 0.5) / (double)(this.w_width - 1.0f));
        this.slope_255 = 255.0 / (double)(this.w_width - 1.0f);
        this.intercept_255 = 255.0 * (0.5 - ((double)this.w_center - 0.5) / (double)(this.w_width - 1.0f));
    }

    public float getMin() {
        return this.x_low;
    }

    public float getMax() {
        return this.x_high;
    }

    public float getCenter() {
        return this.w_center;
    }

    public float getWidth() {
        return this.w_width;
    }

    int getComp(float f) {
        double d = (double)f * this.slope_unnorm + this.intercept_unnorm + 0.5;
        return d < 0.0 ? 0 : (d > (double)this.unnorm_max_long ? this.unnorm_max : (int)d);
    }

    int get255(float f) {
        double d = (double)f * this.slope_255 + this.intercept_255 + 0.5;
        return d < 0.0 ? 0 : (d > 255.0 ? 255 : (int)d);
    }

    float getNorm(float f) {
        float f2 = (float)((double)f * this.slope + this.intercept);
        return f2 < this.cs_min ? this.cs_min : (f2 > this.cs_max ? this.cs_max : f2);
    }

    float getDataElementFloat(float f) {
        float f2 = (float)(((double)f - this.intercept) / this.slope);
        return f2 > this.x_high ? this.x_high : (f2 < this.x_low ? this.x_low : f2);
    }
}

