/*
 * Decompiled with CFR 0.152.
 */
package org.dcm4cheri.image;

import java.awt.image.ColorModel;
import org.apache.log4j.Logger;
import org.dcm4che.data.Dataset;
import org.dcm4che.image.ColorModelParam;

abstract class BasicColorModelParam
implements ColorModelParam {
    private static final Logger log = Logger.getLogger(BasicColorModelParam.class);
    protected final int dataType;
    protected final int size;
    protected final int bits;
    protected final int min;
    protected final int max;
    protected final int shiftmask;
    protected final int alloc;
    protected final int hBit;

    protected BasicColorModelParam(Dataset ds) {
        this.alloc = ds.getInt(2621696, 8);
        if (this.alloc <= 8) {
            this.dataType = 0;
        } else if (this.alloc <= 16) {
            this.dataType = 1;
        } else {
            if (this.alloc <= 32) {
                throw new IllegalArgumentException(this.alloc + " Bits Allocated not supported for Java BufferedImages");
            }
            throw new IllegalArgumentException("Bits allocated " + this.alloc + " not supported");
        }
        this.bits = ds.getInt(2621697, 8);
        this.hBit = ds.getInt(2621698, this.bits - 1);
        this.size = 1 << this.bits;
        if (ds.getInt(2621699, 0) == 0) {
            this.min = 0;
            this.max = this.size;
        } else {
            this.max = this.size >> 1;
            this.min = -this.max;
        }
        this.shiftmask = 32 - this.bits;
        log.debug("max=" + this.max + " min=" + this.min + " bits=" + this.bits + " hBit=" + this.hBit + " size=" + this.size);
    }

    protected BasicColorModelParam(BasicColorModelParam other) {
        this.alloc = other.alloc;
        this.hBit = other.hBit;
        this.dataType = other.dataType;
        this.size = other.size;
        this.bits = other.bits;
        this.min = other.min;
        this.max = other.max;
        this.shiftmask = other.shiftmask;
    }

    public final int toSampleValue(int pxValue) {
        return this.min != 0 ? pxValue << this.shiftmask >> this.shiftmask : pxValue << this.shiftmask >>> this.shiftmask;
    }

    public final int toPixelValueRaw(int sampleValue) {
        int bsMask = (1 << this.bits) - 1;
        int packedValue = (sampleValue & bsMask) << this.hBit - this.bits + 1;
        return packedValue;
    }

    public abstract ColorModel newColorModel();

    public abstract ColorModelParam update(float var1, float var2, boolean var3);

    public abstract float getRescaleSlope();

    public abstract float getRescaleIntercept();

    public abstract float getWindowCenter(int var1);

    public abstract float getWindowWidth(int var1);

    public abstract int getNumberOfWindows();

    public abstract float toMeasureValue(int var1);

    public abstract int toPixelValue(float var1);

    public abstract boolean isInverse();

    public abstract boolean isCacheable();
}

