/*
 * Decompiled with CFR 0.152.
 */
package org.dcm4cheri.srom;

import org.apache.log4j.Logger;
import org.dcm4che.data.Dataset;
import org.dcm4che.data.DcmElement;
import org.dcm4che.data.DcmValueException;
import org.dcm4che.srom.Code;

class CodeImpl
implements Code {
    static final Code[] EMPTY_ARRAY = new Code[0];
    private static final int MEANING_PROMPT_LEN = 32;
    static Logger log = Logger.getLogger(CodeImpl.class);
    private final String codeValue;
    private final String codingSchemeDesignator;
    private final String codingSchemeVersion;
    private final String codeMeaning;

    private String check(String val, String prompt, String def) {
        if (val == null || val.length() == 0) {
            log.warn(prompt);
            return def;
        }
        return val;
    }

    public CodeImpl(String codeValue, String codingSchemeDesignator, String codingSchemeVersion, String codeMeaning) {
        this.codeValue = this.check(codeValue, "Missing (0008,0100) Code Value - insert \"__NULL__\"", "__NULL__");
        this.codingSchemeDesignator = this.check(codingSchemeDesignator, "Missing (0008,0102) Coding Scheme Designator - insert \"99NULL\"", "99NULL");
        this.codingSchemeVersion = codingSchemeVersion;
        this.codeMeaning = this.check(codeMeaning, "Missing (0008,0104) Code Meaning - insert \"__NULL__\"", "__NULL__");
    }

    public CodeImpl(Dataset ds) throws DcmValueException {
        this(ds.getString(524544), ds.getString(524546), ds.getString(524547), ds.getString(524548));
    }

    public static Code newCode(Dataset ds) throws DcmValueException {
        return ds != null ? new CodeImpl(ds) : null;
    }

    public static Code[] newCodes(DcmElement sq) throws DcmValueException {
        if (sq == null || sq.isEmpty()) {
            return EMPTY_ARRAY;
        }
        Code[] a = new Code[sq.countItems()];
        for (int i = 0; i < a.length; ++i) {
            a[i] = new CodeImpl(sq.getItem(i));
        }
        return a;
    }

    public final String getCodeValue() {
        return this.codeValue;
    }

    public final String getCodingSchemeDesignator() {
        return this.codingSchemeDesignator;
    }

    public final String getCodingSchemeVersion() {
        return this.codingSchemeVersion;
    }

    public final String getCodeMeaning() {
        return this.codeMeaning;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof CodeImpl)) {
            return false;
        }
        CodeImpl o = (CodeImpl)obj;
        if (!this.codeValue.equals(o.codeValue)) {
            return false;
        }
        if (!this.codingSchemeDesignator.equals(o.codingSchemeDesignator)) {
            return false;
        }
        return this.codingSchemeVersion == null ? o.codingSchemeVersion == null : this.codingSchemeVersion.equals(o.codingSchemeVersion);
    }

    public int hashCode() {
        return this.codeValue.hashCode();
    }

    public String toString() {
        return "(" + this.codeValue + "," + this.codingSchemeDesignator + ",\"" + (this.codeMeaning.length() <= 32 ? this.codeMeaning : this.codeMeaning.substring(0, 32) + "..") + "\")";
    }

    public void toDataset(Dataset ds) {
        ds.putSH(524544, this.codeValue);
        ds.putSH(524546, this.codingSchemeDesignator);
        if (this.codingSchemeVersion != null) {
            ds.putSH(524547, this.codingSchemeVersion);
        }
        ds.putLO(524548, this.codeMeaning);
    }
}

