/*
 * Decompiled with CFR 0.152.
 */
package org.dcm4cheri.srom;

import java.util.Date;
import org.dcm4che.data.Dataset;
import org.dcm4che.data.DcmElement;
import org.dcm4che.data.DcmObjectFactory;
import org.dcm4che.data.DcmValueException;
import org.dcm4che.srom.Code;
import org.dcm4che.srom.Content;
import org.dcm4che.srom.KeyObject;
import org.dcm4che.srom.TCoordContent;
import org.dcm4che.srom.Template;
import org.dcm4cheri.srom.CodeContentImpl;
import org.dcm4cheri.srom.CodeImpl;
import org.dcm4cheri.srom.CompositeContentImpl;
import org.dcm4cheri.srom.ContainerContentImpl;
import org.dcm4cheri.srom.DateContentImpl;
import org.dcm4cheri.srom.DateTimeContentImpl;
import org.dcm4cheri.srom.IconImageImpl;
import org.dcm4cheri.srom.ImageContentImpl;
import org.dcm4cheri.srom.KeyObjectImpl;
import org.dcm4cheri.srom.NumContentImpl;
import org.dcm4cheri.srom.PNameContentImpl;
import org.dcm4cheri.srom.RefSOPImpl;
import org.dcm4cheri.srom.ReferencedContentImpl;
import org.dcm4cheri.srom.SCoordContentImpl;
import org.dcm4cheri.srom.TCoordContentImpl;
import org.dcm4cheri.srom.TemplateImpl;
import org.dcm4cheri.srom.TextContentImpl;
import org.dcm4cheri.srom.TimeContentImpl;
import org.dcm4cheri.srom.UIDRefContentImpl;
import org.dcm4cheri.srom.WaveformContentImpl;

abstract class ContentImpl
implements Content {
    static final DcmObjectFactory dsfact = DcmObjectFactory.getInstance();
    protected KeyObjectImpl owner;
    protected Content.RelationType relation;
    protected ContentImpl parent;
    protected ContentImpl firstChild;
    protected ContentImpl lastChild;
    protected ContentImpl next;
    protected ContentImpl prev;

    ContentImpl(KeyObject owner) {
        this.owner = (KeyObjectImpl)owner;
    }

    static ContentImpl newContent(KeyObject owner, Dataset ds) throws DcmValueException {
        int[] refContentId = ds.getInts(4250483);
        if (refContentId != null) {
            return new ReferencedContentImpl(owner, refContentId);
        }
        ContentImpl retval = ContentImpl.newContent(owner, ds, ds.getDate(4235314), TemplateImpl.newTemplate(ds.getItem(4236548)), CodeImpl.newCode(ds.getItem(4235331)), ds.getString(0x40A040));
        retval.initChilds(owner, ds);
        return retval;
    }

    static ContentImpl newContent(KeyObject owner, Dataset ds, Date obsDateTime, Template template, Code name, String type) throws DcmValueException {
        if ("CONTAINER".equals(type)) {
            return new ContainerContentImpl(owner, obsDateTime, template, name, "SEPARATE".equals(ds.getString(4235344)));
        }
        if ("TEXT".equals(type)) {
            return new TextContentImpl(owner, obsDateTime, template, name, ds.getString(4235616));
        }
        if ("NUM".equals(type)) {
            Dataset mv = ds.getItem(4236032);
            Dataset mq = ds.getItem(4236033);
            return new NumContentImpl(owner, obsDateTime, template, name, mv != null ? mv.getFloat(4236042) : null, mv != null ? CodeImpl.newCode(mv.getItem(4196586)) : null, CodeImpl.newCode(ds.getItem(4236033)));
        }
        if ("CODE".equals(type)) {
            return new CodeContentImpl(owner, obsDateTime, template, name, CodeImpl.newCode(ds.getItem(4235624)));
        }
        if ("DATETIME".equals(type)) {
            return new DateTimeContentImpl(owner, obsDateTime, template, name, ds.getDate(4235552));
        }
        if ("DATE".equals(type)) {
            return new DateContentImpl(owner, obsDateTime, template, name, ds.getDate(4235553));
        }
        if ("TIME".equals(type)) {
            return new TimeContentImpl(owner, obsDateTime, template, name, ds.getDate(4235554));
        }
        if ("UIDREF".equals(type)) {
            return new UIDRefContentImpl(owner, obsDateTime, template, name, ds.getString(4235556));
        }
        if ("PNAME".equals(type)) {
            return new PNameContentImpl(owner, obsDateTime, template, name, ds.getString(4235555));
        }
        if ("COMPOSITE".equals(type)) {
            return new CompositeContentImpl(owner, obsDateTime, template, name, RefSOPImpl.newRefSOP(ds.getItem(528793)));
        }
        if ("IMAGE".equals(type)) {
            Dataset sop = ds.getItem(528793);
            Dataset pr = sop.getItem(528793);
            Dataset icon = sop.getItem(0x880200);
            return new ImageContentImpl(owner, obsDateTime, template, name, RefSOPImpl.newRefSOP(sop), sop.getInts(528736), RefSOPImpl.newRefSOP(pr), IconImageImpl.newIconImage(icon));
        }
        if ("WAVEFORM".equals(type)) {
            Dataset sop = ds.getItem(528793);
            return new WaveformContentImpl(owner, obsDateTime, template, name, RefSOPImpl.newRefSOP(sop), sop.getInts(4235440));
        }
        if ("SCOORD".equals(type)) {
            String graphicType = ds.getString(7340067);
            if ("POINT".equals(graphicType)) {
                return new SCoordContentImpl.Point(owner, obsDateTime, template, name, ds.getFloats(0x700022));
            }
            if ("MULTIPOINT".equals(graphicType)) {
                return new SCoordContentImpl.MultiPoint(owner, obsDateTime, template, name, ds.getFloats(0x700022));
            }
            if ("POLYLINE".equals(graphicType)) {
                return new SCoordContentImpl.Polyline(owner, obsDateTime, template, name, ds.getFloats(0x700022));
            }
            if ("CIRCLE".equals(graphicType)) {
                return new SCoordContentImpl.Circle(owner, obsDateTime, template, name, ds.getFloats(0x700022));
            }
            if ("ELLIPSE".equals(graphicType)) {
                return new SCoordContentImpl.Ellipse(owner, obsDateTime, template, name, ds.getFloats(0x700022));
            }
            throw new IllegalArgumentException(graphicType);
        }
        if ("TCOORD".equals(type)) {
            String rangeType = ds.getString(4235568);
            TCoordContent.Positions pos = TCoordContentImpl.newPositions(ds);
            if ("POINT".equals(rangeType)) {
                return new TCoordContentImpl.Point(owner, obsDateTime, template, name, pos);
            }
            if ("MULTIPOINT".equals(rangeType)) {
                return new TCoordContentImpl.MultiPoint(owner, obsDateTime, template, name, pos);
            }
            if ("SEGMENT".equals(rangeType)) {
                return new TCoordContentImpl.Segment(owner, obsDateTime, template, name, pos);
            }
            if ("MULTISEGMENT".equals(rangeType)) {
                return new TCoordContentImpl.MultiSegment(owner, obsDateTime, template, name, pos);
            }
            if ("BEGIN".equals(rangeType)) {
                return new TCoordContentImpl.Begin(owner, obsDateTime, template, name, pos);
            }
            if ("END".equals(rangeType)) {
                return new TCoordContentImpl.End(owner, obsDateTime, template, name, pos);
            }
            throw new IllegalArgumentException(rangeType);
        }
        throw new IllegalArgumentException(type);
    }

    StringBuffer prompt() {
        StringBuffer sb = ContentImpl.appendID(new StringBuffer(), this.getID());
        if (this.relation != null) {
            sb.append(this.relation.toString().toLowerCase()).append(' ');
        }
        return sb;
    }

    static StringBuffer appendID(StringBuffer sb, int[] id) {
        if (id == null) {
            return sb.append("(null)");
        }
        sb.append('(').append(id[0]);
        for (int i = 1; i < id.length; ++i) {
            sb.append('.').append(id[i]);
        }
        return sb.append(')');
    }

    static String promptID(int[] id) {
        return ContentImpl.appendID(new StringBuffer(), id).toString();
    }

    public int[] getID() {
        int n = 1;
        ContentImpl r = this;
        ContentImpl p = this.parent;
        while (p != null) {
            ++n;
            r = p;
            p = p.parent;
        }
        if (r != this.owner) {
            return null;
        }
        int[] id = new int[n];
        ContentImpl p2 = this.parent;
        ContentImpl c = this;
        while (p2 != null) {
            id[--n] = 1;
            ContentImpl cur = p2.firstChild;
            while (cur != c) {
                int n2 = n;
                id[n2] = id[n2] + 1;
                cur = cur.next;
            }
            c = p2;
            p2 = p2.parent;
        }
        id[0] = 1;
        return id;
    }

    public KeyObject getOwnerDocument() {
        return this.owner;
    }

    public Content.RelationType getRelationType() {
        return this.relation;
    }

    public Content getParent() {
        return this.parent;
    }

    public boolean hasChildren() {
        return this.getFirstChild() != null;
    }

    public Content getFirstChild() {
        return this.firstChild;
    }

    private static Content find(Content.RelationType rel, Code name, Content start) {
        for (Content cur = start; cur != null; cur = cur.getNextSibling()) {
            if (rel != null && rel != cur.getRelationType() || name != null && !((Object)name).equals(cur.getName())) continue;
            return cur;
        }
        return null;
    }

    public Content getFirstChildBy(Content.RelationType rel, Code name) {
        return ContentImpl.find(rel, name, this.getFirstChild());
    }

    public Content getLastChild() {
        return this.lastChild;
    }

    public Content getPreviousSibling() {
        return this.prev;
    }

    public Content getNextSibling() {
        return this.next;
    }

    public Content getNextSiblingBy(Content.RelationType rel, Code name) {
        return ContentImpl.find(rel, name, this.next);
    }

    public Content appendChild(Content.RelationType rel, Content newnode) {
        return this.insertBefore(rel, newnode, null);
    }

    public Content insertBefore(Content.RelationType rel, Content newnode, Content refnode) {
        if (rel == null) {
            throw new NullPointerException();
        }
        if (newnode == null) {
            throw new NullPointerException();
        }
        ContentImpl newNode = (ContentImpl)newnode;
        ContentImpl refNode = (ContentImpl)refnode;
        if (newNode == this.owner) {
            throw new IllegalArgumentException();
        }
        if (newNode.owner != this.owner) {
            throw new IllegalArgumentException();
        }
        if (newNode.parent != null) {
            throw new IllegalArgumentException();
        }
        if (refnode != null && refNode.parent != this) {
            throw new IllegalArgumentException();
        }
        if (this.owner.getRelationConstraints() != null) {
            this.owner.getRelationConstraints().check(this, rel, newnode);
        }
        newNode.parent = this;
        newNode.relation = rel;
        newNode.next = refNode;
        if (refNode == null) {
            newNode.prev = this.lastChild;
            this.lastChild = newNode;
        } else {
            newNode.prev = refNode.prev;
            refNode.prev = newNode;
        }
        if (newNode.prev == null) {
            this.firstChild = newNode;
        } else {
            newNode.prev.next = newNode;
        }
        return newnode;
    }

    public Content replaceChild(Content.RelationType rel, Content newnode, Content oldnode) {
        if (oldnode == null) {
            throw new NullPointerException();
        }
        if (newnode == oldnode) {
            return newnode;
        }
        this.insertBefore(rel, newnode, oldnode);
        return this.removeChild(oldnode);
    }

    public Content removeChild(Content oldnode) {
        ContentImpl oldNode = (ContentImpl)oldnode;
        if (oldNode == null) {
            throw new NullPointerException();
        }
        if (oldNode.parent != this) {
            throw new IllegalArgumentException("" + oldnode + " is NOT a child of " + this);
        }
        if (oldNode.prev != null) {
            oldNode.prev.next = oldNode.next;
        } else {
            this.firstChild = oldNode.next;
        }
        if (oldNode.next != null) {
            oldNode.next.prev = oldNode.prev;
        } else {
            this.lastChild = oldNode.prev;
        }
        oldNode.next = null;
        oldNode.prev = null;
        oldNode.parent = null;
        return oldnode;
    }

    public Content clone(boolean deep) {
        return this.clone(this.owner, deep, true);
    }

    Content clone(KeyObject newOwner, boolean deep, boolean inheritObsDateTime) {
        Content clone = this.clone(newOwner, inheritObsDateTime);
        if (deep) {
            ContentImpl child = this.firstChild;
            while (child != null) {
                clone.appendChild(child.relation, child.clone(newOwner, true, false));
                child = child.next;
            }
        }
        return clone;
    }

    abstract Content clone(KeyObject var1, boolean var2);

    public void toDataset(Dataset ds) {
        Date obsDateTime;
        Template tpl;
        if (this.relation != null) {
            ds.putCS(4235280, this.relation.toString());
        }
        ds.putCS(0x40A040, this.getValueType().toString());
        DcmElement cnSq = ds.putSQ(4235331);
        Code name = this.getName();
        if (name != null) {
            name.toDataset(cnSq.addNewItem());
        }
        if ((tpl = this.getTemplate()) != null) {
            tpl.toDataset(ds.putSQ(4236548).addNewItem());
        }
        if ((obsDateTime = this.getObservationDateTime(false)) != null) {
            ds.putDT(4235314, obsDateTime);
        }
        if (this.firstChild != null) {
            DcmElement sq = ds.putSQ(4237104);
            for (Content child = this.firstChild; child != null; child = child.getNextSibling()) {
                child.toDataset(sq.addNewItem());
            }
        }
    }

    protected void initChilds(KeyObject owner, Dataset ds) throws DcmValueException {
        DcmElement sq = ds.get(4237104);
        if (sq == null) {
            return;
        }
        int n = sq.countItems();
        for (int i = 0; i < n; ++i) {
            Dataset child = sq.getItem(i);
            this.appendChild(Content.RelationType.valueOf(child.getString(4235280)), ContentImpl.newContent(owner, child));
        }
    }
}

