/*
 * Decompiled with CFR 0.152.
 */
package org.dcm4che;

import java.util.ResourceBundle;

public class Implementation {
    private static final ResourceBundle rb = ResourceBundle.getBundle("org/dcm4che/Implementation");

    public static String getClassUID() {
        return rb.getString("dcm4che.ImplementationClassUID");
    }

    public static String getVersionName() {
        return rb.getString("dcm4che.ImplementationVersionName");
    }

    public static Object findFactory(String key) {
        ClassLoader loader = Thread.currentThread().getContextClassLoader();
        String name = rb.getString(key);
        try {
            return loader.loadClass(name).newInstance();
        }
        catch (ClassNotFoundException ex) {
            throw new ConfigurationError("class not found: " + name, ex);
        }
        catch (InstantiationException ex) {
            throw new ConfigurationError("could not instantiate: " + name, ex);
        }
        catch (IllegalAccessException ex) {
            throw new ConfigurationError("could not instantiate: " + name, ex);
        }
    }

    private Implementation() {
    }

    static class ConfigurationError
    extends Error {
        ConfigurationError(String msg, Exception x) {
            super(msg, x);
        }
    }
}

