/*
 * Decompiled with CFR 0.152.
 */
package org.dcm4cheri.image;

import java.io.BufferedOutputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import javax.imageio.ImageIO;
import javax.imageio.stream.ImageOutputStream;
import org.dcm4che.image.PixelDataDescription;
import org.dcm4che.image.PixelDataWriter;

public class PixelDataWriterImpl
implements PixelDataWriter {
    private final ImageOutputStream out;
    private final int[][][] data;
    private final int sampleOffset;
    private final boolean containsOverlayData;
    private final PixelDataDescription pdDesc;
    private final int cols;
    private final int rows;
    private final int nf;
    private final int frameSize;
    private final int size;
    private final int samplesPerFrame;
    private final int ba;
    private final int bs;
    private final int hb;
    private final int spp;
    private final boolean signed;
    private final boolean byPlane;
    private final String pmi;
    private final ByteOrder byteOrder;
    private final int pixelDataVr;

    PixelDataWriterImpl(int[][][] data, boolean containsOverlayData, PixelDataDescription desc, ImageOutputStream out) {
        if (desc == null) {
            throw new IllegalArgumentException("pixel data description can not be null");
        }
        this.containsOverlayData = containsOverlayData;
        this.pdDesc = desc;
        this.cols = desc.getCols();
        this.rows = desc.getRows();
        this.nf = desc.getNumberOfFrames();
        this.frameSize = desc.getFrameSize();
        this.size = desc.getSize();
        this.samplesPerFrame = desc.getSamplesPerFrame();
        this.ba = desc.getBitsAllocated();
        this.bs = desc.getBitsStored();
        this.hb = desc.getHighBit();
        this.spp = desc.getSamplesPerPixel();
        this.signed = desc.isSigned();
        this.byPlane = desc.isByPlane();
        this.pmi = desc.getPmi();
        this.byteOrder = desc.getByteOrder();
        this.pixelDataVr = desc.getPixelDataVr();
        if (out == null) {
            throw new IllegalArgumentException("out can not be null");
        }
        this.out = out;
        if (data == null) {
            throw new IllegalArgumentException("data can not be null");
        }
        this.data = data;
        this.sampleOffset = this.hb - this.bs + 1;
        if (this.pixelDataVr == 20311) {
            out.setByteOrder(this.byteOrder);
        } else {
            out.setByteOrder(ByteOrder.LITTLE_ENDIAN);
        }
    }

    public ByteBuffer writePixelDataToByteBuffer() {
        ByteArrayOutputStream buff = new ByteArrayOutputStream(this.size * this.ba >>> 3){

            public synchronized byte[] toByteArray() {
                return this.buf;
            }
        };
        try {
            ImageOutputStream out = ImageIO.createImageOutputStream(new BufferedOutputStream(buff));
            this.writePixelData(out);
            out.flush();
            out.close();
            return ByteBuffer.wrap(buff.toByteArray(), 0, buff.size());
        }
        catch (IOException ioe) {
            return null;
        }
    }

    public void writePixelData() throws IOException {
        this.writePixelData(this.out);
    }

    public void writePixelData(ImageOutputStream out) throws IOException {
        int cellBits = this.ba;
        int w = 0;
        int bNeeded = 16;
        int bUsed = 0;
        if (this.byPlane) {
            for (int f = 0; f < this.nf; ++f) {
                for (int s = 0; s < this.spp; ++s) {
                    int p = 0;
                    while (p < this.frameSize) {
                        w |= this.data[f][s][p] >>> bUsed << 16 - bNeeded;
                        int read = cellBits - bUsed;
                        if (read < bNeeded) {
                            bUsed = 0;
                            bNeeded -= read;
                            ++p;
                            continue;
                        }
                        if ((bUsed += bNeeded) == cellBits) {
                            ++p;
                            bUsed = 0;
                        }
                        bNeeded = 16;
                        out.writeShort(w);
                        w = 0;
                    }
                }
            }
        } else {
            for (int f = 0; f < this.nf; ++f) {
                for (int p = 0; p < this.frameSize; ++p) {
                    int s = 0;
                    while (s < this.spp) {
                        w |= this.data[f][s][p] >>> bUsed << 16 - bNeeded;
                        int read = cellBits - bUsed;
                        if (read < bNeeded) {
                            bUsed = 0;
                            bNeeded -= read;
                            ++s;
                            continue;
                        }
                        if ((bUsed += bNeeded) == cellBits) {
                            ++s;
                            bUsed = 0;
                        }
                        bNeeded = 16;
                        out.writeShort(w);
                        w = 0;
                    }
                }
            }
        }
    }

    public PixelDataDescription getPixelDataDescription() {
        return this.pdDesc;
    }
}

