/*
 * Decompiled with CFR 0.152.
 */
package org.dcm4cheri.net;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import org.dcm4che.Implementation;
import org.dcm4che.net.AAssociateAC;
import org.dcm4che.net.AAssociateRJException;
import org.dcm4che.net.AAssociateRQ;
import org.dcm4che.net.AETFilter;
import org.dcm4che.net.AcceptorPolicy;
import org.dcm4che.net.Association;
import org.dcm4che.net.AsyncOpsWindow;
import org.dcm4che.net.ExtNegotiation;
import org.dcm4che.net.ExtNegotiator;
import org.dcm4che.net.PDU;
import org.dcm4che.net.PresContext;
import org.dcm4che.net.RoleSelection;
import org.dcm4che.net.UserIdentityAC;
import org.dcm4che.net.UserIdentityNegotiator;
import org.dcm4che.net.UserIdentityRQ;
import org.dcm4cheri.net.AAssociateACImpl;
import org.dcm4cheri.net.AAssociateRJImpl;
import org.dcm4cheri.net.AsyncOpsWindowImpl;
import org.dcm4cheri.net.ExtNegotiationImpl;
import org.dcm4cheri.net.PresContextImpl;
import org.dcm4cheri.net.RoleSelectionImpl;
import org.dcm4cheri.net.UserIdentityACImpl;
import org.dcm4cheri.util.StringUtils;

class AcceptorPolicyImpl
implements AcceptorPolicy {
    private static final UserIdentityNegotiator DEF_USER_IDENTITY_NEGOTIATOR = new UserIdentityNegotiator(){

        public UserIdentityAC negotiate(Association assoc) {
            UserIdentityRQ rq = assoc.getAAssociateRQ().getUserIdentity();
            return rq != null && rq.isPositiveResponseRequested() ? new UserIdentityACImpl() : null;
        }
    };
    private int maxLength = 16352;
    private AsyncOpsWindow aow = null;
    private String implClassUID = Implementation.getClassUID();
    private String implVers = Implementation.getVersionName();
    private HashMap appCtxMap = new HashMap();
    private final HashSet calledAETs = new HashSet();
    private AETFilter calledAETFilter = new AETFilter(){

        public boolean accept(String aet) {
            return AcceptorPolicyImpl.this.calledAETs.isEmpty() || AcceptorPolicyImpl.this.calledAETs.contains(aet);
        }
    };
    private final HashSet callingAETs = new HashSet();
    private AETFilter callingAETFilter = new AETFilter(){

        public boolean accept(String aet) {
            return AcceptorPolicyImpl.this.callingAETs.isEmpty() || AcceptorPolicyImpl.this.callingAETs.contains(aet);
        }
    };
    private HashMap policyForCalledAET = new HashMap();
    private HashMap policyForCallingAET = new HashMap();
    private UserIdentityNegotiator userIdentityNegotiator = DEF_USER_IDENTITY_NEGOTIATOR;
    private LinkedHashMap presCtxMap = new LinkedHashMap();
    private HashMap roleSelectionMap = new HashMap();
    private HashMap extNegotiaionMap = new HashMap();

    public AcceptorPolicyImpl() {
        this.putPresContext("1.2.840.10008.1.1", new String[]{"1.2.840.10008.1.2"});
    }

    public void setMaxPDULength(int maxLength) {
        if (maxLength < 0) {
            throw new IllegalArgumentException("maxLength:" + maxLength);
        }
        this.maxLength = maxLength;
    }

    public int getMaxPDULength() {
        return this.maxLength;
    }

    public AsyncOpsWindow getAsyncOpsWindow() {
        return this.aow;
    }

    public void setAsyncOpsWindow(int maxOpsInvoked, int maxOpsPerformed) {
        if (maxOpsInvoked == 1 && maxOpsPerformed == 1) {
            this.aow = null;
        } else if (this.aow == null || this.aow.getMaxOpsInvoked() != maxOpsInvoked || this.aow.getMaxOpsPerformed() != maxOpsPerformed) {
            this.aow = new AsyncOpsWindowImpl(maxOpsInvoked, maxOpsPerformed);
        }
    }

    public void setImplClassUID(String implClassUID) {
        this.implClassUID = StringUtils.checkUID(implClassUID);
    }

    public String getImplClassUID() {
        return this.implClassUID;
    }

    public void setImplVersionName(String implVers) {
        this.implVers = implVers != null ? StringUtils.checkAET(implVers) : null;
    }

    public String getImplVersionName() {
        return this.implVers;
    }

    public String putApplicationContextName(String proposed, String returned) {
        return this.appCtxMap.put(StringUtils.checkUID(proposed), StringUtils.checkUID(returned));
    }

    public boolean addCalledAET(String aet) {
        StringUtils.checkAET(aet);
        return this.calledAETs.add(aet);
    }

    public boolean removeCalledAET(String aet) {
        return this.calledAETs.remove(aet);
    }

    public void setCalledAETs(String[] aets) {
        if (aets == null) {
            this.calledAETs.clear();
        } else {
            StringUtils.checkAETs(aets);
            this.calledAETs.clear();
            this.calledAETs.addAll(Arrays.asList(aets));
        }
    }

    public String[] getCalledAETs() {
        return this.calledAETs.toArray(new String[this.calledAETs.size()]);
    }

    public boolean addCallingAET(String aet) {
        StringUtils.checkAET(aet);
        return this.callingAETs.add(aet);
    }

    public boolean removeCallingAET(String aet) {
        return this.callingAETs.remove(aet);
    }

    public void setCallingAETs(String[] aets) {
        if (aets == null) {
            this.callingAETs.clear();
        } else {
            StringUtils.checkAETs(aets);
            this.callingAETs.clear();
            this.callingAETs.addAll(Arrays.asList(aets));
        }
    }

    public String[] getCallingAETs() {
        return this.callingAETs.toArray(new String[this.callingAETs.size()]);
    }

    public void setCalledAETFilter(AETFilter filter) {
        this.calledAETFilter = filter;
    }

    public AETFilter getCalledAETFilter() {
        return this.calledAETFilter;
    }

    public void setCallingAETFilter(AETFilter filter) {
        this.callingAETFilter = filter;
    }

    public AETFilter getCallingAETFilter() {
        return this.callingAETFilter;
    }

    public AcceptorPolicy getPolicyForCallingAET(String aet) {
        return (AcceptorPolicy)this.policyForCallingAET.get(aet);
    }

    public AcceptorPolicy putPolicyForCallingAET(String aet, AcceptorPolicy policy) {
        return this.putPolicyForXXXAET(aet, policy, this.policyForCallingAET);
    }

    public AcceptorPolicy getPolicyForCalledAET(String aet) {
        return (AcceptorPolicy)this.policyForCalledAET.get(aet);
    }

    public AcceptorPolicy putPolicyForCalledAET(String aet, AcceptorPolicy policy) {
        return this.putPolicyForXXXAET(aet, policy, this.policyForCalledAET);
    }

    private AcceptorPolicy putPolicyForXXXAET(String aet, AcceptorPolicy policy, HashMap map) {
        if (policy != null) {
            return map.put(StringUtils.checkAET(aet), policy);
        }
        return (AcceptorPolicy)map.remove(aet);
    }

    public final PresContext putPresContext(String asuid, String[] tsuids) {
        if (tsuids != null) {
            return this.presCtxMap.put(asuid, new PresContextImpl(32, 1, 0, StringUtils.checkUID(asuid), StringUtils.checkUIDs(tsuids)));
        }
        return (PresContext)this.presCtxMap.remove(asuid);
    }

    public PresContext getPresContext(String as) {
        return (PresContext)this.presCtxMap.get(as);
    }

    public RoleSelection putRoleSelection(String uid, boolean scu, boolean scp) {
        return this.roleSelectionMap.put(StringUtils.checkUID(uid), new RoleSelectionImpl(uid, scu, scp));
    }

    public RoleSelection getRoleSelection(String uid) {
        return (RoleSelection)this.roleSelectionMap.get(uid);
    }

    public RoleSelection removeRoleSelection(String uid) {
        return (RoleSelection)this.roleSelectionMap.remove(uid);
    }

    public ExtNegotiator putExtNegPolicy(String uid, ExtNegotiator en) {
        if (en != null) {
            return this.extNegotiaionMap.put(uid, en);
        }
        return (ExtNegotiator)this.extNegotiaionMap.remove(uid);
    }

    public ExtNegotiator getExtNegPolicy(String uid) {
        return (ExtNegotiator)this.extNegotiaionMap.get(uid);
    }

    public final void setUserIdentityNegotiator(UserIdentityNegotiator userIdentityNegotiator) {
        if (userIdentityNegotiator == null) {
            throw new NullPointerException();
        }
        this.userIdentityNegotiator = userIdentityNegotiator;
    }

    public final UserIdentityNegotiator getUserIdentityNegotiator() {
        return this.userIdentityNegotiator;
    }

    public PDU negotiate(Association assoc) {
        AAssociateRQ rq = assoc.getAAssociateRQ();
        if ((rq.getProtocolVersion() & 1) == 0) {
            return new AAssociateRJImpl(1, 2, 2);
        }
        String calledAET = rq.getCalledAET();
        if (this.calledAETFilter != null && !this.calledAETFilter.accept(calledAET)) {
            return new AAssociateRJImpl(1, 1, 7);
        }
        AcceptorPolicyImpl policy1 = (AcceptorPolicyImpl)this.getPolicyForCalledAET(calledAET);
        if (policy1 == null) {
            policy1 = this;
        }
        String callingAET = rq.getCallingAET();
        if (policy1.callingAETFilter != null && !policy1.callingAETFilter.accept(callingAET)) {
            return new AAssociateRJImpl(1, 1, 3);
        }
        AcceptorPolicyImpl policy2 = (AcceptorPolicyImpl)policy1.getPolicyForCallingAET(callingAET);
        if (policy2 == null) {
            policy2 = policy1;
        }
        return policy2.doNegotiate(assoc, rq);
    }

    private PDU doNegotiate(Association assoc, AAssociateRQ rq) {
        String appCtx = this.negotiateAppCtx(rq.getApplicationContext());
        if (appCtx == null) {
            return new AAssociateRJImpl(1, 1, 2);
        }
        AAssociateACImpl ac = new AAssociateACImpl();
        ac.setApplicationContext(appCtx);
        ac.setCalledAET(rq.getCalledAET());
        ac.setCallingAET(rq.getCallingAET());
        ac.setMaxPDULength(this.maxLength);
        ac.setImplClassUID(this.implClassUID);
        ac.setImplVersionName(this.implVers);
        ac.setAsyncOpsWindow(this.negotiateAOW(rq.getAsyncOpsWindow()));
        try {
            ac.setUserIdentity(this.userIdentityNegotiator.negotiate(assoc));
        }
        catch (AAssociateRJException e) {
            return e.getAAssociateRJ();
        }
        this.negotiatePresCtx(rq, ac);
        this.negotiateRoleSelection(rq, ac);
        this.negotiateExt(rq, ac);
        return ac;
    }

    private String negotiateAppCtx(String proposed) {
        String retval = (String)this.appCtxMap.get(proposed);
        if (retval != null) {
            return retval;
        }
        if ("1.2.840.10008.3.1.1.1".equals(proposed)) {
            return proposed;
        }
        return null;
    }

    private void negotiatePresCtx(AAssociateRQ rq, AAssociateAC ac) {
        Iterator it = rq.listPresContext().iterator();
        while (it.hasNext()) {
            ac.addPresContext(this.negotiatePresCtx((PresContext)it.next()));
        }
    }

    private PresContext negotiatePresCtx(PresContext offered) {
        int result = 3;
        String tsuid = offered.getTransferSyntaxUID();
        PresContext accept = this.getPresContext(offered.getAbstractSyntaxUID());
        if (accept != null) {
            result = 4;
            Iterator it = accept.getTransferSyntaxUIDs().iterator();
            while (it.hasNext()) {
                tsuid = (String)it.next();
                if (offered.getTransferSyntaxUIDs().indexOf(tsuid) == -1) continue;
                result = 0;
                break;
            }
        }
        return new PresContextImpl(33, offered.pcid(), result, null, new String[]{tsuid});
    }

    private void negotiateRoleSelection(AAssociateRQ rq, AAssociateAC ac) {
        Iterator it = rq.listRoleSelections().iterator();
        while (it.hasNext()) {
            ac.addRoleSelection(this.negotiateRoleSelection((RoleSelection)it.next()));
        }
    }

    private RoleSelection negotiateRoleSelection(RoleSelection offered) {
        boolean scu = offered.scu();
        boolean scp = false;
        RoleSelection accept = this.getRoleSelection(offered.getSOPClassUID());
        if (accept != null) {
            scu = offered.scu() && accept.scu();
            scp = offered.scp() && accept.scp();
        }
        return new RoleSelectionImpl(offered.getSOPClassUID(), scu, scp);
    }

    private void negotiateExt(AAssociateRQ rq, AAssociateAC ac) {
        Iterator it = rq.listExtNegotiations().iterator();
        while (it.hasNext()) {
            ExtNegotiation offered = (ExtNegotiation)it.next();
            String uid = offered.getSOPClassUID();
            ExtNegotiator enp = this.getExtNegPolicy(uid);
            if (enp == null) continue;
            ac.addExtNegotiation(new ExtNegotiationImpl(uid, enp.negotiate(offered.info())));
        }
    }

    private AsyncOpsWindow negotiateAOW(AsyncOpsWindow offered) {
        if (offered == null) {
            return null;
        }
        if (this.aow == null) {
            return AsyncOpsWindowImpl.DEFAULT;
        }
        return new AsyncOpsWindowImpl(AcceptorPolicyImpl.minAOW(offered.getMaxOpsInvoked(), this.aow.getMaxOpsInvoked()), AcceptorPolicyImpl.minAOW(offered.getMaxOpsPerformed(), this.aow.getMaxOpsPerformed()));
    }

    static int minAOW(int a, int b) {
        return a == 0 ? b : (b == 0 ? a : Math.min(a, b));
    }

    public List listPresContext() {
        return Collections.unmodifiableList(new ArrayList(this.presCtxMap.values()));
    }
}

