/*
 * Decompiled with CFR 0.152.
 */
package org.dcm4cheri.net;

import java.io.IOException;
import java.io.InputStream;
import java.net.Socket;
import org.dcm4che.data.Command;
import org.dcm4che.data.Dataset;
import org.dcm4che.net.AAbort;
import org.dcm4che.net.AAssociateAC;
import org.dcm4che.net.AAssociateRJ;
import org.dcm4che.net.AAssociateRQ;
import org.dcm4che.net.AReleaseRP;
import org.dcm4che.net.AReleaseRQ;
import org.dcm4che.net.AcceptorPolicy;
import org.dcm4che.net.ActiveAssociation;
import org.dcm4che.net.Association;
import org.dcm4che.net.AssociationFactory;
import org.dcm4che.net.AsyncOpsWindow;
import org.dcm4che.net.CommonExtNegotiation;
import org.dcm4che.net.DataSource;
import org.dcm4che.net.DcmServiceRegistry;
import org.dcm4che.net.Dimse;
import org.dcm4che.net.ExtNegotiation;
import org.dcm4che.net.PDU;
import org.dcm4che.net.PDUException;
import org.dcm4che.net.PDataTF;
import org.dcm4che.net.PresContext;
import org.dcm4che.net.RoleSelection;
import org.dcm4che.net.UserIdentityAC;
import org.dcm4che.net.UserIdentityRQ;
import org.dcm4cheri.net.AAbortImpl;
import org.dcm4cheri.net.AAssociateACImpl;
import org.dcm4cheri.net.AAssociateRJImpl;
import org.dcm4cheri.net.AAssociateRQImpl;
import org.dcm4cheri.net.AReleaseRPImpl;
import org.dcm4cheri.net.AReleaseRQImpl;
import org.dcm4cheri.net.AcceptorPolicyImpl;
import org.dcm4cheri.net.ActiveAssociationImpl;
import org.dcm4cheri.net.AssociationImpl;
import org.dcm4cheri.net.AsyncOpsWindowImpl;
import org.dcm4cheri.net.CommonExtNegotiationImpl;
import org.dcm4cheri.net.DcmServiceRegistryImpl;
import org.dcm4cheri.net.DimseImpl;
import org.dcm4cheri.net.ExtNegotiationImpl;
import org.dcm4cheri.net.PDataTFImpl;
import org.dcm4cheri.net.PresContextImpl;
import org.dcm4cheri.net.RoleSelectionImpl;
import org.dcm4cheri.net.UnparsedPDUImpl;
import org.dcm4cheri.net.UserIdentityACImpl;
import org.dcm4cheri.net.UserIdentityRQImpl;
import org.dcm4cheri.util.StringUtils;

public final class AssociationFactoryImpl
extends AssociationFactory {
    public AAssociateRQ newAAssociateRQ() {
        return new AAssociateRQImpl();
    }

    public AAssociateAC newAAssociateAC() {
        return new AAssociateACImpl();
    }

    public AAssociateRJ newAAssociateRJ(int result, int source, int reason) {
        return new AAssociateRJImpl(result, source, reason);
    }

    public PDataTF newPDataTF(int maxLength) {
        return new PDataTFImpl(maxLength);
    }

    public AReleaseRQ newAReleaseRQ() {
        return AReleaseRQImpl.getInstance();
    }

    public AReleaseRP newAReleaseRP() {
        return AReleaseRPImpl.getInstance();
    }

    public AAbort newAAbort(int source, int reason) {
        return new AAbortImpl(source, reason);
    }

    public PresContext newPresContext(int pcid, String asuid, String[] tsuids) {
        return new PresContextImpl(32, pcid, 0, StringUtils.checkUID(asuid), StringUtils.checkUIDs(tsuids));
    }

    public PresContext newPresContext(int pcid, String asuid) {
        return new PresContextImpl(32, pcid, 0, StringUtils.checkUID(asuid), new String[]{"1.2.840.10008.1.2"});
    }

    public PresContext newPresContext(int pcid, String asuid, String tsuid) {
        return new PresContextImpl(32, pcid, 0, StringUtils.checkUID(asuid), new String[]{StringUtils.checkUID(tsuid)});
    }

    public PresContext newPresContext(int pcid, int result, String tsuid) {
        return new PresContextImpl(33, pcid, result, null, new String[]{StringUtils.checkUID(tsuid)});
    }

    public AsyncOpsWindow newAsyncOpsWindow(int maxOpsInvoked, int maxOpsPerfomed) {
        return new AsyncOpsWindowImpl(maxOpsInvoked, maxOpsPerfomed);
    }

    public RoleSelection newRoleSelection(String uid, boolean scu, boolean scp) {
        return new RoleSelectionImpl(uid, scu, scp);
    }

    public ExtNegotiation newExtNegotiation(String uid, byte[] info) {
        return new ExtNegotiationImpl(uid, info);
    }

    public CommonExtNegotiation newCommonExtNegotiation(String sopCUID, String serviceCUID, String[] relGenSopCUIDs) {
        return new CommonExtNegotiationImpl(sopCUID, serviceCUID, relGenSopCUIDs);
    }

    public UserIdentityRQ newUserIdentity(boolean positiveResponseRequested, String username, String passcode) {
        return new UserIdentityRQImpl(positiveResponseRequested, username, passcode);
    }

    public UserIdentityRQ newUserIdentity(int userIdentityType, boolean positiveResponseRequested, byte[] primaryField) {
        return new UserIdentityRQImpl(userIdentityType, positiveResponseRequested, primaryField);
    }

    public UserIdentityAC newUserIdentity() {
        return new UserIdentityACImpl();
    }

    public UserIdentityAC newUserIdentity(byte[] serverResponse) {
        return new UserIdentityACImpl(serverResponse);
    }

    public PDU readFrom(InputStream in, byte[] buf) throws IOException {
        UnparsedPDUImpl raw = new UnparsedPDUImpl(in, buf);
        switch (raw.type()) {
            case 1: {
                return AAssociateRQImpl.parse(raw);
            }
            case 2: {
                return AAssociateACImpl.parse(raw);
            }
            case 3: {
                return AAssociateRJImpl.parse(raw);
            }
            case 4: {
                return PDataTFImpl.parse(raw);
            }
            case 5: {
                return AReleaseRQImpl.parse(raw);
            }
            case 6: {
                return AReleaseRPImpl.parse(raw);
            }
            case 7: {
                return AAbortImpl.parse(raw);
            }
        }
        throw new PDUException("Unrecognized " + raw, new AAbortImpl(2, 1));
    }

    public Association newRequestor(Socket s) throws IOException {
        return new AssociationImpl(s, true);
    }

    public Association newAcceptor(Socket s) throws IOException {
        return new AssociationImpl(s, false);
    }

    public ActiveAssociation newActiveAssociation(Association assoc, DcmServiceRegistry services) {
        return new ActiveAssociationImpl(assoc, services);
    }

    public Dimse newDimse(int pcid, Command cmd) {
        return new DimseImpl(pcid, cmd, null, null);
    }

    public Dimse newDimse(int pcid, Command cmd, Dataset ds) {
        return new DimseImpl(pcid, cmd, ds, null);
    }

    public Dimse newDimse(int pcid, Command cmd, DataSource src) {
        return new DimseImpl(pcid, cmd, null, src);
    }

    public AcceptorPolicy newAcceptorPolicy() {
        return new AcceptorPolicyImpl();
    }

    public DcmServiceRegistry newDcmServiceRegistry() {
        return new DcmServiceRegistryImpl();
    }
}

