/*
 * Decompiled with CFR 0.152.
 */
package org.dcm4cheri.server;

import java.io.IOException;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.InetAddress;
import java.net.SocketAddress;
import java.net.SocketException;
import java.net.UnknownHostException;
import java.util.Date;
import org.apache.log4j.Logger;
import org.dcm4che.server.UDPServer;

public class UDPServerImpl
implements UDPServer {
    private static Logger log = Logger.getLogger(UDPServerImpl.class);
    private static final int MAX_PACKAGE_SIZE = 65507;
    private static final int DEFAULT_PORT = 4000;
    private InetAddress laddr;
    private int port = 4000;
    private int maxPacketSize = 65507;
    private int rcvBuf = 0;
    private DatagramSocket socket;
    private Thread thread;
    private long lastStartedAt;
    private long lastStoppedAt;
    private UDPServer.Handler handler;

    public UDPServerImpl(UDPServer.Handler handler) {
        if (handler == null) {
            throw new NullPointerException();
        }
        this.handler = handler;
    }

    public final boolean isRunning() {
        return this.socket != null;
    }

    public Date getLastStoppedAt() {
        return UDPServerImpl.toDate(this.lastStoppedAt);
    }

    public Date getLastStartedAt() {
        return UDPServerImpl.toDate(this.lastStartedAt);
    }

    private static Date toDate(long ms) {
        return ms > 0L ? new Date(ms) : null;
    }

    public final String getLocalAddress() {
        return this.laddr == null ? "0.0.0.0" : this.laddr.getHostAddress();
    }

    public void setLocalAddress(String laddrStr) {
        try {
            this.laddr = InetAddress.getByName(laddrStr);
        }
        catch (UnknownHostException e) {
            throw new IllegalArgumentException("Unknown Host: " + laddrStr);
        }
    }

    public final int getPort() {
        return this.port;
    }

    public void setPort(int port) {
        if (port < 0 || port > 65535) {
            throw new IllegalArgumentException("port: " + port);
        }
        this.port = port;
    }

    public final int getMaxPacketSize() {
        return this.maxPacketSize;
    }

    public void setMaxPacketSize(int maxPacketSize) {
        if (maxPacketSize < 512 || maxPacketSize > 65507) {
            throw new IllegalArgumentException("maxPacketSize: " + maxPacketSize + " not in range 512..65507");
        }
        this.maxPacketSize = maxPacketSize;
    }

    public final int getReceiveBufferSize() {
        return this.rcvBuf;
    }

    public void setReceiveBufferSize(int rcvBuf) {
        if (rcvBuf < 0) {
            throw new IllegalArgumentException("rcvBuf: " + rcvBuf);
        }
        this.rcvBuf = rcvBuf;
    }

    public synchronized void start() throws Exception {
        this.startServer();
    }

    public synchronized void stop() {
        this.stopServer();
    }

    private synchronized void startServer() throws SocketException {
        if (this.socket != null) {
            this.stopServer();
        }
        this.socket = new DatagramSocket(this.port, this.laddr);
        int prevRcvBuf = this.socket.getReceiveBufferSize();
        if (this.rcvBuf == 0) {
            this.rcvBuf = prevRcvBuf;
        } else if (this.rcvBuf != prevRcvBuf) {
            this.socket.setReceiveBufferSize(this.rcvBuf);
            this.rcvBuf = this.socket.getReceiveBufferSize();
        }
        this.thread = new Thread(new Runnable(){

            public void run() {
                UDPServerImpl.this.lastStartedAt = System.currentTimeMillis();
                SocketAddress lsa = UDPServerImpl.this.socket.getLocalSocketAddress();
                log.info("Started UDP Server listening on " + lsa);
                byte[] data = new byte[UDPServerImpl.this.maxPacketSize];
                DatagramPacket p = new DatagramPacket(data, data.length);
                boolean restart = false;
                while (UDPServerImpl.this.socket != null && !UDPServerImpl.this.socket.isClosed()) {
                    try {
                        UDPServerImpl.this.socket.receive(p);
                        UDPServerImpl.this.handler.handle(p);
                    }
                    catch (IOException e) {
                        if (UDPServerImpl.this.socket.isClosed()) break;
                        log.warn("UDP Server throws i/o exception - restart", e);
                        restart = true;
                        break;
                    }
                    p.setLength(data.length);
                }
                UDPServerImpl.this.socket = null;
                UDPServerImpl.this.thread = null;
                UDPServerImpl.this.lastStoppedAt = System.currentTimeMillis();
                log.info("Stopped UDP Server listening on " + lsa);
                if (restart) {
                    try {
                        UDPServerImpl.this.startServer();
                    }
                    catch (SocketException e) {
                        log.error("Failed to restart UDP Server", e);
                    }
                }
            }
        });
        this.thread.start();
    }

    private synchronized void stopServer() {
        if (this.socket != null) {
            this.socket.close();
            try {
                this.thread.join();
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.socket = null;
        }
    }
}

