/*
 * Decompiled with CFR 0.152.
 */
package open.dolphin.client;

import java.awt.BorderLayout;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.print.PageFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.LinkedHashSet;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.GroupLayout;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import open.dolphin.client.AutoKanjiListener;
import open.dolphin.client.ChartMediator;
import open.dolphin.client.IChart;
import open.dolphin.client.IChartDocument;
import open.dolphin.client.LetterView;
import open.dolphin.client.PrintablePanel;
import open.dolphin.client.print.PrintPDF;
import open.dolphin.delegater.remote.RemoteDocumentDelegater;
import open.dolphin.delegater.remote.RemoteSetaDelegater;
import open.dolphin.dto.DiagnosisSearchSpec;
import open.dolphin.dto.DocumentSearchSpec;
import open.dolphin.dto.ModuleSearchSpec;
import open.dolphin.helper.DBTask;
import open.dolphin.helper.IChartCommandAccepter;
import open.dolphin.infomodel.IStampInfo;
import open.dolphin.infomodel.LetterModel;
import open.dolphin.infomodel.ModelUtils;
import open.dolphin.infomodel.ModuleModel;
import open.dolphin.infomodel.PatientModel;
import open.dolphin.infomodel.RegisteredDiagnosisModel;
import open.dolphin.infomodel.TouTouLetter;
import open.dolphin.infomodel.UserModel;
import open.dolphin.log.LogWriter;
import open.dolphin.project.GlobalConstants;
import open.dolphin.project.GlobalSettings;
import open.dolphin.project.GlobalVariables;
import open.dolphin.utils.AgeCalculator;

public class LetterImpl
extends PrintablePanel
implements IChartDocument,
IChartCommandAccepter {
    private static final String TITLE = "\u7d39\u4ecb\u72b6";
    private TouTouLetter model;
    private List<RegisteredDiagnosisModel> diagnosises;
    private LetterView view;
    private StateMgr stateMgr;
    private List<LetterModel> model_list;
    private static final String[] CHART_MENUS = new String[]{"openKarte", "save", "direction", "delete", "print", "modifyKarte", "ascending", "descending", "showModified", "showUnsend", "showSend", "showNewest", "insertText", "insertSchema", "insertStamp", "selectInsurance", "cut", "copy", "paste", "undo", "redo"};
    private IChart parent;
    private String title = "\u7d39\u4ecb\u72b6";
    private boolean dirty;
    private String[] medicationHistoryCache;

    public LetterImpl(IChart parent) {
        this.parent = parent;
        this.initComponents();
    }

    private void initComponents() {
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 400, Short.MAX_VALUE));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 300, Short.MAX_VALUE));
    }

    @Override
    public IChartDocument.TYPE getType() {
        return IChartDocument.TYPE.LetterImpl;
    }

    private void addAutoKanjiLIstenerToEachTextArea() {
        this.view.getCHospital().addFocusListener(AutoKanjiListener.getInstance());
        this.view.getCDept().addFocusListener(AutoKanjiListener.getInstance());
        this.view.getCDoctor().addFocusListener(AutoKanjiListener.getInstance());
        this.view.getDisease().addFocusListener(AutoKanjiListener.getInstance());
        this.view.getPurpose().addFocusListener(AutoKanjiListener.getInstance());
        this.view.getPastFamily().addFocusListener(AutoKanjiListener.getInstance());
        this.view.getClinicalCourse().addFocusListener(AutoKanjiListener.getInstance());
        this.view.getMedication().addFocusListener(AutoKanjiListener.getInstance());
        this.view.getRemarks().addFocusListener(AutoKanjiListener.getInstance());
    }

    private void addDirtyListenerToEachTextArea() {
        DocumentListener dl = new DocumentListener(){

            @Override
            public void insertUpdate(DocumentEvent documentEvent) {
                LetterImpl.this.stateMgr.processDirtyEvent();
            }

            @Override
            public void removeUpdate(DocumentEvent documentEvent) {
                LetterImpl.this.stateMgr.processDirtyEvent();
            }

            @Override
            public void changedUpdate(DocumentEvent documentEvent) {
                LetterImpl.this.stateMgr.processDirtyEvent();
            }
        };
        this.view.getCHospital().getDocument().addDocumentListener(dl);
        this.view.getCDept().getDocument().addDocumentListener(dl);
        this.view.getCDoctor().getDocument().addDocumentListener(dl);
        this.view.getDisease().getDocument().addDocumentListener(dl);
        this.view.getPurpose().getDocument().addDocumentListener(dl);
        this.view.getPastFamily().getDocument().addDocumentListener(dl);
        this.view.getClinicalCourse().getDocument().addDocumentListener(dl);
        this.view.getMedication().getDocument().addDocumentListener(dl);
        this.view.getRemarks().getDocument().addDocumentListener(dl);
    }

    private void addListenerToViewComponents() {
        this.view.cHospitalHistoryBtn.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent evt) {
                LetterImpl.this.cHospitalHistoryPopup(evt);
            }
        });
        this.view.cDeptHistoryBtn.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent evt) {
                LetterImpl.this.cDeptHistoryPopup(evt);
            }
        });
        this.view.cDoctorHistoryBtn.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent evt) {
                LetterImpl.this.cDoctorHistoryPopup(evt);
            }
        });
        this.view.diagnosisHistoryBtn.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent evt) {
                LetterImpl.this.diagnosisHistoryPopup(evt);
            }
        });
        this.view.purposeHistoryBtn.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent evt) {
                LetterImpl.this.purposeHistoryPopup(evt);
            }
        });
        this.view.pastFamilyHistoryBtn.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent evt) {
                LetterImpl.this.pastFamilyHistoryPopup(evt);
            }
        });
        this.view.clinicalCourseHistoryBtn.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent evt) {
                LetterImpl.this.clinicalCourseHistoryPopup(evt);
            }
        });
        this.view.medicationHistoryBtn.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent evt) {
                LetterImpl.this.medicationHistoryPopup(evt);
            }
        });
        this.view.remarkHistoryBtn.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent evt) {
                LetterImpl.this.remarksHistoryPopup(evt);
            }
        });
    }

    private DocumentSearchSpec createLetterSearchSpec() {
        DocumentSearchSpec spec = new DocumentSearchSpec();
        spec.setKarteId(this.getParentContext().getKarte().getId());
        spec.setDocType("letter");
        spec.setFromDate(new GregorianCalendar().getTime());
        spec.setIncludeModifid(true);
        spec.setCode(0);
        spec.setAscending(true);
        return spec;
    }

    private JPopupMenu createPopupMenu(final String setMethodName, String[] candidates) {
        JPopupMenu popMenu = new JPopupMenu();
        for (int i = 0; i < candidates.length; ++i) {
            if (candidates[i] == null || candidates[i].trim().equals("")) continue;
            JMenuItem item = new JMenuItem(new AbstractAction(candidates[i]){

                @Override
                public void actionPerformed(ActionEvent e) {
                    String actionCommand = e.getActionCommand();
                    try {
                        LetterImpl.this.view.getClass().getMethod(setMethodName, String.class).invoke((Object)LetterImpl.this.view, new String(actionCommand));
                    }
                    catch (Exception ex) {
                        LogWriter.error(this.getClass(), ex);
                    }
                }
            });
            popMenu.add(item);
        }
        return popMenu;
    }

    private String[] getCandidateList(String getMethodName) {
        ArrayList<String> candidates = new ArrayList<String>(1);
        for (LetterModel letter : this.model_list) {
            try {
                String caption = (String)((TouTouLetter)letter).getClass().getMethod(getMethodName, new Class[0]).invoke((Object)letter, (Object[])null);
                if (caption == null) continue;
                candidates.add(caption);
            }
            catch (Exception ex) {
                LogWriter.error(this.getClass(), ex);
            }
        }
        candidates = new ArrayList(new LinkedHashSet(candidates));
        Collections.reverse(candidates);
        return candidates.toArray(new String[0]);
    }

    private void setupModel(PatientModel patient) {
        this.model = new TouTouLetter();
        Date today = new Date();
        this.model.setConfirmed(today);
        this.model.setPatientName(patient.getFullName());
        this.model.setPatientGender(patient.getGenderDesc());
        this.model.setPatientBirthday(patient.getBirthday());
        this.model.setPatientAge(AgeCalculator.getAge(patient.getBirthday()));
        UserModel user = GlobalVariables.getUserModel();
        this.model.setClientHospital(user.getFacility().getFacilityName());
        this.model.setClientName(user.getCommonName());
        this.model.setClientAddress(user.getFacility().getAddress());
        this.model.setClientTelephone(user.getFacility().getTelephone());
        this.model.setClientFax(null);
    }

    private void setModelValue(JTextField tf, String value) {
        if (value != null) {
            tf.setText(value);
        }
    }

    private String getFieldValue(JTextField tf) {
        String ret = tf.getText().trim();
        if (!ret.equals("")) {
            return ret;
        }
        return null;
    }

    private String getAreaValue(JTextArea ta) {
        String ret = ta.getText().trim();
        if (!ret.equals("")) {
            return ret;
        }
        return null;
    }

    private String getDateAsString(Date date) {
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy\u5e74M\u6708d\u65e5");
        return sdf.format(date);
    }

    private String getDateString(String mmlDate) {
        Date d = ModelUtils.getDateAsObject(mmlDate);
        return this.getDateAsString(d);
    }

    private void displayModel() {
        String dateStr = this.getDateAsString(this.model.getConfirmed());
        this.view.getConfirmed().setText(dateStr);
        String birthdayStr = this.getDateString(this.model.getPatientBirthday());
        this.setModelValue(this.view.getPatientName(), this.model.getPatientName());
        this.setModelValue(this.view.getPatientGender(), this.model.getPatientGender());
        this.setModelValue(this.view.getPatientBirthday(), birthdayStr);
        this.setModelValue(this.view.getPatientAge(), this.model.getPatientAge());
        this.setModelValue(this.view.getPatientName(), this.model.getPatientName());
    }

    private void restore(TouTouLetter model) {
        Date today = new Date();
        model.setConfirmed(today);
        model.setRecorded(today);
        model.setStarted(today);
        model.setStatus("F");
        model.setKarte(this.getParentContext().getKarte());
        model.setCreator(GlobalVariables.getUserModel());
        model.setConsultantHospital(this.getFieldValue(this.view.getCHospital()));
        model.setConsultantDept(this.getFieldValue(this.view.getCDept()));
        model.setConsultantDoctor(this.getFieldValue(this.view.getCDoctor()));
        model.setDisease(this.getFieldValue(this.view.getDisease()));
        model.setPurpose(this.getFieldValue(this.view.getPurpose()));
        model.setClinicalCourse(this.getAreaValue(this.view.getClinicalCourse()));
        model.setPastFamily(this.getAreaValue(this.view.getPastFamily()));
        model.setMedication(this.getAreaValue(this.view.getMedication()));
        model.setRemarks(this.getFieldValue(this.view.getRemarks()));
    }

    @Override
    public boolean dispatchChartCommand(IChartCommandAccepter.ChartCommand command) {
        switch (command) {
            case modifyKarte: {
                return this.modifyKarte();
            }
            case save: {
                return this.save();
            }
            case print: {
                return this.print();
            }
        }
        return false;
    }

    @Override
    public void start() {
        PatientModel patient = this.getParentContext().getPatient();
        this.setupModel(patient);
        this.view = new LetterView();
        this.view.setKanzyaID(patient.getPatientId());
        JScrollPane scroller = new JScrollPane(this.view);
        scroller.getViewport().setBackground(GlobalSettings.getColors(GlobalSettings.Parts.TABLE_BACKGROUND));
        scroller.getVerticalScrollBar().setUnitIncrement(GlobalSettings.karteScrollUnitIncrement());
        this.setLayout(new BorderLayout());
        this.add(scroller);
        this.addListenerToViewComponents();
        this.displayModel();
        this.addDirtyListenerToEachTextArea();
        this.addAutoKanjiLIstenerToEachTextArea();
        this.stateMgr = new StateMgr();
        DocInfoTask task = new DocInfoTask(this.getParentContext(), this.createLetterSearchSpec(), new RemoteDocumentDelegater());
        task.execute();
    }

    @Override
    public void stop() {
    }

    private boolean save() {
        this.restore(this.model);
        RemoteSetaDelegater ddl = new RemoteSetaDelegater();
        long result = ddl.saveOrUpdateLetter(this.model);
        if (!ddl.isError()) {
            this.model.setId(result);
        }
        this.stateMgr.processSavedEvent();
        this.getParentContext().getDocumentHistory().getDocumentHistory();
        this.closeEditor();
        return true;
    }

    private void closeEditor() {
        this.getParentContext().enabledAction("newDocument", true);
        this.getParentContext().enabledAction("direction", false);
        this.getParentContext().closeChartDocument(this.title, this);
        this.getParentContext().getChartMediator().unsetAccepter(this);
    }

    @Override
    public void enter() {
        this.getParentContext().getStatusPanel().setMessage("");
        this.getParentContext().getChartMediator().setAccepter(this);
        this.disableMenus();
        this.getParentContext().enabledAction("newKarte", true);
        this.getParentContext().enabledAction("newDocument", true);
        this.getParentContext().enabledAction("addUser", GlobalVariables.isAdmin());
        if (this.stateMgr != null) {
            this.stateMgr.enter();
        }
    }

    private boolean print() {
        if (this.model == null) {
            return true;
        }
        StringBuilder sb = new StringBuilder();
        sb.append("PDF\u30d5\u30a1\u30a4\u30eb\u3092\u4f5c\u6210\u3057\u307e\u3059\u304b?");
        int option = JOptionPane.showOptionDialog(this.getParentContext().getFrame(), sb.toString(), GlobalConstants.getFrameTitle("\u7d39\u4ecb\u72b6\u5370\u5237"), -1, 1, null, new String[]{"PDF\u4f5c\u6210", "\u753b\u9762\u5370\u5237", "\u53d6\u6d88\u3057"}, "PDF\u4f5c\u6210");
        if (option == 0) {
            this.save();
            this.makePDF();
        } else if (option == 1) {
            PageFormat pageFormat = this.getParentContext().getContext().getPageFormat();
            String name = this.getParentContext().getPatient().getFullName();
            LetterView panel = this.view;
            panel.printPanel(pageFormat, 1, false, name, 0);
        }
        return true;
    }

    public void makePDF() {
        if (this.model == null) {
            return;
        }
        PrintPDF p = new PrintPDF(this.getParentContext().getFrame());
        p.exec(this.model);
    }

    @Override
    public boolean isDirty() {
        if (this.stateMgr != null) {
            return this.stateMgr.isDirtyState();
        }
        return this.dirty;
    }

    private boolean modifyKarte() {
        this.stateMgr.processModifyKarteEvent();
        return true;
    }

    private void setEditables(boolean b) {
        this.view.getConfirmed().setEditable(b);
        this.view.getCHospital().setEditable(b);
        this.view.getCDept().setEditable(b);
        this.view.getCDoctor().setEditable(b);
        this.view.getDisease().setEditable(b);
        this.view.getPurpose().setEditable(b);
        this.view.getPastFamily().setEditable(b);
        this.view.getClinicalCourse().setEditable(b);
        this.view.getMedication().setEditable(b);
        this.view.getRemarks().setEditable(b);
    }

    @Override
    public boolean itLayoutSaved() {
        return false;
    }

    @Override
    public String getTitle() {
        return this.title;
    }

    @Override
    public IChart getParentContext() {
        return this.parent;
    }

    @Override
    public boolean prepare() {
        return true;
    }

    @Override
    public void setDirty(boolean dirty) {
        this.dirty = dirty;
    }

    public boolean isReadOnly() {
        return this.getParentContext().isReadOnly();
    }

    public void disableMenus() {
        ChartMediator mediator = this.getParentContext().getChartMediator();
        mediator.disableMenus(CHART_MENUS);
    }

    protected void warning(String title, String message) {
        Window parent = SwingUtilities.getWindowAncestor(this);
        JOptionPane.showMessageDialog(parent, message, GlobalConstants.getFrameTitle(title), 2);
    }

    private String[] getMedications() {
        ModuleSearchSpec spec = new ModuleSearchSpec();
        spec.setCode(0);
        spec.setKarteId(this.getParentContext().getKarte().getId());
        spec.setEntity("medOrder");
        spec.setStatus("F");
        if (this.medicationHistoryCache == null) {
            RemoteDocumentDelegater ddl = new RemoteDocumentDelegater();
            List moduleList = ddl.getAllModuleList(spec);
            ArrayList<String> result = new ArrayList<String>();
            for (ModuleModel module : moduleList) {
                module.setModel(module.toInfoModel());
                IStampInfo info = module.getModuleInfo();
                result.add(info.getStampName());
            }
            result = new ArrayList(new LinkedHashSet(result));
            Collections.reverse(result);
            this.medicationHistoryCache = result.toArray(new String[0]);
        }
        return this.medicationHistoryCache;
    }

    public void cHospitalHistoryPopup(MouseEvent e) {
        this.historyPopup("getConsultantHospital", "setCHospital", e);
    }

    public void diagnosisHistoryPopup(final MouseEvent e) {
        final DiagnosisSearchSpec spec = new DiagnosisSearchSpec();
        spec.setCode(0);
        spec.setKarteId(this.getParentContext().getKarte().getId());
        Date past = new Date(0L);
        if (past != null) {
            spec.setFromDate(past);
        }
        final RemoteDocumentDelegater ddl = new RemoteDocumentDelegater();
        DBTask<List> task = new DBTask<List>(this.getParentContext()){

            @Override
            protected List doInBackground() throws Exception {
                return ddl.getDiagnosisList(spec);
            }

            @Override
            protected void succeeded(List list) {
                LetterImpl.this.diagnosises = list;
                ArrayList<String> captions = new ArrayList<String>();
                if (!ddl.isError() && list != null) {
                    Collections.sort(list);
                    String diagnosisName = null;
                    for (Object model : list) {
                        diagnosisName = ((RegisteredDiagnosisModel)model).getDiagnosis();
                        if (diagnosisName == null) continue;
                        captions.add(diagnosisName);
                        diagnosisName = null;
                    }
                    captions = new ArrayList(new LinkedHashSet(captions));
                    String[] diagnosisNames = captions.toArray(new String[0]);
                    JPopupMenu popMenu = new JPopupMenu();
                    for (int i = 0; i < diagnosisNames.length; ++i) {
                        if (diagnosisNames[i] == null || diagnosisNames[i].trim().equals("")) continue;
                        JMenuItem item = new JMenuItem(new AbstractAction(diagnosisNames[i]){

                            @Override
                            public void actionPerformed(ActionEvent e) {
                                String s = e.getActionCommand();
                                try {
                                    String oldDisease = LetterImpl.this.view.getDisease().getText().trim();
                                    if (!oldDisease.equals("")) {
                                        oldDisease = oldDisease + "\u3001";
                                    }
                                    LetterImpl.this.view.setDisease(oldDisease + s);
                                }
                                catch (Exception ex) {
                                    LogWriter.error(this.getClass(), ex);
                                }
                            }
                        });
                        popMenu.add(item);
                    }
                    popMenu.show(e.getComponent(), e.getX(), e.getY());
                }
            }
        };
        task.execute();
    }

    public void cDeptHistoryPopup(MouseEvent e) {
        this.historyPopup("getConsultantDept", "setCDept", e);
    }

    public void cDoctorHistoryPopup(MouseEvent e) {
        this.historyPopup("getConsultantDoctor", "setCDoctor", e);
    }

    public void purposeHistoryPopup(MouseEvent e) {
        this.historyPopup("getPurpose", "setPurpose", e);
    }

    public void pastFamilyHistoryPopup(MouseEvent e) {
        this.historyPopup("getPastFamily", "setPastFamily", e);
    }

    public void clinicalCourseHistoryPopup(MouseEvent e) {
        this.historyPopup("getClinicalCourse", "setClinicalCourse", e);
    }

    public void medicationHistoryPopup(MouseEvent e) {
        this.getParentContext().showDocument("\u6cbb\u7642\u5c65\u6b74");
    }

    public void remarksHistoryPopup(MouseEvent e) {
        this.historyPopup("getRemarks", "setRemarks", e);
    }

    private void historyPopup(String getMethodName, String setMethodName, MouseEvent evnt) {
        String[] captions = this.getCandidateList(getMethodName);
        JPopupMenu popMenu = this.createPopupMenu(setMethodName, captions);
        popMenu.setName(getMethodName + "PopupMenu");
        popMenu.show(evnt.getComponent(), evnt.getX(), evnt.getY());
    }

    public LetterView getView() {
        return this.view;
    }

    @Override
    public List<JTabbedPane> getTabbedPanels() {
        return null;
    }

    @Override
    public boolean update(Object o) {
        return true;
    }

    class DocInfoTask
    extends DBTask<List<LetterModel>> {
        private RemoteDocumentDelegater ddl;
        private DocumentSearchSpec spec;

        public DocInfoTask(IChart ctx, DocumentSearchSpec spec, RemoteDocumentDelegater ddl) {
            super(ctx);
            this.spec = spec;
            this.ddl = ddl;
        }

        @Override
        protected List<LetterModel> doInBackground() {
            List<LetterModel> result = this.ddl.getRecentLetterModels();
            if (!this.ddl.isError()) {
                return result;
            }
            return null;
        }

        @Override
        protected void succeeded(List<LetterModel> result) {
            if (result != null) {
                LetterImpl.this.model_list = result;
            }
        }
    }

    class StateMgr {
        private EmptyState emptyState;
        private DirtyState dirtyState;
        private CleanState cleanState;
        private StartEditingState startEditingState;
        private State curState;

        public StateMgr() {
            this.emptyState = new EmptyState();
            this.dirtyState = new DirtyState();
            this.cleanState = new CleanState();
            this.startEditingState = new StartEditingState();
            this.curState = this.emptyState;
            this.enter();
        }

        public void enter() {
            this.curState.enter();
        }

        public void processDirtyEvent() {
            boolean newDirty;
            boolean bl = newDirty = LetterImpl.this.getFieldValue(LetterImpl.this.view.getCHospital()) != null && LetterImpl.this.getFieldValue(LetterImpl.this.view.getDisease()) != null && LetterImpl.this.getFieldValue(LetterImpl.this.view.getPurpose()) != null && LetterImpl.this.getAreaValue(LetterImpl.this.view.getClinicalCourse()) != null;
            if (this.isDirtyState() != newDirty) {
                this.curState = newDirty ? this.dirtyState : this.emptyState;
                this.curState.enter();
            }
        }

        public void processSavedEvent() {
            this.curState = this.cleanState;
            this.curState.enter();
        }

        public void processModifyKarteEvent() {
            this.curState = this.startEditingState;
            this.curState.enter();
        }

        public boolean isDirtyState() {
            return this.curState == this.dirtyState;
        }
    }

    class StartEditingState
    extends State {
        StartEditingState() {
        }

        @Override
        public void enter() {
            LetterImpl.this.setEditables(true);
            LetterImpl.this.getParentContext().enabledAction("save", false);
            LetterImpl.this.getParentContext().enabledAction("print", true);
            LetterImpl.this.getParentContext().enabledAction("direction", true);
            LetterImpl.this.getParentContext().enabledAction("modifyKarte", false);
            LetterImpl.this.getParentContext().enabledAction("addUser", GlobalVariables.isAdmin());
        }
    }

    class CleanState
    extends State {
        CleanState() {
        }

        @Override
        public void enter() {
            LetterImpl.this.setEditables(false);
            LetterImpl.this.getParentContext().enabledAction("save", false);
            LetterImpl.this.getParentContext().enabledAction("print", true);
            LetterImpl.this.getParentContext().enabledAction("direction", true);
            LetterImpl.this.getParentContext().enabledAction("modifyKarte", true);
            LetterImpl.this.getParentContext().enabledAction("addUser", GlobalVariables.isAdmin());
        }
    }

    class DirtyState
    extends State {
        DirtyState() {
        }

        @Override
        public void enter() {
            LetterImpl.this.getParentContext().enabledAction("save", true);
            LetterImpl.this.getParentContext().enabledAction("print", true);
            LetterImpl.this.getParentContext().enabledAction("direction", true);
            LetterImpl.this.getParentContext().enabledAction("modifyKarte", false);
            LetterImpl.this.getParentContext().enabledAction("addUser", GlobalVariables.isAdmin());
        }
    }

    class EmptyState
    extends State {
        EmptyState() {
        }

        @Override
        public void enter() {
            LetterImpl.this.getParentContext().enabledAction("save", false);
            LetterImpl.this.getParentContext().enabledAction("print", false);
            LetterImpl.this.getParentContext().enabledAction("direction", false);
            LetterImpl.this.getParentContext().enabledAction("modifyKarte", false);
            LetterImpl.this.getParentContext().enabledAction("addUser", GlobalVariables.isAdmin());
        }
    }

    protected abstract class State {
        protected State() {
        }

        public abstract void enter();
    }
}

