/*
 * Decompiled with CFR 0.152.
 */
package open.dolphin.client;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.beans.EventHandler;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.ListSelectionModel;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import open.dolphin.project.GlobalSettings;
import open.dolphin.table.ObjectReflectTableModel;
import open.dolphin.table.OddEvenRowRenderer;

public class ObjectListTable
extends JTable {
    public static final String SELECTED_OBJECT = "selectedObjects";
    public static final String DOUBLE_CLICKED_OBJECT = "doubleClickedObject";
    public static final String OBJECT_VALUE = "objectValue";
    private PropertyChangeSupport boundSupport;
    private Object[] selectedObjects;
    private Object doubleClickedObject;
    private ObjectReflectTableModel<Object> tableModel;

    public ObjectListTable(String[] columnNames, int startNumRows, String[] methodNames, Class[] classes) {
        this(columnNames, startNumRows, methodNames, classes, true);
    }

    public ObjectListTable(String[] columnNames, int startNumRows, String[] methodNames, Class[] classes, boolean oddEvenColor) {
        this.tableModel = new ObjectReflectTableModel(columnNames, startNumRows, methodNames, classes);
        this.setModel(this.tableModel);
        this.connect();
        if (oddEvenColor) {
            this.setDefaultRenderer(Object.class, new OddEvenRowRenderer());
        }
    }

    public void clear() {
        this.tableModel.clear();
    }

    @Override
    public void addPropertyChangeListener(String prop, PropertyChangeListener l) {
        if (this.boundSupport == null) {
            this.boundSupport = new PropertyChangeSupport(this);
        }
        this.boundSupport.addPropertyChangeListener(prop, l);
    }

    @Override
    public void removePropertyChangeListener(String prop, PropertyChangeListener l) {
        if (this.boundSupport == null) {
            this.boundSupport = new PropertyChangeSupport(this);
        }
        this.boundSupport.removePropertyChangeListener(prop, l);
    }

    public Object[] getSelectedObject() {
        return this.selectedObjects;
    }

    public Object getDoubleClickedObject() {
        return this.doubleClickedObject;
    }

    public void setObjectList(List<Object> list) {
        this.tableModel.setObjectList(list);
    }

    public void setColumnWidth(int[] columnWidth) {
        for (int i = 0; i < columnWidth.length; ++i) {
            this.getColumnModel().getColumn(i).setPreferredWidth(columnWidth[i]);
        }
    }

    public JScrollPane getScroller() {
        JScrollPane result = new JScrollPane(this);
        result.getViewport().setBackground(GlobalSettings.getColors(GlobalSettings.Parts.TABLE_BACKGROUND));
        return result;
    }

    public JPanel getPanel(boolean showHeader) {
        JPanel ret = new JPanel(new BorderLayout());
        ret.add((Component)this, "Center");
        if (showHeader) {
            ret.add((Component)this.getTableHeader(), "North");
        }
        return ret;
    }

    public JPanel getPanel() {
        return this.getPanel(true);
    }

    protected void connect() {
        ListSelectionModel sleModel = this.getSelectionModel();
        sleModel.addListSelectionListener(EventHandler.create(ListSelectionListener.class, this, "listSelectionChanged", ""));
        this.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                Object value;
                if (e.getClickCount() == 2 && (value = ObjectListTable.this.tableModel.getObject(ObjectListTable.this.getSelectedRow())) != null) {
                    ObjectListTable.this.notifyDoubleClickedObject(value);
                }
            }
        });
    }

    public void listSelectionChanged(ListSelectionEvent e) {
        int[] selectedRows;
        if (!e.getValueIsAdjusting() && (selectedRows = this.getSelectedRows()).length > 0) {
            ArrayList<Object> list = new ArrayList<Object>(1);
            for (int i = 0; i < selectedRows.length; ++i) {
                Object obj = this.tableModel.getObject(selectedRows[i]);
                if (obj == null) continue;
                list.add(obj);
            }
            this.notifySelectedObjects(list.toArray());
        }
    }

    protected void notifySelectedObjects(Object[] selected) {
        if (this.boundSupport != null) {
            Object[] old = this.selectedObjects;
            this.selectedObjects = selected;
            this.boundSupport.firePropertyChange(SELECTED_OBJECT, old, this.selectedObjects);
        }
    }

    protected void notifyDoubleClickedObject(Object clicked) {
        if (this.boundSupport != null) {
            Object old = this.doubleClickedObject;
            old = null;
            this.doubleClickedObject = clicked;
            this.boundSupport.firePropertyChange(DOUBLE_CLICKED_OBJECT, old, this.doubleClickedObject);
        }
    }

    protected void notifyObjectValue(Object obj) {
        if (this.boundSupport != null) {
            Object old = null;
            this.boundSupport.firePropertyChange(OBJECT_VALUE, old, obj);
        }
    }

    public void addRow(Object add) {
        this.tableModel.addRow(add);
    }

    public void addRows(Collection c) {
        this.tableModel.addRows(c);
    }

    public void deleteSelectedRow() {
        int selected = this.getSelectedRow();
        if (selected > -1) {
            this.tableModel.deleteRow(selected);
        }
    }

    public void deleteSelectedRows() {
        Object[] objects = this.getSelectedObject();
        if (objects != null && objects.length > 0) {
            ArrayList<Object> list = new ArrayList<Object>();
            for (int i = 0; i < objects.length; ++i) {
                list.add(objects[i]);
            }
            this.tableModel.deleteRows(list);
        }
    }
}

