/*
 * Decompiled with CFR 0.152.
 */
package open.dolphin.client;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.Window;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.Box;
import javax.swing.ImageIcon;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import open.dolphin.client.BlockGlass;
import open.dolphin.client.SeparatorPanel;
import open.dolphin.project.GlobalConstants;
import org.jdesktop.application.TaskMonitor;

public class StatusPanel
extends JPanel
implements PropertyChangeListener {
    private static final int DEFAULT_HEIGHT = 23;
    private TaskMonitor taskMonitor;
    private JLabel timelabel;
    private boolean useTime = true;
    private JPanel info;
    private JLabel leftLabel;
    private JLabel messageLable;
    private JLabel rightLabel;

    public StatusPanel() {
        this(true);
    }

    public StatusPanel(boolean useTime) {
        this.initComponents();
        this.useTime = useTime;
        Font font = new Font("Dialog", 0, 10);
        this.leftLabel.setFont(font);
        this.rightLabel.setFont(font);
        this.leftLabel.setHorizontalAlignment(0);
        this.rightLabel.setHorizontalAlignment(0);
        if (useTime) {
            this.timelabel = new JLabel("\u7d4c\u904e\u6642\u9593: 00 \u79d2");
            this.timelabel.setFont(font);
            this.timelabel.setHorizontalAlignment(0);
        }
        this.info.add(Box.createHorizontalStrut(3));
        this.info.add(this.leftLabel);
        this.info.add(new SeparatorPanel());
        this.info.add(this.rightLabel);
        if (useTime) {
            this.info.add(new SeparatorPanel());
            this.info.add(this.timelabel);
        }
        this.info.add(Box.createHorizontalStrut(11));
        this.setPreferredSize(new Dimension(this.getWidth(), 23));
    }

    private void initComponents() {
        this.rightLabel = new JLabel();
        this.leftLabel = new JLabel();
        this.messageLable = new JLabel();
        this.info = new JPanel();
        this.setLayout(new BorderLayout());
        this.rightLabel.setName("rightLabel");
        this.add((Component)this.rightLabel, "Center");
        this.leftLabel.setName("leftLabel");
        this.add((Component)this.leftLabel, "Last");
        this.messageLable.setName("messageLable");
        this.add((Component)this.messageLable, "After");
        this.info.setName("info");
        this.info.setLayout(new FlowLayout(2, 0, 2));
        this.add((Component)this.info, "Center");
    }

    public void setMessage(String msg) {
        this.messageLable.setText(msg);
    }

    private BlockGlass getBlock() {
        Window window = SwingUtilities.getWindowAncestor(this);
        if (window != null && window instanceof JFrame) {
            JFrame frame = (JFrame)window;
            ImageIcon icon = GlobalConstants.getImageIcon("web_32.gif");
            frame.setIconImage(icon.getImage());
            Component cmp = frame.getGlassPane();
            if (cmp != null && cmp instanceof BlockGlass) {
                return (BlockGlass)cmp;
            }
        }
        return null;
    }

    private void start() {
        BlockGlass glass = this.getBlock();
        if (glass != null) {
            glass.block();
        }
    }

    private void stop() {
        BlockGlass glass = this.getBlock();
        if (glass != null) {
            glass.unblock();
        }
    }

    public void setRightInfo(String info) {
        this.rightLabel.setText(info);
    }

    public void setLeftInfo(String info) {
        this.leftLabel.setText(info);
    }

    public void setTimeInfo(long time) {
        if (this.useTime) {
            StringBuilder sb = new StringBuilder();
            sb.append("\u7d4c\u904e\u6642\u9593: ");
            sb.append(time);
            sb.append(" \u79d2");
            this.timelabel.setText(sb.toString());
        }
    }

    public void ready(TaskMonitor taskMonitor) {
        taskMonitor.addPropertyChangeListener((PropertyChangeListener)this);
        this.taskMonitor = taskMonitor;
    }

    @Override
    public void propertyChange(PropertyChangeEvent e) {
        String propertyName = e.getPropertyName();
        if ("started".equals(propertyName)) {
            this.start();
        } else if ("done".equals(propertyName)) {
            this.stop();
            this.taskMonitor.removePropertyChangeListener((PropertyChangeListener)this);
        }
    }
}

