/*
 * Decompiled with CFR 0.152.
 */
package open.dolphin.client.labotestimporter;

import java.util.Date;
import java.util.List;
import open.dolphin.client.labotestimporter.AverageInformation;
import open.dolphin.client.labotestimporter.LaboTestInformation;
import open.dolphin.client.labotestimporter.LaboTestIsNotFinalReportException;
import open.dolphin.client.labotestimporter.LaboTestResultInformation;
import open.dolphin.infomodel.FacilityModel;
import open.dolphin.infomodel.LaboItemValue;
import open.dolphin.infomodel.LaboModuleValue;
import open.dolphin.infomodel.LaboSpecimenValue;
import open.dolphin.infomodel.ModelUtils;
import open.dolphin.infomodel.UserModel;
import open.dolphin.labotestimporter.translater.HkkInspectionStatus;
import open.dolphin.project.GlobalVariables;

public class MmlBuilder {
    private final List<LaboModuleValue> allModules;

    public MmlBuilder(List<LaboModuleValue> allModules) {
        this.allModules = allModules;
    }

    private boolean updateModule(LaboTestInformation information) {
        String id = information.getPatientId();
        for (LaboModuleValue value : this.allModules) {
            if (!value.getPatientId().equals(id)) continue;
            this.buildOneModule(value, information);
            return true;
        }
        return false;
    }

    private void insertModule(LaboTestInformation information) throws LaboTestIsNotFinalReportException {
        LaboModuleValue value = new LaboModuleValue();
        if (this.buildOneModule(value, information)) {
            this.allModules.add(value);
            return;
        }
        throw new LaboTestIsNotFinalReportException(information);
    }

    public void build(List<LaboTestInformation> laboTestInformations) throws LaboTestIsNotFinalReportException {
        for (LaboTestInformation laboTestInformation : laboTestInformations) {
            if (this.updateModule(laboTestInformation)) continue;
            this.insertModule(laboTestInformation);
        }
    }

    private boolean buildOneModule(LaboModuleValue laboModuleValue, LaboTestInformation laboTestInformation) {
        boolean result = false;
        if (laboTestInformation.getReportStatus().equals(HkkInspectionStatus.END)) {
            UserModel user = GlobalVariables.getUserModel();
            FacilityModel facility = user.getFacility();
            String facilityName = facility.getFacilityName();
            String facilityId = facility.getFacilityId();
            laboModuleValue.setSetName("");
            laboModuleValue.setSetCode("");
            laboModuleValue.setSetCodeId("");
            laboModuleValue.setCreator(user);
            String sampleTime = laboTestInformation.getSampleTime();
            String patientId = laboTestInformation.getPatientId();
            laboModuleValue.setPatientId(patientId);
            laboModuleValue.setPatientIdType(laboTestInformation.getPatientIdType());
            laboModuleValue.setPatientIdTypeCodeSys(laboTestInformation.getPatientIdTypeTableId());
            laboModuleValue.setDocId(laboTestInformation.getModuleUUID());
            Date confirmed = ModelUtils.getDateTimeAsObject(laboTestInformation.getConfirmedDate());
            laboModuleValue.setConfirmed(confirmed);
            laboModuleValue.setStarted(confirmed);
            laboModuleValue.setRecorded(new Date());
            laboModuleValue.setStatus("F");
            laboModuleValue.setRegistId(laboTestInformation.getRegistId());
            laboModuleValue.setSampleTime(sampleTime);
            laboModuleValue.setRegistTime(laboTestInformation.getRegistTime());
            laboModuleValue.setReportTime(laboTestInformation.getReportTime());
            laboModuleValue.setReportStatus(laboTestInformation.getReportStatus());
            laboModuleValue.setReportStatusCode(laboTestInformation.getReportStatusCode());
            laboModuleValue.setReportStatusCodeId(laboTestInformation.getReportStatusCodeType());
            laboModuleValue.setClientFacility(facilityName);
            laboModuleValue.setClientFacilityCode(facilityId);
            laboModuleValue.setClientFacilityCodeId(laboTestInformation.getClientFacilityCodeId());
            laboModuleValue.setLaboratoryCenter(laboTestInformation.getLaboratoryCenter());
            laboModuleValue.setLaboratoryCenterCode(laboTestInformation.getLaboratoryCenterCode());
            laboModuleValue.setLaboratoryCenterCodeId(laboTestInformation.getLaboratoryCenterCodeId());
            LaboSpecimenValue laboSpecimenValue = new LaboSpecimenValue();
            laboSpecimenValue.setSpecimenName(laboTestInformation.getSpecimenName());
            laboSpecimenValue.setSpecimenCode(laboTestInformation.getSpecimenCode());
            laboSpecimenValue.setSpecimenCodeId(laboTestInformation.getSpecimenCodeId());
            laboSpecimenValue.setLaboModule(laboModuleValue);
            laboModuleValue.addLaboSpecimen(laboSpecimenValue);
            int laboTestInformationSize = laboTestInformation.laboTestResultInformationSize();
            for (int index = 0; index < laboTestInformationSize; ++index) {
                LaboItemValue laboItemValue = new LaboItemValue();
                LaboTestResultInformation item = laboTestInformation.getLaboTestResultInformation(index);
                laboItemValue.setItemName(item.getItemName());
                laboItemValue.setItemCode(item.getItemCode());
                laboItemValue.setItemCodeId(item.getItemCodeId());
                laboItemValue.setItemValue(item.getValue());
                laboItemValue.setAcode(item.getComment1());
                laboItemValue.setIcode(item.getComment2());
                AverageInformation average = laboTestInformation.getAverageInformation(index);
                laboItemValue.setUp(average.getUp());
                laboItemValue.setLow(average.getLow());
                laboItemValue.setNormal(average.getNormal());
                laboItemValue.setNout(average.getOut());
                laboItemValue.setUnit(average.getUnit());
                laboItemValue.setUnitCode(average.getUnitCode());
                laboItemValue.setUnitCodeId(average.getUnitCodeId());
                laboItemValue.setLaboSpecimen(laboSpecimenValue);
                laboSpecimenValue.addLaboItem(laboItemValue);
            }
            result = true;
        }
        return result;
    }
}

