/*
 * Decompiled with CFR 0.152.
 */
package open.dolphin.component;

import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.dnd.DragSource;
import java.awt.event.ActionEvent;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.Action;
import javax.swing.ActionMap;
import javax.swing.DropMode;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JTabbedPane;
import javax.swing.SwingUtilities;
import javax.swing.TransferHandler;
import javax.swing.event.MouseInputListener;
import open.dolphin.component.GhostGlassPane;

public class DnDTabbedPane
extends JTabbedPane {
    private static final int LINEWIDTH = 3;
    private final Rectangle lineRect = new Rectangle();
    public int dragTabIndex = -1;
    public static Rectangle rBackward = new Rectangle();
    public static Rectangle rForward = new Rectangle();
    private static int rwh = 20;
    private static int buttonsize = 30;
    private DropMode dropMode = DropMode.INSERT;
    private transient DropLocation dropLocation;

    private void clickArrowButton(String actionKey) {
        Action action;
        ActionMap map = this.getActionMap();
        if (map != null && (action = map.get(actionKey)) != null && action.isEnabled()) {
            action.actionPerformed(new ActionEvent(this, 1001, null, 0L, 0));
        }
    }

    public void autoScrollTest(Point pt) {
        Rectangle r = this.getTabAreaBounds();
        int tabPlacement = this.getTabPlacement();
        if (tabPlacement == 1 || tabPlacement == 3) {
            rBackward.setBounds(r.x, r.y, rwh, r.height);
            rForward.setBounds(r.x + r.width - rwh - buttonsize, r.y, rwh + buttonsize, r.height);
        } else if (tabPlacement == 2 || tabPlacement == 4) {
            rBackward.setBounds(r.x, r.y, r.width, rwh);
            rForward.setBounds(r.x, r.y + r.height - rwh - buttonsize, r.width, rwh + buttonsize);
        }
        if (rBackward.contains(pt)) {
            this.clickArrowButton("scrollTabsBackwardAction");
        } else if (rForward.contains(pt)) {
            this.clickArrowButton("scrollTabsForwardAction");
        }
    }

    public DnDTabbedPane() {
        Handler h = new Handler();
        this.addMouseListener(h);
        this.addMouseMotionListener(h);
        this.addPropertyChangeListener(h);
    }

    public DropLocation dropLocationForPoint(Point p) {
        DropLocation location = null;
        boolean isTB = this.getTabPlacement() == 1 || this.getTabPlacement() == 3;
        switch (this.dropMode) {
            case INSERT: {
                Rectangle r;
                for (int i = 0; i < this.getTabCount(); ++i) {
                    r = this.getBoundsAt(i);
                    if (isTB) {
                        r.translate(-r.width / 2, 0);
                    } else {
                        r.translate(0, -r.height / 2);
                    }
                    if (!r.contains(p)) continue;
                    return new DropLocation(p, i);
                }
                r = this.getBoundsAt(this.getTabCount() - 1);
                if (isTB) {
                    r.translate(r.width / 2, 0);
                } else {
                    r.translate(0, r.height / 2);
                }
                int index = r.contains(p) ? this.getTabCount() : -1;
                location = new DropLocation(p, index);
                break;
            }
            default: {
                assert (false) : "Unexpected drop mode";
                break;
            }
        }
        return location;
    }

    public final DropLocation getDropLocation() {
        return this.dropLocation;
    }

    public Object setDropLocation(TransferHandler.DropLocation location, Object state2, boolean forDrop) {
        Object retVal = null;
        DropLocation old = this.dropLocation;
        if (location instanceof DropLocation) {
            this.dropLocation = (DropLocation)location;
            this.firePropertyChange("dropLocation", old, this.dropLocation);
        }
        return retVal;
    }

    public void exportTab(int source_index, JTabbedPane target_pane, int target_index) {
        if (target_index < 0) {
            return;
        }
        Component source_component = this.getComponentAt(source_index);
        if (source_component == target_pane) {
            return;
        }
        Component source_tab_component = this.getTabComponentAt(source_index);
        String source_title = this.getTitleAt(source_index);
        Icon source_icon = this.getIconAt(source_index);
        String source_tip = this.getToolTipTextAt(source_index);
        boolean source_is_enabled = this.isEnabledAt(source_index);
        this.remove(source_index);
        target_pane.insertTab(source_title, source_icon, source_component, source_tip, target_index);
        target_pane.setEnabledAt(target_index, source_is_enabled);
        target_pane.setTabComponentAt(target_index, source_tab_component);
        target_pane.setSelectedIndex(target_index);
        if (source_tab_component != null && source_tab_component instanceof JComponent) {
            ((JComponent)source_tab_component).scrollRectToVisible(source_tab_component.getBounds());
        }
    }

    public void convertTab(int source_index, int target_index) {
        if (target_index < 0 || source_index == target_index) {
            return;
        }
        Component source_component = this.getComponentAt(source_index);
        Component source_tab_component = this.getTabComponentAt(source_index);
        String source_title = this.getTitleAt(source_index);
        Icon source_icon = this.getIconAt(source_index);
        String source_tip = this.getToolTipTextAt(source_index);
        boolean source_is_enabled = this.isEnabledAt(source_index);
        int distination_index = source_index > target_index ? target_index : target_index - 1;
        this.remove(source_index);
        this.insertTab(source_title, source_icon, source_component, source_tip, distination_index);
        this.setEnabledAt(distination_index, source_is_enabled);
        if (source_is_enabled) {
            this.setSelectedIndex(distination_index);
        }
        this.setTabComponentAt(distination_index, source_tab_component);
    }

    public void paintDropLine(Graphics g) {
        DropLocation loc = this.getDropLocation();
        if (loc == null) {
            return;
        }
        Graphics2D g2 = (Graphics2D)g;
        g2.setColor(Color.RED);
        Rectangle r = SwingUtilities.convertRectangle(this, this.getDropLineRect(loc), this.getRootPane().getGlassPane());
        g2.fill(r);
    }

    public Rectangle getDropLineRect(DropLocation loc) {
        int index = loc.getIndex();
        if (index < 0) {
            this.lineRect.setRect(0.0, 0.0, 0.0, 0.0);
            return this.lineRect;
        }
        boolean isZero = index == 0;
        Rectangle r = this.getBoundsAt(isZero ? 0 : index - 1);
        if (this.getTabPlacement() == 1 || this.getTabPlacement() == 3) {
            this.lineRect.setRect(r.x - 1 + r.width * (isZero ? 0 : 1), r.y, 3.0, r.height);
        } else {
            this.lineRect.setRect(r.x, r.y - 1 + r.height * (isZero ? 0 : 1), r.width, 3.0);
        }
        return this.lineRect;
    }

    public Rectangle getTabAreaBounds() {
        Rectangle tabbedRect = this.getBounds();
        int xx = tabbedRect.x;
        int yy = tabbedRect.y;
        Component c = this.getSelectedComponent();
        if (c == null) {
            return tabbedRect;
        }
        Rectangle compRect = this.getSelectedComponent().getBounds();
        int tabPlacement = this.getTabPlacement();
        if (tabPlacement == 1) {
            tabbedRect.height -= compRect.height;
        } else if (tabPlacement == 3) {
            tabbedRect.y = tabbedRect.y + compRect.y + compRect.height;
            tabbedRect.height -= compRect.height;
        } else if (tabPlacement == 2) {
            tabbedRect.width -= compRect.width;
        } else if (tabPlacement == 4) {
            tabbedRect.x = tabbedRect.x + compRect.x + compRect.width;
            tabbedRect.width -= compRect.width;
        }
        tabbedRect.translate(-xx, -yy);
        return tabbedRect;
    }

    private class Handler
    implements MouseInputListener,
    PropertyChangeListener {
        private Point startPt;
        int gestureMotionThreshold = DragSource.getDragThreshold();

        private Handler() {
        }

        private void repaintDropLocation(DropLocation loc) {
            Component c = DnDTabbedPane.this.getRootPane().getGlassPane();
            if (c instanceof GhostGlassPane) {
                GhostGlassPane glassPane = (GhostGlassPane)c;
                glassPane.setTargetTabbedPane(DnDTabbedPane.this);
                glassPane.repaint();
            }
        }

        @Override
        public void propertyChange(PropertyChangeEvent e) {
            String propertyName = e.getPropertyName();
            if ("dropLocation".equals(propertyName)) {
                this.repaintDropLocation(DnDTabbedPane.this.getDropLocation());
            }
        }

        @Override
        public void mousePressed(MouseEvent e) {
            DnDTabbedPane src = (DnDTabbedPane)e.getSource();
            if (src.getTabCount() <= 1) {
                this.startPt = null;
                return;
            }
            Point tabPt = e.getPoint();
            int idx = src.indexAtLocation(tabPt.x, tabPt.y);
            this.startPt = idx < 0 || !src.isEnabledAt(idx) || src.getComponentAt(idx) == null ? null : tabPt;
        }

        @Override
        public void mouseDragged(MouseEvent e) {
            Point tabPt = e.getPoint();
            if (this.startPt != null && Math.sqrt(Math.pow(tabPt.x - this.startPt.x, 2.0) + Math.pow(tabPt.y - this.startPt.y, 2.0)) > (double)this.gestureMotionThreshold) {
                DnDTabbedPane src = (DnDTabbedPane)e.getSource();
                TransferHandler th = src.getTransferHandler();
                DnDTabbedPane.this.dragTabIndex = src.indexAtLocation(tabPt.x, tabPt.y);
                th.exportAsDrag(src, e, 2);
                DnDTabbedPane.this.lineRect.setRect(0.0, 0.0, 0.0, 0.0);
                src.getRootPane().getGlassPane().setVisible(true);
                src.setDropLocation(new DropLocation(tabPt, -1), null, true);
                this.startPt = null;
            }
        }

        @Override
        public void mouseClicked(MouseEvent e) {
        }

        @Override
        public void mouseEntered(MouseEvent e) {
        }

        @Override
        public void mouseExited(MouseEvent e) {
        }

        @Override
        public void mouseMoved(MouseEvent e) {
        }

        @Override
        public void mouseReleased(MouseEvent e) {
        }
    }

    public static final class DropLocation
    extends TransferHandler.DropLocation {
        private final int index;
        private boolean dropable = true;

        private DropLocation(Point p, int index) {
            super(p);
            this.index = index;
        }

        public int getIndex() {
            return this.index;
        }

        public void setDropable(boolean flag) {
            this.dropable = flag;
        }

        public boolean isDropable() {
            return this.dropable;
        }
    }
}

