/*
 * Decompiled with CFR 0.152.
 */
package open.dolphin.order;

import java.util.List;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JTable;
import open.dolphin.client.IStampModelEditor;
import open.dolphin.infomodel.RegisteredDiagnosisModel;
import open.dolphin.table.ObjectTableModel;

public class DiagnosisStateMgr {
    private final EmptyState empty = new EmptyState();
    private final ValidState valid = new ValidState();
    private final InValidState invalid = new InValidState();
    private JButton delete;
    private JButton clear;
    private JLabel stateLabel;
    private ObjectTableModel tableModel;
    private JTable table;
    private DiagnosisState curState;
    private IStampModelEditor context;
    private int baseCnt;
    private boolean hasModifier;

    public DiagnosisStateMgr(JButton delete, JButton clear, JLabel stateLabel, ObjectTableModel tableModel, JTable table, IStampModelEditor context) {
        this.delete = delete;
        this.clear = clear;
        this.stateLabel = stateLabel;
        this.tableModel = tableModel;
        this.table = table;
        this.context = context;
        this.curState = this.empty;
    }

    public void processEvent(Event evt) {
        this.curState = this.curState.processEvent(evt);
    }

    public void enter() {
        this.curState.enter();
    }

    protected DiagnosisState judgeState() {
        List dataList = this.tableModel.getObjectList();
        if (dataList == null || dataList.size() == 0) {
            return this.empty;
        }
        this.hasModifier = false;
        this.baseCnt = 0;
        for (RegisteredDiagnosisModel rm : dataList) {
            if (rm.getDiagnosisCode().startsWith("ZZZ")) {
                this.hasModifier = true;
                continue;
            }
            ++this.baseCnt;
        }
        if (this.hasModifier) {
            return this.baseCnt == 1 ? this.valid : this.invalid;
        }
        return this.valid;
    }

    private class InValidState
    extends DiagnosisState {
        private InValidState() {
        }

        @Override
        public DiagnosisState processEvent(Event evt) {
            DiagnosisState next = null;
            switch (evt) {
                case ADDED: {
                    next = DiagnosisStateMgr.this.judgeState();
                    next.enter();
                    break;
                }
                case DELETED: {
                    next = DiagnosisStateMgr.this.judgeState();
                    next.enter();
                    break;
                }
                case CLEARED: {
                    next = DiagnosisStateMgr.this.empty;
                    next.enter();
                    break;
                }
                case SELECTED: {
                    next = this;
                    next.enter();
                }
            }
            return next;
        }

        @Override
        public void enter() {
            int row = DiagnosisStateMgr.this.table.getSelectedRow();
            boolean b = DiagnosisStateMgr.this.tableModel.isValidRow(row);
            DiagnosisStateMgr.this.delete.setEnabled(b);
            DiagnosisStateMgr.this.clear.setEnabled(true);
            if (DiagnosisStateMgr.this.baseCnt == 0) {
                DiagnosisStateMgr.this.stateLabel.setText("\u57fa\u672c\u50b7\u75c5\u540d\u304c\u3042\u308a\u307e\u305b\u3093\u3002");
            } else {
                DiagnosisStateMgr.this.stateLabel.setText("\u4fee\u98fe\u8a9e\u304c\u3042\u308b\u5834\u5408\u306f\u3001\u57fa\u672c\u50b7\u75c5\u540d\u306f\u4e00\u3064\u3067\u3059\u3002");
            }
            DiagnosisStateMgr.this.context.setValidModel(false);
        }
    }

    private class ValidState
    extends DiagnosisState {
        private ValidState() {
        }

        @Override
        public DiagnosisState processEvent(Event evt) {
            DiagnosisState next = null;
            switch (evt) {
                case ADDED: {
                    next = DiagnosisStateMgr.this.judgeState();
                    next.enter();
                    break;
                }
                case DELETED: {
                    next = DiagnosisStateMgr.this.judgeState();
                    next.enter();
                    break;
                }
                case CLEARED: {
                    next = DiagnosisStateMgr.this.empty;
                    next.enter();
                    break;
                }
                case SELECTED: {
                    next = this;
                    next.enter();
                }
            }
            return next;
        }

        @Override
        public void enter() {
            int row = DiagnosisStateMgr.this.table.getSelectedRow();
            boolean b = DiagnosisStateMgr.this.tableModel.isValidRow(row);
            DiagnosisStateMgr.this.delete.setEnabled(b);
            DiagnosisStateMgr.this.clear.setEnabled(true);
            DiagnosisStateMgr.this.stateLabel.setText("\u6709\u52b9\u306a\u30c7\u30fc\u30bf\u306b\u306a\u3063\u3066\u3044\u307e\u3059\u3002");
            DiagnosisStateMgr.this.context.setValidModel(true);
        }
    }

    private class EmptyState
    extends DiagnosisState {
        private EmptyState() {
        }

        @Override
        public DiagnosisState processEvent(Event evt) {
            DiagnosisState next = null;
            switch (evt) {
                case ADDED: {
                    next = DiagnosisStateMgr.this.judgeState();
                    next.enter();
                    break;
                }
                case SELECTED: {
                    next = this;
                    next.enter();
                }
            }
            return next;
        }

        @Override
        public void enter() {
            DiagnosisStateMgr.this.delete.setEnabled(false);
            DiagnosisStateMgr.this.clear.setEnabled(false);
            DiagnosisStateMgr.this.stateLabel.setText("\u50b7\u75c5\u540d\u304c\u3042\u308a\u307e\u305b\u3093\u3002");
            DiagnosisStateMgr.this.context.setValidModel(false);
        }
    }

    protected abstract class DiagnosisState {
        protected DiagnosisState() {
        }

        public abstract DiagnosisState processEvent(Event var1);

        public abstract void enter();
    }

    public static enum Event {
        ADDED,
        DELETED,
        CLEARED,
        SELECTED;

    }
}

