/*
 * Decompiled with CFR 0.152.
 */
package open.dolphin.table;

import java.awt.Color;
import java.awt.Component;
import javax.swing.JLabel;
import javax.swing.JTable;
import javax.swing.table.TableCellRenderer;
import open.dolphin.project.GlobalSettings;

public class OddEvenRowRenderer
extends JLabel
implements TableCellRenderer {
    private static final Color DEFAULT_ODD_COLOR = GlobalSettings.getColors(GlobalSettings.Parts.ODD);
    private static final Color DEFAULT_EVENN_COLOR = GlobalSettings.getColors(GlobalSettings.Parts.EVEN);
    private Color oddColor;
    private Color evenColor;

    public OddEvenRowRenderer() {
        this(DEFAULT_ODD_COLOR, DEFAULT_EVENN_COLOR);
    }

    public OddEvenRowRenderer(Color oddColor, Color evenColor) {
        this.setOpaque(true);
        this.setOddColor(oddColor);
        this.setEvenColor(evenColor);
    }

    @Override
    public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
        if (isSelected) {
            this.setBackground(table.getSelectionBackground());
            this.setForeground(table.getSelectionForeground());
        } else {
            this.setForeground(table.getForeground());
            if (row % 2 == 0) {
                this.setBackground(this.getEvenColor());
            } else {
                this.setBackground(this.getOddColor());
            }
        }
        if (value != null) {
            if (value instanceof String) {
                this.setText((String)value);
            } else {
                this.setText(value.toString());
            }
        } else {
            this.setText("");
        }
        return this;
    }

    public void setOddColor(Color oddColor) {
        this.oddColor = oddColor;
    }

    public Color getOddColor() {
        return this.oddColor;
    }

    public void setEvenColor(Color evenColor) {
        this.evenColor = evenColor;
    }

    public Color getEvenColor() {
        return this.evenColor;
    }
}

