/*
 * Decompiled with CFR 0.152.
 */
package open.dolphin.utils;

import java.util.GregorianCalendar;
import java.util.StringTokenizer;

public final class AgeCalculator {
    public static String getAge(String mmlBirthday) {
        try {
            GregorianCalendar birthday = AgeCalculator.getCalendar(mmlBirthday);
            GregorianCalendar today = new GregorianCalendar();
            int todaymonth = today.get(2) + today.get(1) * 12;
            int birthmonth = birthday.get(2) + birthday.get(1) * 12;
            int pastmonth = todaymonth - birthmonth;
            int month = pastmonth % 12;
            int years = pastmonth / 12;
            StringBuffer buf = new StringBuffer();
            if (years < 10) {
                buf.append("  ");
            } else {
                buf.append(" ");
            }
            buf.append(years);
            buf.append("\u6b73");
            if (years <= 6 && month != 0) {
                if (month < 10) {
                    buf.append("0");
                }
                buf.append(month);
                buf.append("\u30f6\u6708");
            }
            return buf.toString();
        }
        catch (Exception e) {
            return null;
        }
    }

    private static GregorianCalendar getCalendar(String mmlDate) {
        String daySt;
        int index = mmlDate.indexOf(84);
        if (index != -1) {
            mmlDate.substring(0, index);
        }
        StringTokenizer st = new StringTokenizer(mmlDate, "-");
        String yearSt = st.nextToken();
        String monthSt = st.nextToken();
        if (monthSt.startsWith("0")) {
            monthSt = monthSt.substring(1);
        }
        if ((daySt = st.nextToken()).startsWith("0")) {
            daySt = daySt.substring(1);
        }
        int year = Integer.parseInt(yearSt);
        int month = Integer.parseInt(monthSt);
        int day = Integer.parseInt(daySt);
        return new GregorianCalendar(year, --month, day);
    }
}

