/*
 * Decompiled with CFR 0.152.
 */
package open.dolphin.client;

import java.awt.Toolkit;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.util.ArrayList;
import java.util.Enumeration;
import javax.swing.JComponent;
import javax.swing.JTable;
import javax.swing.TransferHandler;
import javax.swing.tree.TreeNode;
import open.dolphin.client.LocalStampTreeNodeTransferable;
import open.dolphin.client.diagnosisdocumentpanel.DiagnosisDocumentPanel;
import open.dolphin.client.editor.stamp.StampTreeNode;
import open.dolphin.infomodel.InfoModelTransferable;
import open.dolphin.infomodel.ModuleInfoBean;
import open.dolphin.infomodel.RegisteredDiagnosisModel;
import open.dolphin.table.ObjectReflectTableModel;

public class DiagnosisTransferHandler
extends TransferHandler {
    private JTable sourceTable;
    private RegisteredDiagnosisModel dragItem;
    private boolean shouldRemove;
    private DiagnosisDocumentPanel parent;

    public DiagnosisTransferHandler(DiagnosisDocumentPanel parent) {
        this.parent = parent;
    }

    @Override
    protected Transferable createTransferable(JComponent c) {
        this.sourceTable = (JTable)c;
        ObjectReflectTableModel tableModel = (ObjectReflectTableModel)this.sourceTable.getModel();
        this.dragItem = (RegisteredDiagnosisModel)tableModel.getObject(this.sourceTable.getSelectedRow());
        return this.dragItem != null ? new InfoModelTransferable(this.dragItem) : null;
    }

    @Override
    public int getSourceActions(JComponent c) {
        return 3;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public boolean importData(JComponent c, Transferable t) {
        if (this.canImport(c, t.getTransferDataFlavors())) {
            try {
                JTable dropTable = (JTable)c;
                int index = dropTable.getSelectedRow();
                index = 0;
                if (index < 0) {
                    index = 0;
                }
                StampTreeNode droppedNode = (StampTreeNode)t.getTransferData(LocalStampTreeNodeTransferable.localStampTreeNodeFlavor);
                ArrayList<ModuleInfoBean> importList = new ArrayList<ModuleInfoBean>(3);
                if (droppedNode.isLeaf()) {
                    ModuleInfoBean stampInfo = droppedNode.getStampInfo();
                    if (!stampInfo.getEntity().equals("diagnosis")) {
                        Toolkit.getDefaultToolkit().beep();
                        return false;
                    }
                    if (!stampInfo.isSerialized()) {
                        this.parent.openEditor2();
                        this.shouldRemove = false;
                        return true;
                    }
                    importList.add(stampInfo);
                } else {
                    Enumeration<TreeNode> e = droppedNode.preorderEnumeration();
                    while (e.hasMoreElements()) {
                        ModuleInfoBean stampInfo;
                        StampTreeNode node = (StampTreeNode)e.nextElement();
                        if (!node.isLeaf() || !(stampInfo = node.getStampInfo()).isSerialized() || !stampInfo.getEntity().equals("diagnosis")) continue;
                        importList.add(stampInfo);
                    }
                }
                if (importList.size() > 0) {
                    this.parent.importStampList(importList, index);
                    return true;
                }
                return false;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return false;
    }

    @Override
    protected void exportDone(JComponent c, Transferable data, int action) {
        if (action == 2 && this.shouldRemove) {
            ObjectReflectTableModel tableModel = (ObjectReflectTableModel)this.sourceTable.getModel();
            tableModel.deleteRow(this.dragItem);
        }
    }

    @Override
    public boolean canImport(JComponent c, DataFlavor[] flavors) {
        for (int i = 0; i < flavors.length; ++i) {
            if (!LocalStampTreeNodeTransferable.localStampTreeNodeFlavor.equals(flavors[i])) continue;
            JTable t = (JTable)c;
            t.getSelectionModel().setSelectionInterval(0, 0);
            return true;
        }
        return false;
    }
}

