/*
 * Decompiled with CFR 0.152.
 */
package open.dolphin.client.editor.stamp;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import javax.swing.AbstractAction;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JPanel;
import open.dolphin.client.BlockGlass;
import open.dolphin.client.IStampEditorDialog;
import open.dolphin.client.IStampModelEditor;
import open.dolphin.client.editor.stamp.StampModelEditor;
import open.dolphin.helper.ComponentMemory;
import open.dolphin.log.LogWriter;
import open.dolphin.order.BaseChargeStampEditor;
import open.dolphin.order.DiagnosisEditor;
import open.dolphin.order.GeneralStampEditor;
import open.dolphin.order.InjectionStampEditor;
import open.dolphin.order.InstractionChargeStampEditor;
import open.dolphin.order.OtherStampEditor;
import open.dolphin.order.PharmaceuticalsStampEditor;
import open.dolphin.order.PhysiologyStampEditor;
import open.dolphin.order.RadiologyStampEditor;
import open.dolphin.order.StayOnHomeChargeStampEditor;
import open.dolphin.order.SurgeryStampEditor;
import open.dolphin.order.TestStampEditor;
import open.dolphin.order.TreatmentStampEditor;

public class StampEditorDialog
extends JDialog
implements IStampEditorDialog,
PropertyChangeListener {
    public static final String VALIDA_DATA_PROP = "validData";
    public static final String VALUE_PROP = "value";
    private static final String OK_ICON_KARTE = "/open/dolphin/resources/images/lgicn_16.gif";
    private static final String OK_ICON_STAMPBOX = "/open/dolphin/resources/images/tools_16.gif";
    private JButton okButton;
    private IStampModelEditor editor;
    private PropertyChangeSupport boundSupport = new PropertyChangeSupport(this);
    private String entity;
    private Object value;
    private boolean toKarte;
    private BlockGlass glass;
    private static final int DEFAULT_X = 159;
    private static final int DEFAULT_Y = 67;
    private static final int DEFAULT_WIDTH = 924;
    private static final int DEFAULT_HEIGHT = 616;
    private JPanel panel;

    public StampEditorDialog(String entity, Object value, boolean toKarte) {
        super((Frame)null);
        this.initComponents();
        this.entity = entity;
        this.value = value;
        this.toKarte = toKarte;
    }

    public StampEditorDialog(String entity, Object value) {
        this(entity, value, true);
    }

    public void start() {
        this.initialize();
    }

    private void initialize() {
        this.setModal(this.toKarte);
        if (this.toKarte) {
            this.okButton = new JButton(this.createImageIcon(OK_ICON_KARTE));
            this.okButton.setToolTipText("\u30ab\u30eb\u30c6\u306b\u5c55\u958b\u3057\u307e\u3059");
        } else {
            this.okButton = new JButton(this.createImageIcon(OK_ICON_STAMPBOX));
            this.okButton.setToolTipText("\u30b9\u30bf\u30f3\u30d7\u30dc\u30c3\u30af\u30b9\u306b\u4fdd\u5b58\u3057\u307e\u3059");
        }
        this.glass = new BlockGlass();
        this.setGlassPane(this.glass);
        AbstractAction action = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                StampEditorDialog.this.okButtonClicked(e);
            }
        };
        this.okButton.addActionListener(action);
        this.okButton.setMnemonic('O');
        this.okButton.setEnabled(false);
        try {
            this.editor = this.createEditor(this.entity);
            this.editor.setContext(this);
            this.editor.start();
            this.editor.addPropertyChangeListener(VALIDA_DATA_PROP, this);
            this.editor.setValue(this.value);
        }
        catch (Exception e) {
            LogWriter.error(this.getClass(), e);
            return;
        }
        this.panel.add((Component)((Object)this.editor), "Center");
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                StampEditorDialog.this.value = null;
                StampEditorDialog.this.close();
            }
        });
        this.setTitle(this.editor.getTitle());
        ComponentMemory cm = new ComponentMemory(this, new Point(159, 67), new Dimension(924, 616), this);
        cm.setToPreferenceBounds();
        this.setVisible(true);
    }

    public Object getValue() {
        return this.editor.getValue();
    }

    @Override
    public void addPropertyChangeListener(String prop, PropertyChangeListener listener) {
        this.boundSupport.addPropertyChangeListener(prop, listener);
    }

    @Override
    public void removePropertyChangeListener(String prop, PropertyChangeListener listener) {
        this.boundSupport.removePropertyChangeListener(prop, listener);
    }

    @Override
    public JButton getOkButton() {
        return this.okButton;
    }

    public void okButtonClicked(ActionEvent e) {
        this.value = this.getValue();
        if (this.toKarte) {
            this.close();
        } else {
            this.boundSupport.firePropertyChange(VALUE_PROP, null, this.value);
        }
    }

    public void addStampButtonClicked(ActionEvent e) {
        this.value = null;
        this.close();
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        Boolean i = (Boolean)evt.getNewValue();
        this.okButton.setEnabled(i);
    }

    @Override
    public void close() {
        this.editor.dispose();
        this.setVisible(false);
        this.dispose();
        this.boundSupport.firePropertyChange(VALUE_PROP, null, this.value);
    }

    private ImageIcon createImageIcon(String name) {
        return new ImageIcon(this.getClass().getResource(name));
    }

    private IStampModelEditor createEditor(String entity) {
        StampModelEditor result = null;
        if (entity.equals("diagnosis")) {
            result = new DiagnosisEditor();
        } else if (entity.equals("medOrder")) {
            result = new PharmaceuticalsStampEditor();
        } else if (entity.equals("injectionOrder")) {
            result = new InjectionStampEditor();
        } else if (entity.equals("testOrder")) {
            result = new TestStampEditor();
        } else if (entity.equals("physiologyOrder")) {
            result = new PhysiologyStampEditor();
        } else if (entity.equals("treatmentOrder")) {
            result = new TreatmentStampEditor();
        } else if (entity.equals("radiologyOrder")) {
            result = new RadiologyStampEditor();
        } else if (entity.equals("baseChargeOrder")) {
            result = new BaseChargeStampEditor();
        } else if (entity.equals("instractionChargeOrder")) {
            result = new InstractionChargeStampEditor();
        } else if (entity.equals("stayOnHomeChargeOrder")) {
            result = new StayOnHomeChargeStampEditor();
        } else if (entity.equals("otherOrder")) {
            result = new OtherStampEditor();
        } else if (entity.equals("generalOrder")) {
            result = new GeneralStampEditor();
        } else if (entity.equals("surgeryOrder")) {
            result = new SurgeryStampEditor();
        }
        LogWriter.debug(this.getClass(), "StampEditor class = " + result.getClass().getName());
        return result;
    }

    private void initComponents() {
        this.panel = new JPanel();
        this.setDefaultCloseOperation(2);
        this.panel.setName("panel");
        this.panel.setLayout(new BorderLayout(11, 0));
        this.getContentPane().add((Component)this.panel, "Center");
        this.pack();
    }
}

