/*
 * Decompiled with CFR 0.152.
 */
package open.dolphin.client.imagebrowserdocument;

import java.util.List;
import javax.swing.table.AbstractTableModel;
import open.dolphin.client.ImageEntry;

public class ImageTableModel
extends AbstractTableModel {
    private String[] columnNames;
    private int columnCount;
    private List imageList;

    public ImageTableModel(String[] columnNames, int columnCount) {
        this.columnNames = columnNames;
        this.columnCount = columnCount;
    }

    @Override
    public String getColumnName(int col) {
        return this.columnNames != null && col < this.columnNames.length ? this.columnNames[col] : null;
    }

    @Override
    public int getColumnCount() {
        return this.columnCount;
    }

    @Override
    public int getRowCount() {
        if (this.imageList == null) {
            return 0;
        }
        int size = this.imageList.size();
        int rowCount = size / this.columnCount;
        return size % this.columnCount != 0 ? rowCount + 1 : rowCount;
    }

    @Override
    public Object getValueAt(int row, int col) {
        int index = row * this.columnCount + col;
        if (!this.isValidIndex(index)) {
            return null;
        }
        ImageEntry entry = (ImageEntry)this.imageList.get(index);
        return entry;
    }

    public void setImageList(List list) {
        if (this.imageList != null) {
            this.imageList.clear();
            this.imageList = null;
        }
        this.imageList = list;
        this.fireTableDataChanged();
    }

    public List getImageList() {
        return this.imageList;
    }

    private boolean isValidIndex(int index) {
        return this.imageList != null && index >= 0 && index < this.imageList.size();
    }

    public void clear() {
        if (this.imageList != null) {
            this.imageList.clear();
            this.fireTableDataChanged();
        }
    }
}

