/*
 * Decompiled with CFR 0.152.
 */
package open.dolphin.client.karte;

import java.awt.Component;
import java.awt.Container;
import java.awt.LayoutManager;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JTabbedPane;
import javax.swing.JTable;
import javax.swing.table.DefaultTableModel;
import open.dolphin.client.IChart;
import open.dolphin.client.IChartCommandAccepter;
import open.dolphin.client.IChartDocument;
import open.dolphin.client.karte.AllergyEditorPanel;
import open.dolphin.delegater.remote.RemoteDocumentDelegater;
import open.dolphin.helper.DBTask;
import open.dolphin.infomodel.AllergyModel;
import open.dolphin.infomodel.ModelUtils;
import open.dolphin.infomodel.ObservationModel;
import open.dolphin.project.GlobalSettings;
import open.dolphin.project.GlobalVariables;
import open.dolphin.table.ObjectReflectTableModel;
import open.dolphin.table.OddEvenRowRenderer;
import org.jdesktop.layout.GroupLayout;

public class AllergyPanel
extends JPanel
implements IChartDocument {
    public static final String TITLE = "\u30a2\u30ec\u30eb\u30ae";
    private ObjectReflectTableModel<AllergyModel> tableModel;
    private IChart parent;
    private String title = "\u30a2\u30ec\u30eb\u30ae";
    private JScrollPane scroller;
    private JTable table;

    private void initComponents() {
        this.scroller = new JScrollPane();
        this.table = new JTable();
        this.setName("Form");
        this.scroller.setName("scroller");
        this.table.setModel(new DefaultTableModel(new Object[][]{{null, null, null}}, new String[]{"\u8981 \u56e0", "\u53cd\u5fdc\u7a0b\u5ea6", "\u540c\u5b9a\u65e5"}));
        this.table.setName("table");
        this.table.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent evt) {
                AllergyPanel.this.tableMousePressed(evt);
            }

            @Override
            public void mouseReleased(MouseEvent evt) {
                AllergyPanel.this.tableMouseReleased(evt);
            }
        });
        this.scroller.setViewportView(this.table);
        GroupLayout layout = new GroupLayout((Container)this);
        this.setLayout((LayoutManager)layout);
        layout.setHorizontalGroup((GroupLayout.Group)layout.createParallelGroup(1).add((Component)this.scroller, -1, 242, Short.MAX_VALUE));
        layout.setVerticalGroup((GroupLayout.Group)layout.createParallelGroup(1).add((Component)this.scroller, -1, 86, Short.MAX_VALUE));
    }

    private void tableMousePressed(MouseEvent evt) {
        this.showPopup(evt);
    }

    private void tableMouseReleased(MouseEvent evt) {
        this.showPopup(evt);
    }

    @Override
    public IChartDocument.TYPE getType() {
        return IChartDocument.TYPE.AllergyPanel;
    }

    public JTable getTable() {
        return this.table;
    }

    public AllergyPanel(IChart parent) {
        this.parent = parent;
        this.initComponents();
        this.initCustomComponents();
        this.update();
    }

    public void clear() {
        this.tableModel.clear();
    }

    private void showPopup(MouseEvent e) {
        if (e.isPopupTrigger()) {
            JPopupMenu popupMenu = new JPopupMenu();
            JMenuItem menuItem = new JMenuItem("\u8ffd\u52a0");
            popupMenu.add(menuItem);
            menuItem.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    new AllergyEditorPanel(AllergyPanel.this);
                }
            });
            final int row = this.table.rowAtPoint(e.getPoint());
            if (this.tableModel.getObject(row) != null) {
                popupMenu.add(new JSeparator());
                JMenuItem item2 = new JMenuItem("\u524a\u9664");
                popupMenu.add(item2);
                item2.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        AllergyPanel.this.delete(row);
                    }
                });
            }
            popupMenu.show(e.getComponent(), e.getX(), e.getY());
        }
    }

    private void initCustomComponents() {
        String[] columnNames = new String[]{"\u8981 \u56e0", "\u53cd\u5fdc\u7a0b\u5ea6", "\u540c\u5b9a\u65e5"};
        int startNumRows = 1;
        String[] methodNames = new String[]{"getFactor", "getSeverity", "getIdentifiedFormatDate"};
        this.tableModel = new ObjectReflectTableModel(columnNames, startNumRows, methodNames, null);
        this.table.setModel(this.tableModel);
        this.table.getSelectionModel().setSelectionMode(0);
        this.table.setDefaultRenderer(Object.class, new OddEvenRowRenderer());
        this.scroller.getViewport().setBackground(GlobalSettings.getColors(GlobalSettings.Parts.TABLE_BACKGROUND));
    }

    private void scroll(boolean ascending) {
        int cnt = this.tableModel.getObjectCount();
        if (cnt > 0) {
            int row = 0;
            if (ascending) {
                row = cnt - 1;
            }
            Rectangle r = this.table.getCellRect(row, row, true);
            this.table.scrollRectToVisible(r);
        }
    }

    public void update() {
        List list = this.getParentContext().getKarte().getEntryCollection("allergy");
        if (list != null && list.size() > 0) {
            boolean asc = GlobalVariables.getPreferences().getBoolean("docHistory.ascending", false);
            if (asc) {
                Collections.sort(list);
            } else {
                Collections.sort(list, Collections.reverseOrder());
            }
            this.tableModel.setObjectList(list);
            this.scroll(asc);
        }
    }

    public void add(final AllergyModel model) {
        Date date = ModelUtils.getDateTimeAsObject(model.getIdentifiedDate() + "T00:00:00");
        final ArrayList<ObservationModel> addList = new ArrayList<ObservationModel>(1);
        ObservationModel observation = new ObservationModel();
        observation.setKarte(this.getParentContext().getKarte());
        observation.setCreator(GlobalVariables.getUserModel());
        observation.setObservation("Allergy");
        observation.setPhenomenon(model.getFactor());
        observation.setCategoryValue(model.getSeverity());
        observation.setConfirmed(date);
        observation.setRecorded(new Date());
        observation.setStarted(date);
        observation.setStatus("F");
        observation.setMemo(model.getMemo());
        addList.add(observation);
        DBTask<List<Long>> task = new DBTask<List<Long>>(this.getParentContext()){

            @Override
            protected List<Long> doInBackground() throws Exception {
                RemoteDocumentDelegater ddl = new RemoteDocumentDelegater();
                List<Long> ids = ddl.addObservations(addList);
                return ids;
            }

            @Override
            protected void succeeded(List<Long> result) {
                model.setObservationId(result.get(0));
                boolean asc = GlobalVariables.getPreferences().getBoolean("docHistory.ascending", false);
                if (asc) {
                    AllergyPanel.this.tableModel.addRow(model);
                } else {
                    AllergyPanel.this.tableModel.addRow(0, model);
                }
                AllergyPanel.this.scroll(asc);
            }
        };
        task.execute();
    }

    public void delete(final int row) {
        AllergyModel model = this.tableModel.getObject(row);
        if (model != null) {
            final ArrayList<Long> list = new ArrayList<Long>(1);
            list.add(new Long(model.getObservationId()));
            DBTask<Void> task = new DBTask<Void>(this.getParentContext()){

                @Override
                protected Void doInBackground() throws Exception {
                    RemoteDocumentDelegater ddl = new RemoteDocumentDelegater();
                    ddl.removeObservations(list);
                    return null;
                }

                @Override
                protected void succeeded(Void result) {
                    AllergyPanel.this.tableModel.deleteRow(row);
                }
            };
            task.execute();
        }
    }

    @Override
    public boolean itLayoutSaved() {
        return true;
    }

    @Override
    public String getTitle() {
        return this.title;
    }

    @Override
    public IChart getParentContext() {
        return this.parent;
    }

    @Override
    public void start() {
    }

    @Override
    public void stop() {
    }

    @Override
    public void enter() {
    }

    @Override
    public boolean prepare() {
        return true;
    }

    @Override
    public boolean isDirty() {
        return false;
    }

    @Override
    public void setDirty(boolean dirty) {
    }

    @Override
    public boolean dispatchChartCommand(IChartCommandAccepter.ChartCommand command) {
        return false;
    }

    @Override
    public List<JTabbedPane> getTabbedPanels() {
        return null;
    }
}

