/*
 * Decompiled with CFR 0.152.
 */
package open.dolphin.client.settings;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.DefaultComboBoxModel;
import javax.swing.GroupLayout;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import open.dolphin.client.AutoRomanListener;
import open.dolphin.client.RegexConstrainedDocument;
import open.dolphin.client.settings.IAbstractSettingPanel;
import open.dolphin.client.settings.ProjectSettingDialog;
import open.dolphin.project.GlobalSettings;
import open.dolphin.project.GlobalVariables;

public class ClaimSettingPanel
extends JPanel
implements IAbstractSettingPanel {
    private ProjectSettingDialog context;
    private PropertyChangeSupport boundSupport;
    private IAbstractSettingPanel.State state = IAbstractSettingPanel.State.NONE_STATE;
    private boolean loginState;
    private String title;
    private String icon;
    private String id;
    private static final String ID = "claimSetting";
    private static final String TITLE = "\u30ec\u30bb\u30b3\u30f3";
    private static final String ICON = "calc_24.gif";
    private ClaimModel model;
    private StateMgr stateMgr;
    private ButtonGroup bg1;
    private ButtonGroup bg2;
    private JTextField claimAddressField;
    private JComboBox claimHostCombo;
    private JTextField claimPortField;
    private JTextField jmariField;
    private JLabel label1;
    private JLabel label2;
    private JLabel label3;
    private JLabel label5;
    private JLabel label6;
    private JLabel label7;
    private JPanel panel1;
    private JPanel port;
    private JPanel pvt;
    private JPanel sendClaim;
    private JRadioButton sendClaimNo;
    private JRadioButton sendClaimYes;
    private JCheckBox useAsPVTServer;
    private JRadioButton v34;
    private JRadioButton v40;
    private JPanel vPanel;

    public ClaimSettingPanel() {
        this.boundSupport = new PropertyChangeSupport(this);
        this.initComponents();
        this.setId(ID);
        this.setTitle(TITLE);
        this.setIcon(ICON);
    }

    private void initComponents() {
        this.bg1 = new ButtonGroup();
        this.bg2 = new ButtonGroup();
        this.sendClaim = new JPanel();
        this.panel1 = new JPanel();
        this.label1 = new JLabel();
        this.sendClaimYes = new JRadioButton();
        this.sendClaimNo = new JRadioButton();
        this.port = new JPanel();
        this.label2 = new JLabel();
        this.claimHostCombo = new JComboBox();
        this.label3 = new JLabel();
        this.vPanel = new JPanel();
        this.label5 = new JLabel();
        this.jmariField = new JTextField();
        this.label6 = new JLabel();
        this.claimAddressField = new JTextField();
        this.label7 = new JLabel();
        this.claimPortField = new JTextField();
        this.v34 = new JRadioButton();
        this.v40 = new JRadioButton();
        this.pvt = new JPanel();
        this.useAsPVTServer = new JCheckBox();
        this.sendClaim.setBorder(BorderFactory.createTitledBorder("CLAIM\uff08\u8acb\u6c42\u30c7\u30fc\u30bf\uff09\u9001\u4fe1"));
        this.sendClaim.setName("sendClaim");
        this.sendClaim.setLayout(new BorderLayout());
        this.panel1.setName("panel1");
        this.panel1.setLayout(new FlowLayout(0, 0, 5));
        this.label1.setText("\u8a3a\u7642\u884c\u70ba\u9001\u4fe1:");
        this.label1.setName("label1");
        this.panel1.add(this.label1);
        this.bg1.add(this.sendClaimYes);
        this.sendClaimYes.setText("\u9001\u4fe1\u3059\u308b");
        this.sendClaimYes.setName("sendClaimYes");
        this.sendClaimYes.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ClaimSettingPanel.this.sendClaimYesActionPerformed(evt);
            }
        });
        this.panel1.add(this.sendClaimYes);
        this.bg1.add(this.sendClaimNo);
        this.sendClaimNo.setText("\u9001\u4fe1\u3057\u306a\u3044");
        this.sendClaimNo.setName("sendClaimNo");
        this.sendClaimNo.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ClaimSettingPanel.this.sendClaimNoActionPerformed(evt);
            }
        });
        this.panel1.add(this.sendClaimNo);
        this.sendClaim.add((Component)this.panel1, "First");
        this.port.setBorder(BorderFactory.createTitledBorder("\u30ec\u30bb\u30b3\u30f3\u60c5\u5831"));
        this.port.setName("port");
        this.label2.setText("\u6a5f\u7a2e:");
        this.label2.setName("label2");
        this.claimHostCombo.setModel(new DefaultComboBoxModel<String>(new String[]{"\u65e5\u533b\u6a19\u6e96\u30ec\u30bb\u30b3\u30f3(ORCA)"}));
        this.claimHostCombo.setName("claimHostCombo");
        this.label3.setText("\u30d0\u30fc\u30b8\u30e7\u30f3:");
        this.label3.setName("label3");
        this.vPanel.setName("vPanel");
        this.vPanel.setLayout(new FlowLayout(0, 5, 0));
        this.label5.setText("\u533b\u7642\u6a5f\u95a2ID:  JPN\"");
        this.label5.setName("label5");
        this.jmariField.setColumns(10);
        this.jmariField.setToolTipText("\u533b\u7642\u6a5f\u95a2\u30b3\u30fc\u30c9\u306e\u6570\u5b57\u90e8\u5206\u306e\u307f12\u6841\u3092\u5165\u529b\u3057\u3066\u304f\u3060\u3055\u3044\u3002");
        this.jmariField.setName("jmariField");
        this.label6.setText("IP\u30a2\u30c9\u30ec\u30b9:");
        this.label6.setName("label6");
        this.claimAddressField.setColumns(10);
        this.claimAddressField.setName("claimAddressField");
        this.label7.setText("\u30dd\u30fc\u30c8\u756a\u53f7:");
        this.label7.setName("label7");
        this.claimPortField.setColumns(5);
        this.claimPortField.setName("claimPortField");
        this.bg2.add(this.v34);
        this.v34.setText("3.4");
        this.v34.setName("v34");
        this.v34.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ClaimSettingPanel.this.v34ActionPerformed(evt);
            }
        });
        this.bg2.add(this.v40);
        this.v40.setText("4.0\u4ee5\u964d");
        this.v40.setName("v40");
        this.v40.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ClaimSettingPanel.this.v40ActionPerformed(evt);
            }
        });
        GroupLayout portLayout = new GroupLayout(this.port);
        this.port.setLayout(portLayout);
        portLayout.setHorizontalGroup(portLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(portLayout.createSequentialGroup().addGap(47, 47, 47).addGroup(portLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(portLayout.createSequentialGroup().addGroup(portLayout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(this.label2).addComponent(this.label3)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(portLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(portLayout.createSequentialGroup().addComponent(this.v34).addGap(5, 5, 5).addComponent(this.v40).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.vPanel, -2, -1, -2)).addComponent(this.claimHostCombo, -2, 126, -2))).addGroup(portLayout.createSequentialGroup().addComponent(this.label5).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jmariField, -2, -1, -2)).addGroup(portLayout.createSequentialGroup().addGroup(portLayout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(this.label7).addComponent(this.label6)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(portLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.claimPortField, -2, 72, -2).addComponent(this.claimAddressField, -2, -1, -2)))).addContainerGap(128, Short.MAX_VALUE)));
        portLayout.setVerticalGroup(portLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(portLayout.createSequentialGroup().addGroup(portLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.claimHostCombo, -2, -1, -2).addComponent(this.label2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(portLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.vPanel, -2, -1, -2).addComponent(this.label3).addComponent(this.v34).addComponent(this.v40)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(portLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.label5).addComponent(this.jmariField, -2, -1, -2)).addGap(10, 10, 10).addGroup(portLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.label6).addComponent(this.claimAddressField, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(portLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.label7).addComponent(this.claimPortField, -2, -1, -2)).addContainerGap(-1, Short.MAX_VALUE)));
        this.pvt.setBorder(BorderFactory.createTitledBorder("\u53d7\u4ed8\u60c5\u5831\u306e\u53d7\u4fe1"));
        this.pvt.setName("pvt");
        this.pvt.setLayout(new BorderLayout());
        this.useAsPVTServer.setText("\u3053\u306e\u30de\u30b7\u30f3\u3067ORCA\u304b\u3089\u306e\u53d7\u4ed8\u60c5\u5831\u3092\u53d7\u4fe1\u3059\u308b");
        this.useAsPVTServer.setToolTipText("\u3053\u306e\u30de\u30b7\u30f3\u3067ORCA\u304b\u3089\u306e\u53d7\u4ed8\u60c5\u5831\u3092\u53d7\u4fe1\u3059\u308b\u5834\u5408\u306f\u30c1\u30a7\u30c3\u30af\u3057\u3066\u304f\u3060\u3055\u3044");
        this.useAsPVTServer.setName("useAsPVTServer");
        this.pvt.add((Component)this.useAsPVTServer, "Center");
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.sendClaim, -1, 408, Short.MAX_VALUE).addComponent(this.port, -1, -1, Short.MAX_VALUE).addGroup(layout.createSequentialGroup().addComponent(this.pvt, -1, 396, Short.MAX_VALUE).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.sendClaim, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.port, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.pvt, -2, -1, -2)));
    }

    private void sendClaimYesActionPerformed(ActionEvent evt) {
        this.stateMgr.controlClaim();
    }

    private void sendClaimNoActionPerformed(ActionEvent evt) {
        this.stateMgr.controlClaim();
    }

    private void v34ActionPerformed(ActionEvent evt) {
        this.stateMgr.controlVersion();
    }

    private void v40ActionPerformed(ActionEvent evt) {
        this.stateMgr.controlVersion();
    }

    @Override
    public void start() {
        this.model = new ClaimModel();
        this.model.populate();
        this.initCustomComponents();
        this.connect();
        this.bindModelToView();
    }

    @Override
    public void save() {
        this.bindViewToModel();
        this.model.restore();
    }

    private void initCustomComponents() {
        if (GlobalSettings.isTrial()) {
            this.jmariField.setEditable(false);
            this.jmariField.setVisible(false);
            this.label5.setText("\u533b\u7642\u6a5f\u95a2ID:  JPN:\u7de8\u96c6\u4e0d\u53ef");
        }
        if (GlobalSettings.isTrial()) {
            this.claimAddressField.setEditable(false);
            this.claimAddressField.setVisible(false);
            this.claimAddressField.setText("dolphin.good-day.co.jp");
            this.label6.setText("IP\u30a2\u30c9\u30ec\u30b9:\u7de8\u96c6\u4e0d\u53ef");
        }
        if (GlobalSettings.isTrial()) {
            this.claimPortField.setEditable(false);
            this.claimPortField.setVisible(false);
            this.label7.setText("\u30dd\u30fc\u30c8\u756a\u53f7:\u7de8\u96c6\u4e0d\u53ef");
        }
    }

    private void connect() {
        this.stateMgr = new StateMgr();
        DocumentListener dl = new DocumentListener(){

            @Override
            public void insertUpdate(DocumentEvent e) {
                ClaimSettingPanel.this.stateMgr.checkState();
            }

            @Override
            public void removeUpdate(DocumentEvent e) {
                ClaimSettingPanel.this.stateMgr.checkState();
            }

            @Override
            public void changedUpdate(DocumentEvent e) {
                ClaimSettingPanel.this.stateMgr.checkState();
            }
        };
        String jmariPattern = "[0-9]*";
        RegexConstrainedDocument jmariDoc = new RegexConstrainedDocument(jmariPattern);
        this.jmariField.setDocument(jmariDoc);
        this.jmariField.getDocument().addDocumentListener(dl);
        this.jmariField.addFocusListener(AutoRomanListener.getInstance());
        String portPattern = "[0-9]*";
        RegexConstrainedDocument portDoc = new RegexConstrainedDocument(portPattern);
        this.claimPortField.setDocument(portDoc);
        this.claimPortField.getDocument().addDocumentListener(dl);
        this.claimPortField.addFocusListener(AutoRomanListener.getInstance());
        String ipPattern = "[A-Za-z0-9.]*";
        RegexConstrainedDocument ipDoc = new RegexConstrainedDocument(ipPattern);
        this.claimAddressField.setDocument(ipDoc);
        this.claimAddressField.getDocument().addDocumentListener(dl);
        this.claimAddressField.addFocusListener(AutoRomanListener.getInstance());
    }

    private void bindModelToView() {
        String val;
        boolean sending = this.model.isSendClaim();
        this.sendClaimYes.setSelected(sending);
        this.sendClaimNo.setSelected(!sending);
        this.claimPortField.setEnabled(sending);
        String ver = this.model.getVersion();
        if (ver.startsWith("4")) {
            this.v40.setSelected(true);
        } else {
            this.v34.setSelected(true);
        }
        String jmari = this.model.getJmariCode();
        String string = jmari = jmari != null ? jmari : "";
        if (!jmari.equals("") && jmari.startsWith("JPN")) {
            jmari = jmari.substring(3);
            this.jmariField.setText(jmari);
        }
        val = (val = this.model.getClaimAddress()) != null ? val : "";
        this.claimAddressField.setText(val);
        val = String.valueOf(this.model.getClaimPort());
        val = val != null ? val : "";
        this.claimPortField.setText(val);
        val = this.model.getClaimHostName();
        val = val != null ? val : "";
        this.claimHostCombo.setSelectedItem(val);
        this.useAsPVTServer.setSelected(this.model.isUseAsPVTServer());
    }

    private void bindViewToModel() {
        if (this.v40.isSelected()) {
            this.model.setVersion("40");
        } else {
            this.model.setVersion("34");
        }
        String jmari = this.jmariField.getText().trim();
        if (!jmari.equals("")) {
            this.model.setJmariCode("JPN" + jmari);
        } else {
            this.model.setJmariCode(null);
        }
        String val = (String)this.claimHostCombo.getSelectedItem();
        this.model.setClaimHostName(val);
        val = this.claimAddressField.getText().trim();
        this.model.setClaimAddress(val);
        val = this.claimPortField.getText().trim();
        try {
            int _port = Integer.parseInt(val);
            this.model.setClaimPort(_port);
        }
        catch (NumberFormatException e) {
            this.model.setClaimPort(5001);
        }
        this.model.setUseAsPVTServer(this.useAsPVTServer.isSelected());
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public void setId(String id) {
        this.id = id;
    }

    @Override
    public String getTitle() {
        return this.title;
    }

    @Override
    public void setTitle(String title) {
        this.title = title;
    }

    @Override
    public String getIcon() {
        return this.icon;
    }

    @Override
    public void setIcon(String icon) {
        this.icon = icon;
    }

    @Override
    public ProjectSettingDialog getContext() {
        return this.context;
    }

    @Override
    public void setContext(ProjectSettingDialog context) {
        this.context = context;
        this.addPropertyChangeListener("stateProp", context);
        this.setLogInState(context.getLoginState());
    }

    @Override
    public boolean isLoginState() {
        return this.loginState;
    }

    @Override
    public void setLogInState(boolean login) {
        this.loginState = login;
    }

    @Override
    public JPanel getPanel() {
        return this;
    }

    @Override
    public void addPropertyChangeListener(String prop, PropertyChangeListener l) {
        this.boundSupport.addPropertyChangeListener(prop, l);
    }

    @Override
    public void removePropertyChangeListener(String prop, PropertyChangeListener l) {
        this.boundSupport.removePropertyChangeListener(prop, l);
    }

    @Override
    public void setState(IAbstractSettingPanel.State state) {
        this.state = state;
        this.boundSupport.firePropertyChange("stateProp", null, (Object)this.state);
    }

    @Override
    public IAbstractSettingPanel.State getState() {
        return this.state;
    }

    class StateMgr {
        StateMgr() {
        }

        private void checkState() {
            IAbstractSettingPanel.State newState;
            IAbstractSettingPanel.State state = newState = this.isValid() ? IAbstractSettingPanel.State.VALID_STATE : IAbstractSettingPanel.State.INVALID_STATE;
            if (newState != ClaimSettingPanel.this.state) {
                ClaimSettingPanel.this.setState(newState);
            }
        }

        private void controlClaim() {
            boolean b = ClaimSettingPanel.this.sendClaimYes.isSelected();
            ClaimSettingPanel.this.claimPortField.setEnabled(b);
            this.checkState();
        }

        private void controlVersion() {
            boolean b = ClaimSettingPanel.this.v40.isSelected();
            ClaimSettingPanel.this.jmariField.setEnabled(b);
            this.checkState();
        }

        private boolean isValid() {
            boolean jmariOk = false;
            boolean claimAddrOk = false;
            boolean claimPortOk = false;
            if (ClaimSettingPanel.this.v40.isSelected()) {
                String code = ClaimSettingPanel.this.jmariField.getText().trim();
                if (!code.equals("") && code.length() == 12) {
                    jmariOk = true;
                }
            } else {
                jmariOk = true;
            }
            if (ClaimSettingPanel.this.sendClaimYes.isSelected()) {
                claimAddrOk = !ClaimSettingPanel.this.claimAddressField.getText().trim().equals("");
                claimPortOk = !ClaimSettingPanel.this.claimPortField.getText().trim().equals("");
            } else {
                claimAddrOk = true;
                claimPortOk = true;
            }
            return jmariOk && claimAddrOk && claimPortOk;
        }
    }

    class ClaimModel {
        private boolean sendClaim;
        private String claimHostName;
        private String version;
        private String jmariCode;
        private String claimAddress;
        private int claimPort;
        private boolean useAsPvtServer;

        ClaimModel() {
        }

        protected void populate() {
            this.setSendClaim(GlobalVariables.getSendClaim());
            this.setSendClaim(true);
            this.setVersion(GlobalVariables.getOrcaVersion());
            this.setJmariCode(GlobalVariables.getJMARICode());
            this.setClaimAddress(GlobalVariables.getClaimAddress());
            this.setClaimPort(GlobalVariables.getClaimPort());
            this.setClaimHostName(GlobalVariables.getClaimHostName());
            this.setUseAsPVTServer(GlobalVariables.getUseAsPVTServer());
        }

        private void restore() {
            GlobalVariables.setSendClaim(this.isSendClaim());
            GlobalVariables.setSendClaim(true);
            GlobalVariables.setOrcaVersion(this.getVersion());
            GlobalVariables.setJMARICode(this.getJmariCode());
            GlobalVariables.setClaimAddress(this.getClaimAddress());
            GlobalVariables.setClaimPort(this.getClaimPort());
            GlobalVariables.setClaimHostName(this.getClaimHostName());
            GlobalVariables.setUseAsPVTServer(this.isUseAsPVTServer());
        }

        private boolean isSendClaim() {
            return this.sendClaim;
        }

        private void setSendClaim(boolean sendClaim) {
            this.sendClaim = sendClaim;
        }

        private boolean isUseAsPVTServer() {
            return this.useAsPvtServer;
        }

        private void setUseAsPVTServer(boolean useAsPvtServer) {
            this.useAsPvtServer = useAsPvtServer;
        }

        private String getClaimHostName() {
            return this.claimHostName;
        }

        private void setClaimHostName(String claimHostName) {
            this.claimHostName = claimHostName;
        }

        private String getClaimAddress() {
            return this.claimAddress;
        }

        private void setClaimAddress(String claimAddress) {
            this.claimAddress = claimAddress;
        }

        private int getClaimPort() {
            return this.claimPort;
        }

        private void setClaimPort(int claimPort) {
            this.claimPort = claimPort;
        }

        private String getVersion() {
            return this.version;
        }

        private void setVersion(String version) {
            this.version = version;
        }

        private String getJmariCode() {
            return this.jmariCode;
        }

        private void setJmariCode(String jmariCode) {
            this.jmariCode = jmariCode;
        }
    }
}

