/*
 * Decompiled with CFR 0.152.
 */
package open.dolphin.delegater;

import java.util.List;
import javax.naming.NamingException;
import javax.security.auth.login.LoginException;
import open.dolphin.delegater.BusinessDelegater;
import open.dolphin.infomodel.UserModel;
import open.dolphin.project.DolphinPrincipal;
import open.dolphin.service.IUserService;

public abstract class UserDelegater
extends BusinessDelegater {
    protected abstract IUserService getService() throws NamingException;

    public List<UserModel> getAllUser() {
        try {
            return this.getService().getAllUser();
        }
        catch (Exception ex) {
            this.processError(ex);
            return null;
        }
    }

    public UserModel getUser(String pk) {
        try {
            return this.getService().getUser(pk);
        }
        catch (NamingException ex) {
            this.processError(ex);
            return null;
        }
    }

    public abstract UserModel login(DolphinPrincipal var1, String var2) throws LoginException;

    public int putUser(UserModel userModel) {
        try {
            return this.getService().addUser(userModel);
        }
        catch (Exception ex) {
            this.processError(ex);
            return 0;
        }
    }

    public int removeUser(String uid) {
        try {
            return this.getService().removeUser(uid);
        }
        catch (Exception ex) {
            this.processError(ex);
            return 0;
        }
    }

    public int updateFacility(UserModel user) {
        try {
            return this.getService().updateFacility(user);
        }
        catch (NamingException ex) {
            this.processError(ex);
            return 0;
        }
    }

    public int updateUser(UserModel userModel) {
        try {
            return this.getService().updateUser(userModel);
        }
        catch (NamingException ex) {
            this.processError(ex);
            return 0;
        }
    }
}

