/*
 * Decompiled with CFR 0.152.
 */
package open.dolphin.helper;

import java.util.Iterator;
import java.util.LinkedList;
import javax.swing.Action;
import javax.swing.ActionMap;
import open.dolphin.client.IChartCommandAccepter;

public class ChartMenuSupport {
    private ActionMap actions;
    private LinkedList<IChartCommandAccepter> chains = new LinkedList();

    public ChartMenuSupport(IChartCommandAccepter owner) {
        this.chains.add(owner);
    }

    public void registerActions(ActionMap actions) {
        this.actions = actions;
    }

    public Action getAction(String name) {
        if (this.actions != null) {
            return this.actions.get(name);
        }
        return null;
    }

    public ActionMap getActions() {
        return this.actions;
    }

    public void disableAllMenus() {
        if (this.actions != null) {
            Object[] keys;
            for (Object o : keys = this.actions.keys()) {
                this.actions.get(o).setEnabled(false);
            }
        }
    }

    public void disableMenus(String[] menus) {
        if (this.actions != null && menus != null) {
            for (String name : menus) {
                Action action = this.actions.get(name);
                if (action == null) continue;
                action.setEnabled(false);
            }
        }
    }

    public void enableMenus(String[] menus) {
        if (this.actions != null && menus != null) {
            for (String name : menus) {
                Action action = this.actions.get(name);
                if (action == null) continue;
                action.setEnabled(true);
            }
        }
    }

    public void enabledAction(String name, boolean enabled) {
        Action action;
        if (this.actions != null && (action = this.actions.get(name)) != null) {
            action.setEnabled(enabled);
        }
    }

    public void setAccepter(IChartCommandAccepter obj) {
        if (this.chains.contains(obj)) {
            this.unsetAccepter(obj);
        }
        this.chains.add(obj);
    }

    public boolean unsetAccepter(IChartCommandAccepter obj) {
        return this.chains.remove(obj);
    }

    public Object getLast() {
        return this.chains.getLast();
    }

    public int chainSize() {
        return this.chains.size();
    }

    private boolean execute(IChartCommandAccepter.ChartCommand command) {
        Iterator<IChartCommandAccepter> it = this.chains.descendingIterator();
        while (it.hasNext()) {
            if (!it.next().dispatchChartCommand(command)) continue;
            return true;
        }
        return false;
    }

    public boolean newKarteCommandExecute() {
        return this.execute(IChartCommandAccepter.ChartCommand.newKarte);
    }

    public boolean newDocumentCommandExecute() {
        return this.execute(IChartCommandAccepter.ChartCommand.newDocument);
    }

    public boolean closeCommandExecute() {
        return this.execute(IChartCommandAccepter.ChartCommand.close);
    }

    public boolean saveCommandExecute() {
        return this.execute(IChartCommandAccepter.ChartCommand.save);
    }

    public boolean deleteCommandExecute() {
        return this.execute(IChartCommandAccepter.ChartCommand.delete);
    }

    public boolean directionCommandExecute() {
        return this.execute(IChartCommandAccepter.ChartCommand.direction);
    }

    public boolean printCommandExecute() {
        return this.execute(IChartCommandAccepter.ChartCommand.print);
    }

    public boolean modifyKarteCommandExecute() {
        return this.execute(IChartCommandAccepter.ChartCommand.modifyKarte);
    }

    public boolean undoCommandExecute() {
        return this.execute(IChartCommandAccepter.ChartCommand.undo);
    }

    public boolean redoCommandExecute() {
        return this.execute(IChartCommandAccepter.ChartCommand.redo);
    }

    public boolean letterPasteCommandExecute() {
        return this.execute(IChartCommandAccepter.ChartCommand.letterPaste);
    }

    public boolean quickEditExcecute() {
        return this.execute(IChartCommandAccepter.ChartCommand.quickEdit);
    }

    public boolean showModifiedCommandExecute() {
        return this.execute(IChartCommandAccepter.ChartCommand.showModified);
    }

    public boolean hideModifiedCommandExecute() {
        return this.execute(IChartCommandAccepter.ChartCommand.hideModified);
    }

    public boolean showUnsendCommandExecute() {
        return this.execute(IChartCommandAccepter.ChartCommand.showUnsend);
    }

    public boolean hideUnsendCommandExecute() {
        return this.execute(IChartCommandAccepter.ChartCommand.hideUnsend);
    }

    public boolean showSendCommandExecute() {
        return this.execute(IChartCommandAccepter.ChartCommand.showSend);
    }

    public boolean hideSendCommandExecute() {
        return this.execute(IChartCommandAccepter.ChartCommand.hideSend);
    }

    public boolean showNewestCommandExecute() {
        return this.execute(IChartCommandAccepter.ChartCommand.showNewest);
    }

    public boolean hideNewestCommandExecute() {
        return this.execute(IChartCommandAccepter.ChartCommand.hideNewest);
    }

    public boolean ascendingCommandExecute() {
        return this.execute(IChartCommandAccepter.ChartCommand.ascending);
    }

    public boolean descendingCommandExecute() {
        return this.execute(IChartCommandAccepter.ChartCommand.descending);
    }

    public boolean fontLargerCommandExecute() {
        return this.execute(IChartCommandAccepter.ChartCommand.fontLarger);
    }

    public boolean fontSmallerCommandExecute() {
        return this.execute(IChartCommandAccepter.ChartCommand.fontSmaller);
    }

    public boolean fontStandardCommandExecute() {
        return this.execute(IChartCommandAccepter.ChartCommand.fontStandard);
    }

    public boolean fontBoldCommandExecute() {
        return this.execute(IChartCommandAccepter.ChartCommand.fontBold);
    }

    public boolean fontItalicCommandExecute() {
        return this.execute(IChartCommandAccepter.ChartCommand.fontItalic);
    }

    public boolean fontUnderlineCommandExecute() {
        return this.execute(IChartCommandAccepter.ChartCommand.fontUnderline);
    }

    public boolean leftJustifyCommandExecute() {
        return this.execute(IChartCommandAccepter.ChartCommand.leftJustify);
    }

    public boolean centerJustifyCommandExecute() {
        return this.execute(IChartCommandAccepter.ChartCommand.centerJustify);
    }

    public boolean rightJustifyCommandExecute() {
        return this.execute(IChartCommandAccepter.ChartCommand.rightJustify);
    }

    public boolean fontRedCommandExecute() {
        return this.execute(IChartCommandAccepter.ChartCommand.fontRed);
    }

    public boolean fontOrangeCommandExecute() {
        return this.execute(IChartCommandAccepter.ChartCommand.fontOrange);
    }

    public boolean fontYellowCommandExecute() {
        return this.execute(IChartCommandAccepter.ChartCommand.fontYellow);
    }

    public boolean fontGreenCommandExecute() {
        return this.execute(IChartCommandAccepter.ChartCommand.fontGreen);
    }

    public boolean fontBlueCommandExecute() {
        return this.execute(IChartCommandAccepter.ChartCommand.fontBlue);
    }

    public boolean fontPurpleCommandExecute() {
        return this.execute(IChartCommandAccepter.ChartCommand.fontPurple);
    }

    public boolean fontGrayCommandExecute() {
        return this.execute(IChartCommandAccepter.ChartCommand.fontGray);
    }

    public boolean fontBlackCommandExecute() {
        return this.execute(IChartCommandAccepter.ChartCommand.fontBlack);
    }

    public boolean resetStyleCommandExecute() {
        return this.execute(IChartCommandAccepter.ChartCommand.resetStyle);
    }

    public void cut() {
    }

    public void copy() {
    }

    public void paste() {
    }
}

