/*
 * Decompiled with CFR 0.152.
 */
package open.dolphin.helper.FixedLengthFormat;

import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import open.dolphin.helper.FixedLengthFormat.IFormat;
import open.dolphin.helper.FixedLengthFormat.Param;
import open.dolphin.log.LogWriter;

public class Loader {
    protected InputStream inStream;
    protected String encoding;
    protected IFormat format;
    protected int length;

    public Loader(InputStream in, String encoding, IFormat format, int length) {
        this.inStream = in;
        this.encoding = encoding;
        this.format = format;
        this.length = length;
    }

    public List<IFormat> parse() {
        ArrayList<IFormat> ret = new ArrayList<IFormat>();
        try {
            while (true) {
                byte[] line = this.read(this.length);
                IFormat t = (IFormat)this.format.getClass().newInstance();
                List<Param> params = this.format.getParam();
                Iterator<Param> it = params.iterator();
                int pos = 0;
                while (it.hasNext()) {
                    Param param = it.next();
                    int size = param.getSize();
                    byte[] bytes = new byte[size];
                    for (int i = 0; i < size; ++i) {
                        bytes[i] = line[pos + i];
                    }
                    Class[] p = new Class[]{byte[].class, String.class};
                    Method method = this.format.getClass().getMethod(param.getMethod(), p);
                    Object[] objs = new Object[]{bytes, this.encoding};
                    method.invoke((Object)t, objs);
                    pos += size;
                }
                ret.add(t);
            }
        }
        catch (EOFException e) {
        }
        catch (Exception e) {
            LogWriter.error(this.getClass(), e);
        }
        return ret;
    }

    public byte[] read(int length) throws IOException {
        byte[] buf = new byte[length];
        if (this.inStream.read(buf) < length) {
            throw new EOFException();
        }
        return buf;
    }

    public void close() throws IOException {
        this.inStream.close();
    }
}

