/*
 * Decompiled with CFR 0.152.
 */
package open.dolphin.infomodel;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.persistence.Embedded;
import javax.persistence.Transient;
import open.dolphin.infomodel.AddressModel;
import open.dolphin.infomodel.HealthInsuranceModel;
import open.dolphin.infomodel.IPatientModel;
import open.dolphin.infomodel.InfoModel;
import open.dolphin.infomodel.ModelUtils;
import open.dolphin.infomodel.PVTHealthInsuranceModel;
import open.dolphin.infomodel.PatientLiteModel;
import open.dolphin.infomodel.SimpleAddressModel;
import open.dolphin.infomodel.TelephoneModel;
import open.dolphin.queries.DolphinQuery;
import org.apache.commons.lang.builder.ToStringBuilder;

public class PatientModel
extends InfoModel
implements IPatientModel {
    private long id;
    private String facilityId;
    private String patientId;
    private String familyName;
    private String givenName;
    private String fullName;
    private String kanaFamilyName;
    private String kanaGivenName;
    private String kanaName;
    private String romanFamilyName;
    private String romanGivenName;
    private String romanName;
    private String gender;
    private String genderDesc;
    @Transient
    private String genderCodeSys;
    private String birthday;
    private String nationality;
    @Transient
    private String nationalityDesc;
    @Transient
    private String nationalityCodeSys;
    private String maritalStatus;
    @Transient
    private String maritalStatusDesc;
    @Transient
    private String maritalStatusCodeSys;
    private byte[] jpegPhoto;
    private String memo;
    @Embedded
    private SimpleAddressModel address;
    private String telephone;
    private String mobilePhone;
    private String email;
    private Set<HealthInsuranceModel> healthInsurances;
    @Transient
    private List<PVTHealthInsuranceModel> pvtHealthInsurances;
    @Transient
    private List<AddressModel> addresses;
    @Transient
    private List<TelephoneModel> telephones;

    @Override
    public boolean search(DolphinQuery query) {
        return false;
    }

    public long getId() {
        return this.id;
    }

    public void setId(long id) {
        this.id = id;
    }

    public String getFacilityId() {
        return this.facilityId;
    }

    public void setFacilityId(String facilityId) {
        this.facilityId = facilityId;
    }

    @Override
    public void setPatientId(String patientId) {
        this.patientId = patientId;
    }

    @Override
    public String getPatientId() {
        return this.patientId;
    }

    public void setFamilyName(String sirName) {
        this.familyName = sirName;
    }

    public String getFamilyName() {
        return this.familyName;
    }

    public void setGivenName(String givenName) {
        this.givenName = givenName;
    }

    public String getGivenName() {
        return this.givenName;
    }

    @Override
    public void setFullName(String name) {
        this.fullName = name;
    }

    @Override
    public String getFullName() {
        return this.fullName;
    }

    public void setKanaFamilyName(String kanaSirName) {
        this.kanaFamilyName = kanaSirName;
    }

    public String getKanaFamilyName() {
        return this.kanaFamilyName;
    }

    public void setKanaGivenName(String kanaGivenName) {
        this.kanaGivenName = kanaGivenName;
    }

    public String getKanaGivenName() {
        return this.kanaGivenName;
    }

    public void setKanaName(String kanaName) {
        this.kanaName = kanaName;
    }

    public String getKanaName() {
        return this.kanaName;
    }

    public void setRomanFamilyName(String romanSirName) {
        this.romanFamilyName = romanSirName;
    }

    public String getRomanFamilyName() {
        return this.romanFamilyName;
    }

    public void setRomanGivenName(String romanGivenName) {
        this.romanGivenName = romanGivenName;
    }

    public String getRomanGivenName() {
        return this.romanGivenName;
    }

    public void setRomanName(String romanName) {
        this.romanName = romanName;
    }

    public String getRomanName() {
        return this.romanName;
    }

    @Override
    public void setGender(String gender) {
        this.gender = gender;
    }

    @Override
    public String getGender() {
        return this.gender;
    }

    @Override
    public void setGenderDesc(String genderDesc) {
        this.genderDesc = genderDesc;
    }

    @Override
    public String getGenderDesc() {
        return this.genderDesc != null ? this.genderDesc : ModelUtils.getGenderDesc(this.gender);
    }

    @Override
    public void setGenderCodeSys(String genderCodeSys) {
        this.genderCodeSys = genderCodeSys;
    }

    @Override
    public String getGenderCodeSys() {
        return this.genderCodeSys;
    }

    @Override
    public void setBirthday(String birthday) {
        this.birthday = birthday;
    }

    @Override
    public String getBirthday() {
        return this.birthday;
    }

    public String getAgeBirthday() {
        return ModelUtils.getAgeBirthday(this.birthday);
    }

    public void setNationality(String nationality) {
        this.nationality = nationality;
    }

    public String getNationality() {
        return this.nationality;
    }

    public void setNationalityDesc(String nationalityDesc) {
        this.nationalityDesc = nationalityDesc;
    }

    public String getNationalityDesc() {
        return this.nationalityDesc;
    }

    public void setNationalityCodeSys(String nationalityCodeSys) {
        this.nationalityCodeSys = nationalityCodeSys;
    }

    public String getNationalityCodeSys() {
        return this.nationalityCodeSys;
    }

    public void setMaritalStatus(String maritalStatus) {
        this.maritalStatus = maritalStatus;
    }

    public String getMaritalStatus() {
        return this.maritalStatus;
    }

    public void setMaritalStatusDesc(String maritalStatusDesc) {
        this.maritalStatusDesc = maritalStatusDesc;
    }

    public String getMaritalStatusDesc() {
        return this.maritalStatusDesc;
    }

    public void setMaritalStatusCodeSys(String maritalStatusCodeSys) {
        this.maritalStatusCodeSys = maritalStatusCodeSys;
    }

    public String getMaritalStatusCodeSys() {
        return this.maritalStatusCodeSys;
    }

    public void setJpegPhoto(byte[] jpegPhoto) {
        this.jpegPhoto = jpegPhoto;
    }

    public byte[] getJpegPhoto() {
        return this.jpegPhoto;
    }

    public void setMemo(String memo) {
        this.memo = memo;
    }

    public String getMemo() {
        return this.memo;
    }

    public SimpleAddressModel getAddress() {
        return this.address;
    }

    public void setAddress(SimpleAddressModel address) {
        this.address = address;
    }

    public String contactZipCode() {
        return this.address != null ? this.address.getZipCode() : null;
    }

    public String contactAddress() {
        return this.address != null ? this.address.getAddress() : null;
    }

    public String getTelephone() {
        return this.telephone;
    }

    public void setTelephone(String telephone) {
        this.telephone = telephone;
    }

    public String getMobilePhone() {
        return this.mobilePhone;
    }

    public void setMobilePhone(String mobilePhone) {
        this.mobilePhone = mobilePhone;
    }

    public String getEmail() {
        return this.email;
    }

    public void setEmail(String email) {
        this.email = email;
    }

    public void setHealthInsurances(Set<HealthInsuranceModel> healthInsurances) {
        this.healthInsurances = healthInsurances;
    }

    public Set<HealthInsuranceModel> getHealthInsurances() {
        return this.healthInsurances;
    }

    public void addHealthInsurance(HealthInsuranceModel value) {
        if (this.healthInsurances == null) {
            this.healthInsurances = new HashSet<HealthInsuranceModel>();
        }
        this.healthInsurances.add(value);
    }

    public List<PVTHealthInsuranceModel> getPvtHealthInsurances() {
        return this.pvtHealthInsurances;
    }

    public void setPvtHealthInsurances(List<PVTHealthInsuranceModel> pvtHealthInsurances) {
        this.pvtHealthInsurances = pvtHealthInsurances;
    }

    public void addPvtHealthInsurance(PVTHealthInsuranceModel model) {
        if (this.pvtHealthInsurances == null) {
            this.pvtHealthInsurances = new ArrayList<PVTHealthInsuranceModel>(2);
        }
        this.pvtHealthInsurances.add(model);
    }

    public List<AddressModel> getAddresses() {
        return this.addresses;
    }

    public void setAddresses(List<AddressModel> addresses) {
        this.addresses = addresses;
    }

    public void addAddress(AddressModel address) {
        if (this.addresses == null) {
            this.addresses = new ArrayList<AddressModel>(1);
        }
        this.addresses.add(address);
    }

    public List<TelephoneModel> getTelephones() {
        return this.telephones;
    }

    public void setTelephones(List<TelephoneModel> telephones) {
        this.telephones = telephones;
    }

    public void addTelephone(TelephoneModel telephone) {
        if (this.telephones == null) {
            this.telephones = new ArrayList<TelephoneModel>(1);
        }
        this.telephones.add(telephone);
    }

    public PatientLiteModel patientAsLiteModel() {
        PatientLiteModel model = new PatientLiteModel();
        model.setPatientId(this.getPatientId());
        model.setFullName(this.getFullName());
        model.setGender(this.getGender());
        model.setGenderDesc(this.getGenderDesc());
        model.setGenderCodeSys(this.getGenderCodeSys());
        model.setBirthday(this.getBirthday());
        return model;
    }

    public String toString() {
        return ToStringBuilder.reflectionToString((Object)this);
    }

    public int hashCode() {
        int PRIME = 31;
        int result = 1;
        result = 31 * result + (int)(this.id ^ this.id >>> 32);
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        PatientModel other = (PatientModel)obj;
        return this.getId() == other.getId();
    }
}

