/*
 * Decompiled with CFR 0.152.
 */
package open.dolphin.order;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.DefaultCellEditor;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.ListSelectionModel;
import javax.swing.TransferHandler;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableColumn;
import open.dolphin.client.AutoKanjiListener;
import open.dolphin.client.AutoRomanListener;
import open.dolphin.client.SymptomsDialog;
import open.dolphin.client.editor.stamp.StampModelEditor;
import open.dolphin.container.Pair;
import open.dolphin.dao.SqlDaoFactory;
import open.dolphin.dao.SqlMasterDao;
import open.dolphin.helper.IntegerDocument;
import open.dolphin.helper.NumericDocument;
import open.dolphin.infomodel.BundleMed;
import open.dolphin.infomodel.ClaimItem;
import open.dolphin.infomodel.InteractEntry;
import open.dolphin.infomodel.MasterItem;
import open.dolphin.infomodel.MedicineEntry;
import open.dolphin.infomodel.ModuleInfoBean;
import open.dolphin.infomodel.ModuleModel;
import open.dolphin.infomodel.SinryoCode;
import open.dolphin.infomodel.SsKijyoEntry;
import open.dolphin.order.CommentHelper;
import open.dolphin.order.MMLTable;
import open.dolphin.order.MasterItemTransferHandler;
import open.dolphin.order.MedTableStateMgr;
import open.dolphin.project.GlobalSettings;
import open.dolphin.project.GlobalVariables;
import open.dolphin.table.ObjectReflectTableModel;
import open.dolphin.table.OddEvenRowRendererWithExpire;

public class PharmaceuticalsTablePanel
extends JPanel
implements PropertyChangeListener {
    private static final long serialVersionUID = 8361225970230987080L;
    protected static final String DEFAULT_STAMP_NAME = "\u65b0\u898f\u30b9\u30bf\u30f3\u30d7";
    private static final String FROM_EDITOR_STAMP_NAME = "\u30a8\u30c7\u30a3\u30bf\u304b\u3089";
    private static final String[] COLUMN_NAMES = new String[]{"\u30b3\u30fc\u30c9", "\u8a3a\u7642\u5185\u5bb9", "\u6570\u91cf", "\u5358\u4f4d", " ", "\u56de\u6570"};
    private static final String[] METHOD_NAMES = new String[]{"getCode", "getName", "getNumber", "getUnit", "getDummy", "getBundleNumber"};
    private static final int[] COLUMN_WIDTH = new int[]{50, 210, 20, 20, 10, 20};
    private static final String IN_MEDICINE = "\u9662\u5185\u51e6\u65b9";
    private static final String EXT_MEDICINE = "\u9662\u5916\u51e6\u65b9";
    private static final String ADMIN_MARK = "[\u7528\u6cd5] ";
    private static final String REG_ADMIN_MARK = "\\[\u7528\u6cd5\\] ";
    private static final int ROWS = 0;
    private static final int ONEDAY_COLUMN = 2;
    private static final int BUNDLE_COLUMN = 5;
    private ObjectReflectTableModel<MasterItem> PharmaceuticalsTableModel;
    private StampModelEditor parent;
    private boolean validModel;
    private MedTableStateMgr stateMgr;
    private String entity;
    private String saveReceiptCode;
    private String defaultNumber = "1";
    private ButtonGroup buttonGroup;
    private JPanel buttonPanel;
    private JButton clearButton;
    private JPanel controlPanel;
    private JTextField countEditor;
    private JButton editButton;
    private JRadioButton extMed;
    private JCheckBox forceInExtFlag;
    private JRadioButton inMed;
    private JPanel infoPanel;
    private JLabel jLabel1;
    private JTable medTable;
    private JButton removeButton;
    private JScrollPane scroller;
    private JTextField stampNameField;
    private JLabel stateLabel;
    private JTextField volumeEditor;

    public PharmaceuticalsTablePanel() {
        this.initComponents();
    }

    private void initComponents() {
        this.volumeEditor = new JTextField();
        this.countEditor = new JTextField();
        this.stateLabel = new JLabel();
        this.buttonGroup = new ButtonGroup();
        this.scroller = new JScrollPane();
        this.medTable = new JTable();
        this.controlPanel = new JPanel();
        this.infoPanel = new JPanel();
        this.jLabel1 = new JLabel();
        this.stampNameField = new JTextField();
        this.inMed = new JRadioButton();
        this.extMed = new JRadioButton();
        this.forceInExtFlag = new JCheckBox();
        this.buttonPanel = new JPanel();
        this.editButton = new JButton();
        this.removeButton = new JButton();
        this.clearButton = new JButton();
        this.volumeEditor.setName("volumeEditor");
        this.countEditor.setName("countEditor");
        this.stateLabel.setText("jLabel1");
        this.stateLabel.setName("stateLabel");
        this.setLayout(new BorderLayout());
        this.scroller.setHorizontalScrollBarPolicy(31);
        this.scroller.setName("scroller");
        this.medTable.setModel(new DefaultTableModel(new Object[][]{{null, null, null, null}, {null, null, null, null}, {null, null, null, null}, {null, null, null, null}}, new String[]{"Title 1", "Title 2", "Title 3", "Title 4"}));
        this.medTable.setToolTipText("\u30c9\u30e9\u30c3\u30b0 & \u30c9\u30ed\u30c3\u30d7\u3067\u9806\u756a\u3092\u5165\u308c\u66ff\u3048\u308b\u3053\u3068\u304c\u3067\u304d\u307e\u3059\u3002");
        this.medTable.setName("medTable");
        this.medTable.setSelectionMode(0);
        this.medTable.addMouseMotionListener(new MouseMotionAdapter(){

            @Override
            public void mouseDragged(MouseEvent evt) {
                PharmaceuticalsTablePanel.this.medTableMouseDragged(evt);
            }
        });
        this.scroller.setViewportView(this.medTable);
        this.add((Component)this.scroller, "Center");
        this.controlPanel.setBorder(BorderFactory.createEtchedBorder());
        this.controlPanel.setName("controlPanel");
        this.controlPanel.setLayout(new BoxLayout(this.controlPanel, 0));
        this.infoPanel.setBorder(BorderFactory.createEtchedBorder());
        this.infoPanel.setName("infoPanel");
        this.infoPanel.setLayout(new FlowLayout(0));
        this.jLabel1.setText("\u30b9\u30bf\u30f3\u30d7\u540d");
        this.jLabel1.setName("jLabel1");
        this.infoPanel.add(this.jLabel1);
        this.stampNameField.setBackground(new Color(251, 239, 128));
        this.stampNameField.setName("stampNameField");
        this.infoPanel.add(this.stampNameField);
        this.inMed.setText("\u9662\u5185");
        this.inMed.setName("inMed");
        this.inMed.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PharmaceuticalsTablePanel.this.inMedActionPerformed(evt);
            }
        });
        this.infoPanel.add(this.inMed);
        this.extMed.setText("\u9662\u5916");
        this.extMed.setName("extMed");
        this.extMed.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PharmaceuticalsTablePanel.this.extMedActionPerformed(evt);
            }
        });
        this.infoPanel.add(this.extMed);
        this.forceInExtFlag.setText("\u7dca\u6025\u6642");
        this.forceInExtFlag.setName("forceInExtFlag");
        this.infoPanel.add(this.forceInExtFlag);
        this.controlPanel.add(this.infoPanel);
        this.buttonPanel.setBorder(BorderFactory.createEtchedBorder());
        this.buttonPanel.setName("buttonPanel");
        this.buttonPanel.setLayout(new FlowLayout(2));
        this.editButton.setText("\u7de8\u96c6");
        this.editButton.setToolTipText("\u30b3\u30e1\u30f3\u30c8\u30b3\u30fc\u30c9\u306e\u5834\u5408\u7de8\u96c6\u3067\u304d\u307e\u3059");
        this.editButton.setEnabled(false);
        this.editButton.setName("editButton");
        this.editButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PharmaceuticalsTablePanel.this.editButtonActionPerformed(evt);
            }
        });
        this.buttonPanel.add(this.editButton);
        this.removeButton.setIcon(new ImageIcon(this.getClass().getResource("/open/dolphin/resources/images/del_16.gif")));
        this.removeButton.setToolTipText("\u9078\u629e\u3057\u305f\u30a2\u30a4\u30c6\u30e0\u3092\u524a\u9664\u3057\u307e\u3059\u3002");
        this.removeButton.setEnabled(false);
        this.removeButton.setName("removeButton");
        this.removeButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PharmaceuticalsTablePanel.this.removeButtonActionPerformed(evt);
            }
        });
        this.buttonPanel.add(this.removeButton);
        this.clearButton.setIcon(new ImageIcon(this.getClass().getResource("/open/dolphin/resources/images/remov_16.gif")));
        this.clearButton.setToolTipText("\u30bb\u30c3\u30c8\u5185\u5bb9\u3092\u30af\u30ea\u30a2\u3057\u307e\u3059\u3002");
        this.clearButton.setEnabled(false);
        this.clearButton.setName("clearButton");
        this.clearButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PharmaceuticalsTablePanel.this.clearButtonActionPerformed(evt);
            }
        });
        this.buttonPanel.add(this.clearButton);
        this.controlPanel.add(this.buttonPanel);
        this.add((Component)this.controlPanel, "South");
    }

    private void medTableMouseDragged(MouseEvent evt) {
        int ctrlMask = 128;
        int action = (evt.getModifiersEx() & ctrlMask) == ctrlMask ? 1 : 2;
        JComponent c = (JComponent)evt.getSource();
        TransferHandler handler = c.getTransferHandler();
        handler.exportAsDrag(c, evt, action);
    }

    private void editButtonActionPerformed(ActionEvent evt) {
        this.editSelectedItem();
    }

    private void removeButtonActionPerformed(ActionEvent evt) {
        this.removeSelectedItem();
    }

    private void clearButtonActionPerformed(ActionEvent evt) {
        this.clear();
    }

    private void inMedActionPerformed(ActionEvent evt) {
        boolean b = this.extMed.isSelected();
        GlobalVariables.getPreferences().putBoolean("rp.out", b);
    }

    private void extMedActionPerformed(ActionEvent evt) {
        boolean b = this.extMed.isSelected();
        GlobalVariables.getPreferences().putBoolean("rp.out", b);
    }

    public PharmaceuticalsTablePanel(StampModelEditor parent) {
        this.setParent(parent);
        this.initComponents();
        this.InitCustomComponents();
    }

    private void InitCustomComponents() {
        this.PharmaceuticalsTableModel = new ObjectReflectTableModel<MasterItem>(COLUMN_NAMES, 0, METHOD_NAMES, null){

            @Override
            public boolean isCellEditable(int row, int col) {
                return col == 2 || col == 5;
            }

            @Override
            public void setValueAt(Object o, int row, int col) {
                if (o == null || ((String)o).trim().equals("")) {
                    o = new String("0");
                }
                MasterItem mItem = (MasterItem)this.getObject(row);
                if (col == 2 && mItem != null) {
                    mItem.setNumber((String)o);
                    PharmaceuticalsTablePanel.this.stateMgr.checkState();
                } else if (col == 5 && mItem != null) {
                    mItem.setBundleNumber((String)o);
                    PharmaceuticalsTablePanel.this.stateMgr.checkState();
                }
            }
        };
        this.medTable.setModel(this.PharmaceuticalsTableModel);
        this.medTable.setTransferHandler(new MasterItemTransferHandler());
        ListSelectionModel m = this.medTable.getSelectionModel();
        m.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                if (!e.getValueIsAdjusting()) {
                    PharmaceuticalsTablePanel.this.notifySelectedRow();
                }
            }
        });
        this.medTable.setDefaultRenderer(Object.class, new OddEvenRowRendererWithExpire());
        int ccts = GlobalVariables.getPreferences().getInt("order.table.clickCountToStart", 2);
        this.volumeEditor.addFocusListener(AutoRomanListener.getInstance());
        this.volumeEditor.setDocument(new NumericDocument());
        TableColumn column = this.medTable.getColumnModel().getColumn(2);
        DefaultCellEditor volumeCellEditor = new DefaultCellEditor(this.volumeEditor);
        volumeCellEditor.setClickCountToStart(ccts);
        column.setCellEditor(volumeCellEditor);
        this.countEditor.addFocusListener(AutoRomanListener.getInstance());
        this.countEditor.setDocument(new IntegerDocument());
        TableColumn column2 = this.medTable.getColumnModel().getColumn(5);
        DefaultCellEditor countCellEditor = new DefaultCellEditor(this.countEditor);
        countCellEditor.setClickCountToStart(ccts);
        column2.setCellEditor(countCellEditor);
        for (int i = 0; i < COLUMN_NAMES.length; ++i) {
            column = this.medTable.getColumnModel().getColumn(i);
            column.setPreferredWidth(COLUMN_WIDTH[i]);
        }
        this.stampNameField.addFocusListener(AutoKanjiListener.getInstance());
        this.buttonGroup.add(this.inMed);
        this.buttonGroup.add(this.extMed);
        if (GlobalVariables.getPreferences().getBoolean("rp.out", true)) {
            this.extMed.setSelected(true);
        } else {
            this.inMed.setSelected(true);
        }
        if (this.parent.getContext().getOkButton() != null) {
            this.buttonPanel.add(this.parent.getContext().getOkButton());
        }
        this.scroller.setViewportView(this.medTable);
        this.scroller.getViewport().setBackground(GlobalSettings.getColors(GlobalSettings.Parts.TABLE_BACKGROUND));
        this.setPreferredSize(new Dimension(680, 280));
        this.stateMgr = new MedTableStateMgr(this, this.medTable, this.removeButton, this.clearButton, this.stampNameField, this.stateLabel);
    }

    public StampModelEditor getMyParent() {
        return this.parent;
    }

    public void setParent(StampModelEditor parent) {
        this.parent = parent;
    }

    public String getEntity() {
        return this.entity;
    }

    public void setEntity(String val) {
        this.entity = val;
    }

    public boolean isValidModel() {
        return this.validModel;
    }

    public void setValidModel(boolean valid) {
        this.validModel = valid;
        this.getMyParent().setValidModel(this.validModel);
    }

    private List<Pair<InteractEntry, SsKijyoEntry>> checkSymptom(SqlMasterDao dao, String importCode) {
        ArrayList<Pair<InteractEntry, SsKijyoEntry>> result = new ArrayList<Pair<InteractEntry, SsKijyoEntry>>();
        ArrayList<String> onStampCode = new ArrayList<String>();
        for (MasterItem item : this.PharmaceuticalsTableModel.getObjectList()) {
            onStampCode.add(item.getCode());
        }
        dao.getSsKijyoEntry(importCode, onStampCode, result);
        return result;
    }

    @Override
    public void propertyChange(PropertyChangeEvent e) {
        Object newValue = e.getNewValue();
        if (newValue != null && newValue instanceof MasterItem) {
            MasterItem item = (MasterItem)newValue;
            if (SinryoCode.isComment(item.getCode())) {
                CommentHelper ch = new CommentHelper();
                if (ch.confirm(item)) {
                    this.PharmaceuticalsTableModel.addRow(item);
                    this.scrollToBottom(this.scroller);
                }
            } else if (item.getClassCode() == 2) {
                SqlMasterDao dao = (SqlMasterDao)SqlDaoFactory.create("dao.master");
                boolean isCancel = false;
                List<Pair<InteractEntry, SsKijyoEntry>> symptoms = this.checkSymptom(dao, item.getCode());
                if (!symptoms.isEmpty()) {
                    SymptomsDialog symptomDialog = new SymptomsDialog(null, true, dao, symptoms);
                    symptomDialog.setVisible(true);
                    isCancel = symptomDialog.IsCancel();
                }
                if (!isCancel) {
                    String inputNum = this.defaultNumber;
                    if (item.getUnit() != null) {
                        String unit = item.getUnit();
                        if (unit.equals("\u9320")) {
                            inputNum = GlobalVariables.getPreferences().get("defaultZyozaiNum", "3");
                        } else if (unit.equals("\uff47")) {
                            inputNum = GlobalVariables.getPreferences().get("defaultSanyakuNum", "1.0");
                        } else if (unit.equals("\uff4d\uff2c")) {
                            inputNum = GlobalVariables.getPreferences().get("defaultMizuyakuNum", "1");
                        }
                    }
                    item.setNumber(inputNum);
                    this.PharmaceuticalsTableModel.addRow(item);
                    this.scrollToBottom(this.scroller);
                    String name = this.stampNameField.getText().trim();
                    if (name.equals("") || name.equals(DEFAULT_STAMP_NAME)) {
                        this.stampNameField.setText(item.getName());
                    }
                }
            } else if (item.getClassCode() == 1) {
                item.setNumber(this.defaultNumber);
                this.PharmaceuticalsTableModel.addRow(item);
                this.scrollToBottom(this.scroller);
                String name = this.stampNameField.getText().trim();
                if (name.equals("") || name.equals(DEFAULT_STAMP_NAME)) {
                    this.stampNameField.setText(item.getName());
                }
            } else if (item.getClassCode() == 0) {
                this.PharmaceuticalsTableModel.addRow(item);
                this.scrollToBottom(this.scroller);
                String name = this.stampNameField.getText().trim();
                if (name.equals("") || name.equals(DEFAULT_STAMP_NAME)) {
                    this.stampNameField.setText(item.getName());
                }
            } else if (item.getClassCode() == 3) {
                item.setName(ADMIN_MARK + item.getName());
                item.setDummy("X");
                item.setBundleNumber(GlobalVariables.getPreferences().get("defaultRpNum", this.defaultNumber));
                this.PharmaceuticalsTableModel.addRow(item);
                this.scrollToBottom(this.scroller);
            }
            this.stateMgr.checkState();
        }
    }

    private void scrollToBottom(final JScrollPane pane) {
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                pane.getVerticalScrollBar().setValue(pane.getVerticalScrollBar().getMaximum());
            }
        });
    }

    private void notifySelectedRow() {
        int index = this.medTable.getSelectedRow();
        MasterItem item = this.PharmaceuticalsTableModel.getObject(index);
        this.removeButton.setEnabled(item != null);
        if (item != null) {
            this.editButton.setEnabled(SinryoCode.isComment(item.getCode()));
        } else {
            this.editButton.setEnabled(false);
        }
    }

    public void clear() {
        this.PharmaceuticalsTableModel.clear();
        this.forceInExtFlag.setSelected(false);
        this.stateMgr.checkState();
    }

    private void setStampName() {
        if (this.PharmaceuticalsTableModel.getRowCount() > 0) {
            this.stampNameField.setText(this.PharmaceuticalsTableModel.getObject(0).getName());
        }
    }

    private void removeSelectedItem() {
        int index = this.medTable.getSelectedRow();
        if (index < 0) {
            this.notifySelectedRow();
            return;
        }
        MasterItem o = this.PharmaceuticalsTableModel.getObject(index);
        if (o == null) {
            this.notifySelectedRow();
            return;
        }
        this.PharmaceuticalsTableModel.deleteRow(index);
        this.setStampName();
        this.stateMgr.checkState();
    }

    private ModuleModel createModuleModel() {
        ModuleModel retModel = new ModuleModel();
        BundleMed med = new BundleMed();
        retModel.setModel(med);
        ModuleInfoBean moduleInfo = retModel.getModuleInfo();
        moduleInfo.setEntity(this.getEntity());
        moduleInfo.setStampRole("p");
        String stampName = this.stampNameField.getText().trim();
        if (!stampName.equals("")) {
            moduleInfo.setStampName(stampName);
        } else {
            moduleInfo.setStampName(DEFAULT_STAMP_NAME);
        }
        return retModel;
    }

    private ClaimItem createClaimItem(MasterItem mItem) {
        ClaimItem item = new ClaimItem(mItem);
        item.setClassCode(String.valueOf(mItem.getClassCode()));
        item.setClassCodeSystem("Claim003");
        return item;
    }

    private List<ModuleModel> getBundles() {
        ArrayList<ModuleModel> retList = new ArrayList<ModuleModel>();
        List<MasterItem> items = this.PharmaceuticalsTableModel.getObjectList();
        ModuleModel module = this.createModuleModel();
        BundleMed bundle = (BundleMed)module.getModel();
        boolean isTonyo = false;
        for (MasterItem item : items) {
            if (item.getClassCode() != 3 || !SinryoCode.isTonyo(item.getCode())) continue;
            isTonyo = true;
        }
        for (MasterItem mItem : items) {
            if (mItem == null) break;
            String number = mItem.getNumber();
            if (number != null && !number.trim().equals("")) {
                mItem.setNumber(number);
            } else {
                number = null;
            }
            if (SinryoCode.isComment(mItem.getCode())) {
                bundle.addClaimItem(this.createClaimItem(mItem));
                continue;
            }
            this.setItem(bundle, mItem, number, isTonyo, retList, module);
        }
        retList.add(module);
        module = this.createModuleModel();
        bundle = (BundleMed)module.getModel();
        return retList;
    }

    private void setItem(BundleMed bundle, MasterItem mItem, String number, boolean isTonyo, List<ModuleModel> retList, ModuleModel module) {
        switch (mItem.getClassCode()) {
            case 0: {
                ClaimItem sItem = this.createClaimItem(mItem);
                bundle.addClaimItem(sItem);
                break;
            }
            case 2: {
                ClaimItem yItem = this.createClaimItem(mItem);
                bundle.addClaimItem(yItem);
                yItem.setYkzKbn(mItem.getYkzKbn());
                if (number != null) {
                    yItem.setNumber(number);
                    yItem.setUnit(mItem.getUnit());
                    yItem.setNumberCode("10");
                    yItem.setNumberCodeSystem("Claim004");
                }
                if (bundle.getClassCode() != null) break;
                String rCode = null;
                rCode = this.selectClassCodeForYakuzai(mItem.getYkzKbn(), isTonyo, this.forceInExtFlag.isSelected());
                if (rCode == null && this.saveReceiptCode != null) {
                    rCode = this.saveReceiptCode;
                }
                bundle.setClassCode(rCode);
                bundle.setClassCodeSystem("Claim007");
                bundle.setClassName(MMLTable.getClaimClassCodeName(rCode));
                break;
            }
            case 1: {
                ClaimItem zItem = this.createClaimItem(mItem);
                bundle.addClaimItem(zItem);
                if (number == null) break;
                zItem.setNumber(number);
                zItem.setUnit(mItem.getUnit());
                zItem.setNumberCode("21");
                zItem.setNumberCodeSystem("Claim004");
                break;
            }
            case 3: {
                String ommit = mItem.getName().replaceAll(REG_ADMIN_MARK, "");
                bundle.setAdmin(ommit);
                bundle.setAdminCode(mItem.getCode());
                String bNum = mItem.getBundleNumber();
                if (bNum != null && !bNum.trim().equals("")) {
                    bundle.setBundleNumber(mItem.getBundleNumber());
                }
                String memo = this.inMed.isSelected() ? IN_MEDICINE : EXT_MEDICINE;
                bundle.setMemo(memo);
            }
        }
    }

    private String selectClassCodeForYakuzai(String ykzKbn, boolean isTonyo, boolean isForce) {
        String rCode = null;
        if (ykzKbn != null) {
            rCode = ykzKbn.equals("6") ? "230" : "210";
        }
        if (rCode == null) {
            return null;
        }
        if (rCode.equals("210") && isTonyo) {
            rCode = "220";
        }
        if (isForce) {
            if (rCode.equals("230")) {
                rCode = this.inMed.isSelected() ? "231" : "232";
            } else if (rCode.equals("210")) {
                rCode = this.inMed.isSelected() ? "211" : "212";
            } else if (rCode.equals("220")) {
                rCode = this.inMed.isSelected() ? "221" : "222";
            }
        }
        return rCode;
    }

    public Object getValue() {
        List<ModuleModel> list = this.getBundles();
        return list.get(0);
    }

    public void setValue(Object theStamp) {
        String memo;
        ClaimItem[] items;
        Date now = new Date();
        this.clear();
        if (theStamp == null) {
            this.stateMgr.checkState();
            return;
        }
        ModuleModel target = (ModuleModel)theStamp;
        this.setEntity(target.getModuleInfo().getEntity());
        String stampName = target.getModuleInfo().getStampName();
        boolean serialized = target.getModuleInfo().isSerialized();
        if (!serialized && stampName.startsWith(FROM_EDITOR_STAMP_NAME)) {
            stampName = DEFAULT_STAMP_NAME;
        } else if (stampName.equals("")) {
            stampName = DEFAULT_STAMP_NAME;
        }
        this.stampNameField.setText(stampName);
        BundleMed med = (BundleMed)target.getModel();
        if (med == null) {
            return;
        }
        String classCode = med.getClassCode();
        if (classCode != null) {
            this.forceInExtFlag.setSelected(classCode.matches("^..[12]$"));
        }
        if (med.getClassCode() != null) {
            this.saveReceiptCode = med.getClassCode();
        }
        if ((items = med.getClaimItem()) != null) {
            for (ClaimItem item : items) {
                MasterItem mItem = new MasterItem(Integer.parseInt(item.getClassCode()), item);
                mItem.setYkzKbn(item.getYkzKbn());
                String number = item.getNumber();
                if (number != null && !number.equals("")) {
                    mItem.setNumber(number);
                    mItem.setUnit(item.getUnit());
                }
                SqlMasterDao dao = (SqlMasterDao)SqlDaoFactory.create("dao.master");
                ArrayList<MedicineEntry> collection = new ArrayList<MedicineEntry>();
                dao.getAlternateEntry(item.getCode(), collection);
                for (MedicineEntry updateEntry : collection) {
                    if (mItem.getCode().equals(updateEntry.getCode())) continue;
                    MasterItem updatedMasterItem = new MasterItem(Integer.parseInt(item.getClassCode()), updateEntry);
                    updatedMasterItem.setUnit(updateEntry.getUnit());
                    updatedMasterItem.setNumber("0");
                    updatedMasterItem.setYkzKbn(item.getYkzKbn());
                    this.PharmaceuticalsTableModel.addRow(updatedMasterItem);
                }
                this.PharmaceuticalsTableModel.addRow(mItem);
                this.scrollToBottom(this.scroller);
            }
        }
        if (med.getAdmin() != null) {
            MasterItem item = new MasterItem(3, med);
            item.setCode(med.getAdminCode());
            item.setName(ADMIN_MARK + med.getAdmin());
            item.setDummy("X");
            String bNumber = med.getBundleNumber();
            item.setBundleNumber(bNumber);
            this.PharmaceuticalsTableModel.addRow(item);
            this.scrollToBottom(this.scroller);
        }
        if ((memo = med.getMemo()) != null && memo.equals(IN_MEDICINE)) {
            this.inMed.setSelected(true);
        } else {
            this.extMed.setSelected(true);
        }
        this.stateMgr.checkState();
    }

    private void editSelectedItem() {
        int idx = this.medTable.getSelectedRow();
        MasterItem item = this.PharmaceuticalsTableModel.getObject(idx);
        if (item != null) {
            if (SinryoCode.isComment(item.getCode())) {
                CommentHelper ch = new CommentHelper();
                ch.confirm(item);
            }
            this.PharmaceuticalsTableModel.fireTableDataChanged();
            this.stateMgr.checkState();
            if (this.PharmaceuticalsTableModel.getObject(0) != null) {
                this.stampNameField.setText(this.PharmaceuticalsTableModel.getObject(0).getName());
            } else {
                this.stampNameField.setText(DEFAULT_STAMP_NAME);
            }
        }
    }
}

