/*
 * Decompiled with CFR 0.152.
 */
package open.dolphin.order;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.BoxLayout;
import javax.swing.DefaultCellEditor;
import javax.swing.DefaultComboBoxModel;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.ListSelectionModel;
import javax.swing.TransferHandler;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableColumn;
import open.dolphin.client.AutoKanjiListener;
import open.dolphin.client.AutoRomanListener;
import open.dolphin.client.IStampModelEditor;
import open.dolphin.client.SymptomsDialog;
import open.dolphin.container.Pair;
import open.dolphin.dao.SqlDaoFactory;
import open.dolphin.dao.SqlMasterDao;
import open.dolphin.helper.NumericDocument;
import open.dolphin.infomodel.BundleDolphin;
import open.dolphin.infomodel.ClaimItem;
import open.dolphin.infomodel.InteractEntry;
import open.dolphin.infomodel.MasterItem;
import open.dolphin.infomodel.MedicineEntry;
import open.dolphin.infomodel.ModuleInfoBean;
import open.dolphin.infomodel.ModuleModel;
import open.dolphin.infomodel.SsKijyoEntry;
import open.dolphin.order.MMLTable;
import open.dolphin.order.MasterItemTransferHandler;
import open.dolphin.order.RadSetTableStateMgr;
import open.dolphin.order.RadiologyMethodPanel;
import open.dolphin.project.GlobalConstants;
import open.dolphin.project.GlobalSettings;
import open.dolphin.project.GlobalVariables;
import open.dolphin.table.ObjectReflectTableModel;
import open.dolphin.table.OddEvenRowRendererWithExpire;

public class RadItemTablePanel
extends JPanel
implements PropertyChangeListener {
    private static final long serialVersionUID = 4365016271224659707L;
    protected static final String DEFAULT_STAMP_NAME = "\u65b0\u898f\u30b9\u30bf\u30f3\u30d7";
    private static final String FROM_EDITOR_STAMP_NAME = "\u30a8\u30c7\u30a3\u30bf\u304b\u3089";
    private static final String DEFAULT_NUMBER = "1";
    private static final String[] COLUMN_NAMES = new String[]{"\u30b3\u30fc\u30c9", "\u8a3a\u7642\u5185\u5bb9", "\u6570 \u91cf", "\u5358 \u4f4d"};
    private static final String[] METHOD_NAMES = new String[]{"getCode", "getName", "getNumber", "getUnit"};
    private static final int[] COLUMN_WIDTH = new int[]{50, 200, 10, 10};
    private static final int NUM_ROWS = 0;
    private static final int NUMBER_COLUMN = 2;
    private boolean findClaimClassCode;
    private String orderName;
    private String classCode;
    private String classCodeId;
    private String subclassCodeId;
    private String entity;
    private ObjectReflectTableModel<MasterItem> tableModel;
    private RadiologyMethodPanel method;
    private IStampModelEditor parent;
    private boolean validModel;
    private RadSetTableStateMgr stateMgr;
    private Map<String, String[]> relationalCodeSet = new HashMap<String, String[]>();
    private JPanel bp;
    private JPanel center;
    private JButton clearButton;
    private JTextField commentField;
    private JPanel infoP;
    private JLabel jLabel1;
    private JLabel jLabel2;
    private JLabel jLabel3;
    private JComboBox numberCombo;
    private JButton removeButton;
    private JScrollPane scroller;
    private JTable setTable;
    private JPanel south;
    private JTextField stampNameField;
    private JTextField volumeEditor;

    public RadItemTablePanel(IStampModelEditor parent) {
        this.initComponents();
        String[] ary = new String[]{"170000410", "170000510"};
        String[] ary2 = new String[]{"170001910"};
        this.relationalCodeSet.put("170001910", ary);
        this.relationalCodeSet.put("170000410", ary2);
        this.relationalCodeSet.put("170000510", ary2);
        String[] ary3_1 = new String[]{"170000810"};
        String[] ary3_2 = new String[]{"170002110"};
        this.relationalCodeSet.put("170002110", ary3_1);
        this.relationalCodeSet.put("170000810", ary3_2);
        String[] ary4_1 = new String[]{"170000910", "170001010"};
        String[] ary4_2 = new String[]{"170002410"};
        this.relationalCodeSet.put("170002410", ary4_1);
        this.relationalCodeSet.put("170000910", ary4_2);
        this.relationalCodeSet.put("170001010", ary4_2);
        this.setMyParent(parent);
        this.InitCustomComponents();
    }

    private void initComponents() {
        this.volumeEditor = new JTextField();
        this.center = new JPanel();
        this.scroller = new JScrollPane();
        this.setTable = new JTable();
        this.south = new JPanel();
        this.infoP = new JPanel();
        this.jLabel1 = new JLabel();
        this.stampNameField = new JTextField();
        this.jLabel2 = new JLabel();
        this.numberCombo = new JComboBox();
        this.jLabel3 = new JLabel();
        this.commentField = new JTextField();
        this.bp = new JPanel();
        this.removeButton = new JButton();
        this.clearButton = new JButton();
        this.volumeEditor.setText("jTextField1");
        this.volumeEditor.setName("volumeEditor");
        this.setLayout(new BorderLayout(5, 11));
        this.center.setName("center");
        this.center.setLayout(new BorderLayout());
        this.scroller.setHorizontalScrollBarPolicy(31);
        this.scroller.setName("scroller");
        this.setTable.setModel(new DefaultTableModel(new Object[][]{{null, null, null, null}, {null, null, null, null}, {null, null, null, null}, {null, null, null, null}}, new String[]{"Title 1", "Title 2", "Title 3", "Title 4"}));
        this.setTable.setToolTipText("\u30c9\u30e9\u30c3\u30b0 & \u30c9\u30ed\u30c3\u30d7\u3067\u9806\u756a\u3092\u5165\u308c\u66ff\u3048\u308b\u3053\u3068\u304c\u3067\u304d\u307e\u3059\u3002");
        this.setTable.setName("setTable");
        this.setTable.setSelectionMode(0);
        this.setTable.addMouseMotionListener(new MouseMotionAdapter(){

            @Override
            public void mouseDragged(MouseEvent evt) {
                RadItemTablePanel.this.setTableMouseDragged(evt);
            }
        });
        this.scroller.setViewportView(this.setTable);
        this.center.add((Component)this.scroller, "Center");
        this.add((Component)this.center, "Center");
        this.south.setName("south");
        this.south.setLayout(new BoxLayout(this.south, 0));
        this.infoP.setName("infoP");
        this.infoP.setLayout(new FlowLayout(0));
        this.jLabel1.setText("\u30bb\u30c3\u30c8\u540d");
        this.jLabel1.setName("jLabel1");
        this.infoP.add(this.jLabel1);
        this.stampNameField.setBackground(new Color(251, 239, 128));
        this.stampNameField.setColumns(15);
        this.stampNameField.setName("stampNameField");
        this.infoP.add(this.stampNameField);
        this.jLabel2.setText("\u56de \u6570");
        this.jLabel2.setName("jLabel2");
        this.infoP.add(this.jLabel2);
        this.numberCombo.setModel(new DefaultComboBoxModel<String>(new String[]{DEFAULT_NUMBER, "2", "3", "4", "5", "6", "7", "8", "9", "10", "11", "12", "13", "14", "15", "16", "17", "18", "19", "20", "21", "22", "23", "24", "25", "26", "27", "28", "29", "30", "31"}));
        this.numberCombo.setName("numberCombo");
        this.infoP.add(this.numberCombo);
        this.jLabel3.setText("\u30e1 \u30e2");
        this.jLabel3.setName("jLabel3");
        this.infoP.add(this.jLabel3);
        this.commentField.setColumns(15);
        this.commentField.setName("commentField");
        this.infoP.add(this.commentField);
        this.south.add(this.infoP);
        this.bp.setName("bp");
        this.bp.setLayout(new FlowLayout(2));
        this.removeButton.setIcon(new ImageIcon(this.getClass().getResource("/open/dolphin/resources/images/del_16.gif")));
        this.removeButton.setToolTipText("\u9078\u629e\u3057\u305f\u30a2\u30a4\u30c6\u30e0\u3092\u524a\u9664\u3057\u307e\u3059\u3002");
        this.removeButton.setEnabled(false);
        this.removeButton.setName("removeButton");
        this.removeButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                RadItemTablePanel.this.removeButtonActionPerformed(evt);
            }
        });
        this.bp.add(this.removeButton);
        this.clearButton.setIcon(new ImageIcon(this.getClass().getResource("/open/dolphin/resources/images/remov_16.gif")));
        this.clearButton.setToolTipText("\u30bb\u30c3\u30c8\u5185\u5bb9\u3092\u30af\u30ea\u30a2\u3057\u307e\u3059\u3002");
        this.clearButton.setEnabled(false);
        this.clearButton.setName("clearButton");
        this.clearButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                RadItemTablePanel.this.clearButtonActionPerformed(evt);
            }
        });
        this.bp.add(this.clearButton);
        this.south.add(this.bp);
        this.add((Component)this.south, "South");
    }

    private void removeButtonActionPerformed(ActionEvent evt) {
        this.removeSelectedItem();
    }

    private void clearButtonActionPerformed(ActionEvent evt) {
        this.clear();
    }

    private void setTableMouseDragged(MouseEvent evt) {
        int ctrlMask = 128;
        int action = (evt.getModifiersEx() & ctrlMask) == ctrlMask ? 1 : 2;
        JComponent c = (JComponent)evt.getSource();
        TransferHandler handler = c.getTransferHandler();
        handler.exportAsDrag(c, evt, action);
    }

    private void InitCustomComponents() {
        this.tableModel = new ObjectReflectTableModel<MasterItem>(COLUMN_NAMES, 0, METHOD_NAMES, null){
            private static final long serialVersionUID = 5162264518307934378L;

            @Override
            public boolean isCellEditable(int row, int col) {
                return col == 2;
            }

            @Override
            public void setValueAt(Object o, int row, int col) {
                if (o == null || ((String)o).trim().equals("")) {
                    o = new String("0");
                }
                MasterItem mItem = (MasterItem)this.getObject(row);
                if (col == 2 && mItem != null) {
                    mItem.setNumber((String)o);
                    StringBuffer changed = new StringBuffer("");
                    if (RadItemTablePanel.this.relationalCodeSet.containsKey(mItem.getCode())) {
                        String[] vals;
                        for (String s : vals = (String[])RadItemTablePanel.this.relationalCodeSet.get(mItem.getCode())) {
                            for (MasterItem obj : RadItemTablePanel.this.tableModel.getObjectList()) {
                                MasterItem m = obj;
                                if (!m.getCode().equals(s)) continue;
                                m.setNumber(mItem.getNumber());
                                changed.append(m.getName());
                                changed.append("\n");
                            }
                        }
                    }
                    RadItemTablePanel.this.stateMgr.checkState();
                    if (!changed.toString().isEmpty()) {
                        RadItemTablePanel.this.setTable.repaint();
                        JOptionPane.showMessageDialog(null, "\u95a2\u4fc2\u3059\u308b\u6570\u91cf\u3082\u5909\u66f4\u3057\u307e\u3057\u305f\u3002\n" + changed + "\u3092\u78ba\u8a8d\u304f\u3060\u3055\u3044\u3002", "", 1);
                    }
                }
            }
        };
        this.setTable.setModel(this.tableModel);
        this.setTable.setTransferHandler(new MasterItemTransferHandler());
        ListSelectionModel m = this.setTable.getSelectionModel();
        m.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                if (!e.getValueIsAdjusting()) {
                    RadItemTablePanel.this.notifySelectedRow();
                }
            }
        });
        this.setTable.setDefaultRenderer(Object.class, new OddEvenRowRendererWithExpire());
        TableColumn column = null;
        if (COLUMN_WIDTH != null) {
            int len = COLUMN_WIDTH.length;
            for (int i = 0; i < len; ++i) {
                column = this.setTable.getColumnModel().getColumn(i);
                column.setPreferredWidth(COLUMN_WIDTH[i]);
            }
        }
        int ccts = GlobalVariables.getPreferences().getInt("order.table.clickCountToStart", 2);
        this.volumeEditor.addFocusListener(AutoRomanListener.getInstance());
        this.volumeEditor.setDocument(new NumericDocument());
        column = this.setTable.getColumnModel().getColumn(2);
        DefaultCellEditor volumeCellEditor = new DefaultCellEditor(this.volumeEditor);
        volumeCellEditor.setClickCountToStart(ccts);
        column.setCellEditor(volumeCellEditor);
        this.commentField.addFocusListener(AutoKanjiListener.getInstance());
        this.stampNameField.addFocusListener(AutoKanjiListener.getInstance());
        this.method = new RadiologyMethodPanel();
        this.method.addPropertyChangeListener("radiologyProp", this);
        if (this.parent.getContext().getOkButton() != null) {
            this.bp.add(this.parent.getContext().getOkButton());
        }
        this.scroller.getViewport().setBackground(GlobalSettings.getColors(GlobalSettings.Parts.TABLE_BACKGROUND));
        this.center.add((Component)this.method, "West");
        this.setPreferredSize(new Dimension(680, 230));
        this.stateMgr = new RadSetTableStateMgr(this, this.setTable, this.removeButton, this.clearButton, this.stampNameField);
    }

    public boolean isValidModel() {
        return this.validModel;
    }

    public void setValidModel(boolean valid) {
        this.validModel = valid;
        this.getMyParent().setValidModel(this.validModel);
    }

    public String getOrderName() {
        return this.orderName;
    }

    public void setOrderName(String val) {
        this.orderName = val;
    }

    public String getEntity() {
        return this.entity;
    }

    public void setEntity(String val) {
        this.entity = val;
    }

    public String getClassCode() {
        return this.classCode;
    }

    public void setClassCode(String val) {
        this.classCode = val;
    }

    public String getClassCodeId() {
        return this.classCodeId;
    }

    public void setClassCodeId(String val) {
        this.classCodeId = val;
    }

    public String getSubClassCodeId() {
        return this.subclassCodeId;
    }

    public void setSubClassCodeId(String val) {
        this.subclassCodeId = val;
    }

    public IStampModelEditor getMyParent() {
        return this.parent;
    }

    public void setMyParent(IStampModelEditor parent) {
        this.parent = parent;
    }

    public String getBundleNumber() {
        return (String)this.numberCombo.getSelectedItem();
    }

    public void setBundleNumber(String val) {
        this.numberCombo.setSelectedItem(val);
    }

    public boolean isFindClaimClassCode() {
        return this.findClaimClassCode;
    }

    public void setFindClaimClassCode(boolean b) {
        this.findClaimClassCode = true;
    }

    private void setStampName(ModuleInfoBean moduleInfo) {
        String text = this.stampNameField.getText().trim();
        if (!text.equals("")) {
            moduleInfo.setStampName(text);
        } else {
            moduleInfo.setStampName(DEFAULT_STAMP_NAME);
        }
    }

    private String getClassCodeFromItems(MasterItem mItem) {
        String result = null;
        if (this.isFindClaimClassCode() && mItem.getClassCode() == 0 && mItem.getClaimClassCode() != null && !mItem.getClaimClassCode().trim().isEmpty()) {
            this.classCode = mItem.getClaimClassCode().equals("311") ? "310" : (mItem.getClaimClassCode().equals("321") ? "320" : (mItem.getClaimClassCode().equals("331") ? "330" : mItem.getClaimClassCode()));
        }
        return result;
    }

    private ClaimItem createClaimItem(MasterItem masterRecord) {
        ClaimItem result = new ClaimItem(masterRecord);
        result.setClassCode(String.valueOf(masterRecord.getClassCode()));
        result.setClassCodeSystem(this.subclassCodeId);
        String number = masterRecord.getNumber();
        if (number != null && !(number = number.trim()).equals("")) {
            result.setNumber(number);
            result.setUnit(masterRecord.getUnit());
            result.setNumberCode(this.getNumberCode(masterRecord.getClassCode()));
            result.setNumberCodeSystem("Claim004");
        }
        return result;
    }

    private void setBundleItem(List itemList, BundleDolphin bundle) {
        if (itemList != null) {
            boolean found = false;
            for (MasterItem masterRecord : itemList) {
                String _classCode;
                bundle.addClaimItem(this.createClaimItem(masterRecord));
                if (found || (_classCode = this.getClassCodeFromItems(masterRecord)) == null) continue;
                this.classCode = _classCode;
                found = true;
            }
        }
    }

    private void setBandle(BundleDolphin bundle) {
        bundle.setOrderName(this.getOrderName());
        this.setMemo(bundle);
        bundle.setBundleNumber((String)this.numberCombo.getSelectedItem());
        bundle.setClassCode(this.classCode);
        bundle.setClassCodeSystem(this.classCodeId);
        bundle.setClassName(MMLTable.getClaimClassCodeName(this.classCode));
    }

    private void setMemo(BundleDolphin bundle) {
        String memo = this.commentField.getText();
        if (!memo.equals("")) {
            bundle.setMemo(memo);
        }
    }

    public Object getValue() {
        ModuleModel result = new ModuleModel();
        ModuleInfoBean moduleInfo = result.getModuleInfo();
        moduleInfo.setEntity(this.getEntity());
        moduleInfo.setStampRole("p");
        this.setStampName(moduleInfo);
        BundleDolphin bundle = new BundleDolphin();
        List<MasterItem> itemList = this.tableModel.getObjectList();
        this.setBundleItem(itemList, bundle);
        this.setBandle(bundle);
        result.setModel(bundle);
        return result;
    }

    public void setValue(Object theStamp) {
        String number;
        Date now = new Date();
        this.clear();
        if (theStamp == null) {
            this.stateMgr.checkState();
            return;
        }
        ModuleModel target = (ModuleModel)theStamp;
        this.setEntity(target.getModuleInfo().getEntity());
        String stampName = target.getModuleInfo().getStampName();
        boolean serialized = target.getModuleInfo().isSerialized();
        if (!serialized && stampName.startsWith(FROM_EDITOR_STAMP_NAME)) {
            stampName = DEFAULT_STAMP_NAME;
        } else if (stampName.equals("")) {
            stampName = DEFAULT_STAMP_NAME;
        }
        this.stampNameField.setText(stampName);
        BundleDolphin bundle = (BundleDolphin)target.getModel();
        if (bundle == null) {
            return;
        }
        this.classCode = bundle.getClassCode();
        for (ClaimItem item : bundle.getClaimItem()) {
            String val = item.getClassCode();
            MasterItem mItem = new MasterItem(Integer.parseInt(val), item);
            val = item.getNumber();
            if (val != null) {
                if (!(val = val.trim()).equals("")) {
                    mItem.setNumber(val);
                }
                if ((val = item.getUnit()) != null) {
                    mItem.setUnit(val);
                }
            }
            if (item.getEndDate() != null && !item.getEndDate().equals("99999999") && !item.getEndDate().equals("")) {
                SqlMasterDao dao = (SqlMasterDao)SqlDaoFactory.create("dao.master");
                ArrayList<MedicineEntry> collection = new ArrayList<MedicineEntry>();
                dao.getAlternateEntry(item.getCode(), collection);
                for (MedicineEntry updateEntry : collection) {
                    if (mItem.getCode().equals(updateEntry.getCode())) continue;
                    MasterItem updatedMasterItem = new MasterItem(Integer.parseInt(item.getClassCode()), updateEntry);
                    updatedMasterItem.setUnit(updateEntry.getUnit());
                    updatedMasterItem.setNumber("0");
                    updatedMasterItem.setYkzKbn(item.getYkzKbn());
                    this.tableModel.addRow(updatedMasterItem);
                }
            }
            this.tableModel.addRow(mItem);
            this.scrollToBottom(this.scroller);
        }
        String memo = bundle.getMemo();
        if (memo != null) {
            this.commentField.setText(memo);
        }
        if ((number = bundle.getBundleNumber()) != null && !number.equals("")) {
            this.numberCombo.setSelectedItem(number);
        }
        this.stateMgr.checkState();
    }

    private List<Pair<InteractEntry, SsKijyoEntry>> checkSymptom(SqlMasterDao dao, String importCode) {
        ArrayList<Pair<InteractEntry, SsKijyoEntry>> result = new ArrayList<Pair<InteractEntry, SsKijyoEntry>>();
        ArrayList<String> onStampCode = new ArrayList<String>();
        for (MasterItem item : this.tableModel.getObjectList()) {
            onStampCode.add(item.getCode());
        }
        dao.getSsKijyoEntry(importCode, onStampCode, result);
        return result;
    }

    @Override
    public void propertyChange(PropertyChangeEvent e) {
        String prop = e.getPropertyName();
        if (prop.equals("selectedItemProp")) {
            MasterItem item = (MasterItem)e.getNewValue();
            String textVal = this.stampNameField.getText().trim();
            switch (item.getClassCode()) {
                case 0: {
                    if (textVal.equals("") || textVal.equals(DEFAULT_STAMP_NAME)) {
                        this.stampNameField.setText(item.getName());
                    }
                    this.tableModel.addRow(item);
                    this.stateMgr.checkState();
                    this.scrollToBottom(this.scroller);
                    break;
                }
                case 2: {
                    SqlMasterDao dao = (SqlMasterDao)SqlDaoFactory.create("dao.master");
                    boolean isCancel = false;
                    List<Pair<InteractEntry, SsKijyoEntry>> symptoms = this.checkSymptom(dao, item.getCode());
                    if (symptoms.size() != 0) {
                        SymptomsDialog symptomDialog = new SymptomsDialog((Frame)((JFrame)this.getRootPane().getParent()), true, dao, symptoms);
                        symptomDialog.setVisible(true);
                        isCancel = symptomDialog.IsCancel();
                    }
                    if (isCancel) break;
                    String inputNum = DEFAULT_NUMBER;
                    if (item.getUnit() != null) {
                        String unit = item.getUnit();
                        if (unit.equals("\u9320")) {
                            inputNum = GlobalVariables.getPreferences().get("defaultZyozaiNum", "3");
                        } else if (unit.equals("\uff47")) {
                            inputNum = GlobalVariables.getPreferences().get("defaultSanyakuNum", "1.0");
                        } else if (unit.equals("\uff4d\uff2c")) {
                            inputNum = GlobalVariables.getPreferences().get("defaultMizuyakuNum", DEFAULT_NUMBER);
                        }
                    }
                    item.setNumber(inputNum);
                    this.tableModel.addRow(item);
                    this.stateMgr.checkState();
                    this.scrollToBottom(this.scroller);
                    break;
                }
                case 1: {
                    item.setNumber(DEFAULT_NUMBER);
                    this.tableModel.addRow(item);
                    this.stateMgr.checkState();
                    this.scrollToBottom(this.scroller);
                    break;
                }
            }
        } else if (prop.equals("radiologyProp")) {
            String text = (String)e.getNewValue();
            this.commentField.setText(text);
        }
    }

    private void notifySelectedRow() {
        int index = this.setTable.getSelectedRow();
        boolean b = this.tableModel.getObject(index) != null;
        this.removeButton.setEnabled(b);
    }

    public void clear() {
        this.tableModel.clear();
        this.stateMgr.checkState();
    }

    private void removeSelectedItem() {
        int row = this.setTable.getSelectedRow();
        if (this.tableModel.getObject(row) != null) {
            this.tableModel.deleteRow(row);
            this.stateMgr.checkState();
        }
    }

    private String getNumberCode(int subclassCode) {
        return subclassCode == 1 ? "21" : "11";
    }

    private ImageIcon createImageIcon(String name) {
        return GlobalConstants.getImageIcon(name);
    }

    private void scrollToBottom(final JScrollPane pane) {
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                pane.getVerticalScrollBar().setValue(pane.getVerticalScrollBar().getMaximum());
            }
        });
    }
}

