/*
 * Decompiled with CFR 0.152.
 */
package open.dolphin.order;

import java.awt.BorderLayout;
import java.awt.Component;
import java.util.EnumSet;
import javax.swing.BorderFactory;
import javax.swing.JPanel;
import javax.swing.border.Border;
import open.dolphin.client.GUIConst;
import open.dolphin.client.editor.stamp.StampModelEditor;
import open.dolphin.order.ClaimConst;
import open.dolphin.order.MasterSetPanel;
import open.dolphin.order.RadItemTablePanel;

public final class RadiologyStampEditor
extends StampModelEditor {
    private static final long serialVersionUID = 2467212598346800512L;
    private RadItemTablePanel testTable;
    private MasterSetPanel masterPanel;

    @Override
    public void start() {
        ClaimConst.ClaimSpec spec = ClaimConst.ClaimSpec.RADIOLOGY;
        this.testTable = new RadItemTablePanel(this);
        this.testTable.setOrderName(spec.getName());
        this.testTable.setClassCode(spec.getClassCode());
        this.testTable.setClassCodeId("Claim007");
        this.testTable.setSubClassCodeId("Claim003");
        EnumSet<ClaimConst.MasterSet> set = EnumSet.of(ClaimConst.MasterSet.TREATMENT, ClaimConst.MasterSet.MEDICAL_SUPPLY, ClaimConst.MasterSet.INJECTION_MEDICINE, ClaimConst.MasterSet.TOOL_MATERIAL);
        this.masterPanel = new MasterSetPanel(set);
        this.masterPanel.setSearchClass(spec.getSearchCode());
        this.masterPanel.setRadLocationEnabled(true);
        this.masterPanel.startTest(this.testTable);
        this.setTitle(spec.getName());
        Border b = BorderFactory.createEtchedBorder();
        this.testTable.setBorder(BorderFactory.createTitledBorder(b, spec.getName()));
        JPanel top = new JPanel(new BorderLayout());
        top.add((Component)this.testTable, "Center");
        this.setLayout(new BorderLayout(0, 11));
        this.add((Component)top, "North");
        this.add((Component)this.masterPanel, "Center");
        this.setPreferredSize(GUIConst.DEFAULT_STAMP_EDITOR_SIZE);
    }

    @Override
    public Object getValue() {
        return this.testTable.getValue();
    }

    @Override
    public void setValue(Object val) {
        this.testTable.setValue(val);
    }

    @Override
    public void dispose() {
        this.masterPanel.stopTest(this.testTable);
    }
}

