/*
 * Decompiled with CFR 0.152.
 */
package open.dolphin.service.remote;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import open.dolphin.dto.AppointSpec;
import open.dolphin.dto.ModuleSearchSpec;
import open.dolphin.infomodel.AppointmentModel;
import open.dolphin.service.DolphinService;
import open.dolphin.service.IAppointmentService;
import org.hibernate.HibernateException;

public class RemoteAppoService
extends DolphinService
implements IAppointmentService {
    @Override
    public void putAppointments(AppointSpec spec) {
        block8: {
            this.roleAllowed("user");
            Collection added = spec.getAdded();
            Collection updated = spec.getUpdared();
            Collection removed = spec.getRemoved();
            AppointmentModel av2 = null;
            try {
                this.startTransaction();
                if (added != null && added.size() > 0) {
                    for (AppointmentModel av2 : added) {
                        this.checkIdAsComposite(av2.getPatientId());
                        this.getSession().persist((Object)av2);
                    }
                }
                if (updated != null && updated.size() > 0) {
                    for (AppointmentModel av2 : updated) {
                        this.checkIdAsComposite(av2.getPatientId());
                        this.getSession().merge((Object)av2);
                    }
                }
                if (removed != null && removed.size() > 0) {
                    for (AppointmentModel av2 : removed) {
                        this.checkIdAsComposite(av2.getPatientId());
                        AppointmentModel target = (AppointmentModel)this.getSession().createQuery("from AppointmentModel where id = :id").setParameter("id", (Object)av2.getId()).uniqueResult();
                        this.getSession().delete((Object)target);
                    }
                }
                this.endTransaction();
            }
            catch (HibernateException e) {
                if (!this.getSession().getTransaction().isActive()) break block8;
                this.getSession().getTransaction().rollback();
            }
        }
    }

    @Override
    public Collection getAppointmentList(ModuleSearchSpec spec) {
        ArrayList<List> ret;
        block3: {
            this.roleAllowed("user");
            String pcid = this.checkIdAsComposite(spec.getPatientId());
            Date[] fromDate = spec.getFromDate();
            Date[] toDate = spec.getToDate();
            int len = fromDate.length;
            ret = new ArrayList<List>(len);
            try {
                this.startTransaction();
                for (int i = 0; i < len; ++i) {
                    List c = this.getSession().createQuery("appoByPatient").setParameter("pid", (Object)pcid).setParameter("from", (Object)fromDate[i]).setParameter("to", (Object)toDate[i]).list();
                    ret.add(c);
                }
                this.endTransaction();
            }
            catch (HibernateException e) {
                if (!this.getSession().getTransaction().isActive()) break block3;
                this.getSession().getTransaction().rollback();
            }
        }
        return ret;
    }
}

