/*
 * Decompiled with CFR 0.152.
 */
package open.dolphin.table;

import java.awt.Color;
import java.awt.Component;
import java.util.ArrayList;
import java.util.Date;
import javax.swing.JTable;
import open.dolphin.dao.SqlDaoFactory;
import open.dolphin.dao.SqlMasterDao;
import open.dolphin.infomodel.MedicineEntry;
import open.dolphin.table.OddEvenRowRenderer;

public class OddEvenRowRendererWithExpire
extends OddEvenRowRenderer {
    private Color updatedColor;
    private Color noLongerAvailableColor;

    public OddEvenRowRendererWithExpire() {
        this.setUpdatedColor(Color.yellow);
        this.setNoLongerAvailableColor(Color.red);
    }

    @Override
    public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
        Date now = new Date();
        if (isSelected) {
            this.setBackground(table.getSelectionBackground());
            this.setForeground(table.getSelectionForeground());
        } else {
            this.setForeground(table.getForeground());
            if (row % 2 == 0) {
                this.setBackground(this.getEvenColor());
            } else {
                this.setBackground(this.getOddColor());
            }
        }
        if (value != null) {
            if (value instanceof String) {
                this.setText((String)value);
                if (column == 0) {
                    SqlMasterDao dao = (SqlMasterDao)SqlDaoFactory.create("dao.master");
                    ArrayList<MedicineEntry> collection = new ArrayList<MedicineEntry>();
                    if (dao.isCodeNoLongerAvailable((String)value, now)) {
                        this.setBackground(this.getNoLongerAvailableColor());
                    }
                    if (dao.getAlternateEntry((String)value, collection)) {
                        this.setBackground(this.getUpdatedColor());
                    }
                }
            } else {
                this.setText(value.toString());
            }
        } else {
            this.setText("");
        }
        return this;
    }

    public void setUpdatedColor(Color updatedColor) {
        this.updatedColor = updatedColor;
    }

    public Color getUpdatedColor() {
        return this.updatedColor;
    }

    public void setNoLongerAvailableColor(Color noLongerAvailableColor) {
        this.noLongerAvailableColor = noLongerAvailableColor;
    }

    public Color getNoLongerAvailableColor() {
        return this.noLongerAvailableColor;
    }
}

