/*
 * Decompiled with CFR 0.152.
 */
package open.dolphin.infomodel;

import java.io.IOException;
import java.io.Writer;
import java.util.GregorianCalendar;
import java.util.List;
import open.dolphin.infomodel.ClaimItem;
import open.dolphin.infomodel.InfoModel;
import open.dolphin.infomodel.MedicineEntry;
import open.dolphin.log.LogWriter;
import open.dolphin.queries.DolphinQuery;
import open.dolphin.utils.StringTool;

public class ClaimBundle
extends InfoModel {
    private static final long serialVersionUID = -7332175271243905003L;
    public static final String DEFAULT_BUNDLE_NUMBER = "1";
    protected String className;
    protected String classCode;
    protected String classCodeSystem;
    protected String admin;
    protected String adminCode;
    protected String adminCodeSystem;
    protected String adminMemo;
    private String bundleNumber;
    protected ClaimItem[] claimItems;
    protected String memo;
    protected String status;

    @Override
    public boolean search(DolphinQuery query) {
        if (this.className != null && this.className.indexOf(query.what("keyword")) != -1) {
            return true;
        }
        if (this.memo != null && this.memo.indexOf(query.what("keyword")) != -1) {
            return true;
        }
        for (ClaimItem item : this.getClaimItem()) {
            if (!item.search(query)) continue;
            return true;
        }
        return false;
    }

    public String getClassName() {
        return this.className;
    }

    public void setClassName(String val) {
        this.className = val;
    }

    public String getClassCode() {
        return this.classCode;
    }

    public void setClassCode(String val) {
        this.classCode = val;
    }

    public String getClassCodeSystem() {
        return this.classCodeSystem;
    }

    public void setClassCodeSystem(String val) {
        this.classCodeSystem = val;
    }

    public String getAdmin() {
        return this.admin;
    }

    public void setAdmin(String val) {
        this.admin = val;
    }

    public String getAdminCode() {
        return this.adminCode;
    }

    public void setAdminCode(String val) {
        this.adminCode = val;
    }

    public String getAdminCodeSystem() {
        return this.adminCodeSystem;
    }

    public void setAdminCodeSystem(String val) {
        this.adminCodeSystem = val;
    }

    public String getAdminMemo() {
        return this.adminMemo;
    }

    public void setAdminMemo(String val) {
        this.adminMemo = val;
    }

    public String getBundleNumber() {
        if (this.bundleNumber == null) {
            return DEFAULT_BUNDLE_NUMBER;
        }
        if (this.bundleNumber.equals("")) {
            return DEFAULT_BUNDLE_NUMBER;
        }
        return this.bundleNumber;
    }

    public void setBundleNumber(String val) {
        try {
            this.setBundleNumber(Integer.parseInt(StringTool.zenkakuNumToHankaku(val.trim())));
        }
        catch (NumberFormatException nfe) {
            LogWriter.error(this.getClass(), nfe);
        }
    }

    public void setBundleNumber(int n) {
        if (n > 0) {
            this.bundleNumber = String.valueOf(n);
        }
    }

    public ClaimItem[] getClaimItem() {
        return this.claimItems;
    }

    public void setClaimItem(ClaimItem[] val) {
        this.claimItems = val;
    }

    public void addClaimItem(ClaimItem val) {
        if (this.getClaimItem() == null) {
            this.setClaimItem(new ClaimItem[1]);
            this.getClaimItem()[0] = val;
            return;
        }
        int len = this.getClaimItem().length;
        ClaimItem[] dest = new ClaimItem[len + 1];
        System.arraycopy(this.getClaimItem(), 0, dest, 0, len);
        this.setClaimItem(dest);
        this.getClaimItem()[len] = val;
    }

    public String getMemo() {
        return this.memo;
    }

    public void setMemo(String memo) {
        this.memo = memo;
    }

    public String getStatus() {
        return this.status;
    }

    public void setStatus(String status) {
        this.status = status;
    }

    public Enabled getStampEnabled(List<MedicineEntry> resultSet, GregorianCalendar gc) {
        ClaimItem[] importClaims = this.getClaimItem();
        if (importClaims != null) {
            for (ClaimItem item : importClaims) {
                if (item.useState(gc) == 1) continue;
                return Enabled.UPDATE_AVAILABLE;
            }
        }
        return Enabled.NORMAL;
    }

    public void serialize(Writer result) throws IOException {
        result.append("<ClaimBundle className='" + this.className + "' classCode='" + this.classCode + "' classCodeSystem='" + this.classCodeSystem + "' admin='" + this.admin + "' adminCode='" + this.adminCode + "' adminCodeSystem='" + this.adminCodeSystem + "' adminMemo='" + this.adminMemo + "' bundleNumber='" + this.bundleNumber + "' memo='" + this.memo + "'>" + System.getProperty("line.separator"));
        for (ClaimItem item : this.getClaimItem()) {
            item.serialize(result);
        }
        result.append("</ClaimBundle>");
    }

    public void deserialize(Writer result) throws IOException {
    }

    public static enum Enabled {
        NORMAL,
        OUT_OF_DATE,
        UPDATE_AVAILABLE;

    }
}

