/*
 * Decompiled with CFR 0.152.
 */
package open.dolphin.infomodel;

import java.io.IOException;
import java.io.Writer;
import open.dolphin.infomodel.InfoModel;
import open.dolphin.log.LogWriter;
import open.dolphin.queries.DolphinQuery;

public class VersionModel
extends InfoModel {
    private static final long serialVersionUID = 5196580420531493579L;
    private int number;
    private int revision;
    private String releaseNote;

    public void initialize() {
        this.number = 1;
    }

    @Override
    public boolean search(DolphinQuery query) {
        return false;
    }

    public String getVersionNumber() {
        StringBuffer buf = new StringBuffer();
        buf.append(String.valueOf(this.number));
        buf.append(".");
        buf.append(String.valueOf(this.revision));
        return buf.toString();
    }

    public void setVersionNumber(String vn) {
        int index = vn.indexOf(46);
        try {
            if (index >= 0) {
                String n = vn.substring(0, index);
                String r = vn.substring(index + 1);
                this.number = Integer.parseInt(n);
                this.revision = Integer.parseInt(r);
            } else {
                this.number = Integer.parseInt(vn);
            }
        }
        catch (NumberFormatException e) {
            LogWriter.error(this.getClass(), "", (Throwable)e);
        }
    }

    public void incrementNumber() {
        ++this.number;
    }

    public void incrementRevision() {
        ++this.revision;
    }

    public void setReleaseNote(String releaseNote) {
        this.releaseNote = releaseNote;
    }

    public String getReleaseNote() {
        return this.releaseNote;
    }

    public void serialize(Writer result) throws IOException {
        result.append("<VersionModel number='" + Integer.toString(this.number) + "' revision='" + Integer.toString(this.revision) + "' releaseNote='" + this.releaseNote + "' />" + System.getProperty("line.separator"));
    }
}

