/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */

/*
 * DoPanel.java
 *
 * Created on 2010/09/07, 16:35:36
 */
package open.dolphin.plugin;

import java.awt.Component;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Enumeration;
import java.util.List;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JTabbedPane;
import javax.swing.JTree;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeCellRenderer;
import javax.swing.tree.TreeSelectionModel;

import open.dolphin.client.IChart;
import open.dolphin.client.IChartDocument;
import open.dolphin.project.GlobalConstants;
import open.dolphin.helper.IChartCommandAccepter;
import open.dolphin.log.LogWriter;
import open.dolphin.project.GlobalSettings;
import open.dolphin.project.GlobalVariables;

/**
 *
 * @author
 */
public class DoPanel extends javax.swing.JPanel implements PropertyChangeListener, IChartDocument, IChartCommandAccepter {

    /**
     *
     */
    public static final String TITLE = "ORCA Do";
    private IChart parent;
    private String title;
    private boolean dirty;
    private DefaultTreeModel treeModel;
    DefaultMutableTreeNode root;
    String patientID;
    private static final ImageIcon LOCAL_ICON = GlobalConstants.getImageIcon("move2_16.gif");

    /** Creates new form DoPanel
     * @param parent
     */
    public DoPanel(IChart parent) {
        this.title = TITLE;
        this.parent = parent;
        initComponents();

        tree.putClientProperty("JTree.lineStyle", "Angled"); // 水平及び垂直線を使用する
        //    tree.setEditable(false); // ノード名を編集不可にする
        tree.getSelectionModel().setSelectionMode(TreeSelectionModel.SINGLE_TREE_SELECTION); // Single Selection// にする
        //  tree.setRootVisible(false);

        root = new DefaultMutableTreeNode();
        patientID = parent.getPatient().getPatientId();

        DoTransferHandler transferHandler = new DoTransferHandler();
        tree.setTransferHandler(transferHandler);

        treeModel = new DefaultTreeModel(root);
        tree.setModel(treeModel);

        final TreeCellRenderer oldRenderer = tree.getCellRenderer();
        TreeCellRenderer r = new TreeCellRenderer() {

            @Override
            public Component getTreeCellRendererComponent(JTree tree, Object value, boolean selected, boolean expanded, boolean leaf, int row, boolean hasFocus) {

                Component cellRenderer = oldRenderer.getTreeCellRendererComponent(tree, value, selected, expanded, leaf, row, hasFocus);
                //    if (leaf && cellRenderer instanceof JLabel) {
                JLabel label = (JLabel) cellRenderer;
                label.setIcon(LOCAL_ICON);
                //    }
                return cellRenderer;

            }
        };
        tree.setCellRenderer(r);
    }

    /** This method is called from within the constructor to
     * initialize the form.
     * WARNING: Do NOT modify this code. The content of this method is
     * always regenerated by the Form Editor.
     */
    @SuppressWarnings("unchecked")
    // <editor-fold defaultstate="collapsed" desc="Generated Code">//GEN-BEGIN:initComponents
    private void initComponents() {

        jComboBox1 = new javax.swing.JComboBox();
        jComboBox2 = new javax.swing.JComboBox();
        jScrollPane1 = new javax.swing.JScrollPane();
        tree = new javax.swing.JTree();

        jComboBox1.setModel(new javax.swing.DefaultComboBoxModel(new String[] { "Item 1", "Item 2", "Item 3", "Item 4" }));
        jComboBox1.setName("jComboBox1"); // NOI18N

        jComboBox2.setModel(new javax.swing.DefaultComboBoxModel(new String[] { "Item 1", "Item 2", "Item 3", "Item 4" }));
        jComboBox2.setName("jComboBox2"); // NOI18N

        jScrollPane1.setName("jScrollPane1"); // NOI18N

        javax.swing.tree.DefaultMutableTreeNode treeNode1 = new javax.swing.tree.DefaultMutableTreeNode("root");
        tree.setModel(new javax.swing.tree.DefaultTreeModel(treeNode1));
        tree.setDragEnabled(true);
        tree.setName("tree"); // NOI18N
        jScrollPane1.setViewportView(tree);

        javax.swing.GroupLayout layout = new javax.swing.GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(
            layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(layout.createSequentialGroup()
                .addContainerGap()
                .addComponent(jComboBox1, javax.swing.GroupLayout.PREFERRED_SIZE, 112, javax.swing.GroupLayout.PREFERRED_SIZE)
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                .addComponent(jComboBox2, javax.swing.GroupLayout.PREFERRED_SIZE, 100, javax.swing.GroupLayout.PREFERRED_SIZE)
                .addContainerGap(145, Short.MAX_VALUE))
            .addComponent(jScrollPane1, javax.swing.GroupLayout.Alignment.TRAILING, javax.swing.GroupLayout.DEFAULT_SIZE, 376, Short.MAX_VALUE)
        );
        layout.setVerticalGroup(
            layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(layout.createSequentialGroup()
                .addGroup(layout.createParallelGroup(javax.swing.GroupLayout.Alignment.BASELINE)
                    .addComponent(jComboBox1, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
                    .addComponent(jComboBox2, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE))
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                .addComponent(jScrollPane1, javax.swing.GroupLayout.DEFAULT_SIZE, 157, Short.MAX_VALUE))
        );
    }// </editor-fold>//GEN-END:initComponents

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
    }

    /**
     *
     * @return
     */
    @Override
    public TYPE getType() {
        return TYPE.Plugin;
        //  return IChartDocument.TYPE.DoPanel;
    }

    /**
     *
     * @return
     */
    @Override
    public String getTitle() {
        return TITLE;
    }

    /**
     *
     * @return
     */
    @Override
    public IChart getParentContext() {
        return parent;
    }

    private DefaultMutableTreeNode findNode(DefaultMutableTreeNode root, DoBodyObject record) {

        Enumeration<DefaultMutableTreeNode> e;
        DefaultMutableTreeNode currentNode = null;
        for (e = root.children(); e.hasMoreElements();) {
            currentNode = e.nextElement();
            String key = ((DoHeaderObject) (currentNode.getUserObject())).getKey();
            String key2 = ((DoHeaderObject) (record)).getKey();
            if (key.equals(key2)) {
                return currentNode;
            }
        }
        return null;
    }

    private void addNode(DefaultMutableTreeNode node, DoBodyObject record) {
        if (record.valid()) {
            DefaultMutableTreeNode newLeaf = new DefaultMutableTreeNode();
            newLeaf.setUserObject(record);
            node.add(newLeaf);
        }
    }

    /**
     *
     */
    @Override
    public void start() {
        List<DoBodyObject> result = null;
        DoMasterDao dao = (DoMasterDao) create("dao.master");
        result = dao.get_TBL_SRYACT(patientID);
        for (DoBodyObject record : result) {
            DefaultMutableTreeNode currentNode = findNode(root, record);
            if (currentNode == null) {
                DefaultMutableTreeNode newNode = new DefaultMutableTreeNode();
                newNode.setUserObject(record.toDoHeaderObject());
                root.add(newNode);

                addNode(newNode, record);
            } else {
                addNode(currentNode, record);
            }
        }
    }

    /**
     *
     */
    @Override
    public void stop() {
    }

    /**
     *
     */
    @Override
    public void enter() {
    }

    /**
     *
     * @return
     */
    @Override
    public boolean prepare() {
        return true;
    }

    /**
     * 
     * @return
     */
    @Override
    public boolean isDirty() {
        return dirty;
    }

    /**
     *
     * @param dirty
     */
    @Override
    public void setDirty(boolean dirty) {
        this.dirty = dirty;
    }

    /**
     *
     * @return
     */
    @Override
    public boolean itLayoutSaved() {
        return true;
    }

    /**
     *
     * @return
     */
    @Override
    public List<JTabbedPane> getTabbedPanels() {
        return null;
    }

    /**
     *
     * @param o
     * @return
     */
    @Override
    public boolean update(Object o) {
        return true;
    }

    /**
     *
     * @param command
     * @return
     */
    @Override
    public boolean dispatchChartCommand(ChartCommand command) {
        return false;
    }

    /**
     * Creates DataAccessObject
     * @param keyString 
     * @return
     */
    public static DoMasterDao create(String keyString) {
        DoMasterDao result = null;
        try {
            result = new open.dolphin.plugin.DoMasterDao();
            result.setDriver("org.postgresql.Driver");
            //     if (keyString.equals("dao.master")) {

            if (GlobalSettings.isTrial()) {
                result.setHost("dolphin.good-day.co.jp");
                result.setPort(10329);
            } else {
                result.setHost(GlobalVariables.getClaimAddress());
                result.setPort(5432);
            }

            result.setDatabase("orca");
            result.setUser("orca");
            result.setPasswd("");
            //     } else {
            //         dao.setHost(GlobalVariables.getDbAddress());
            //         dao.setPort(5432);
            //         dao.setDatabase("dolphin");
            //         dao.setUser("dolphin");
            //         dao.setPasswd("");
            //      }
        } catch (Exception e) {
            LogWriter.error("DoPanel", "create");
        }
        return result;
    }
    // Variables declaration - do not modify//GEN-BEGIN:variables
    private javax.swing.JComboBox jComboBox1;
    private javax.swing.JComboBox jComboBox2;
    private javax.swing.JScrollPane jScrollPane1;
    private javax.swing.JTree tree;
    // End of variables declaration//GEN-END:variables
}
