/*
 * Decompiled with CFR 0.152.
 */
package open.dolphin.client;

import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.Rectangle;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.TooManyListenersException;
import java.util.prefs.Preferences;
import javax.swing.BoxLayout;
import javax.swing.GroupLayout;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import open.dolphin.client.ChartMediator;
import open.dolphin.client.ChartWindow;
import open.dolphin.client.EditorFrame;
import open.dolphin.client.IChart;
import open.dolphin.client.IChartDocument;
import open.dolphin.client.IDocumentViewer;
import open.dolphin.client.IKarteViewer;
import open.dolphin.client.KarteEditor;
import open.dolphin.client.KarteViewerDouble;
import open.dolphin.client.KarteViewerSingle;
import open.dolphin.client.NewKarteParams;
import open.dolphin.client.karte.DocumentHistoryPanel;
import open.dolphin.delegater.remote.RemoteDocumentDelegater;
import open.dolphin.helper.DBTask;
import open.dolphin.helper.IChartCommandAccepter;
import open.dolphin.helper.IMainCommandAccepter;
import open.dolphin.infomodel.DocInfoModel;
import open.dolphin.infomodel.DocumentModel;
import open.dolphin.project.GlobalConstants;
import open.dolphin.project.GlobalVariables;
import org.jdesktop.application.Application;
import org.jdesktop.application.ApplicationContext;
import org.jdesktop.application.TaskMonitor;
import org.jdesktop.application.TaskService;

public class KarteDocumentViewer
extends JPanel
implements IDocumentViewer,
IChartCommandAccepter,
IMainCommandAccepter {
    public static final String BUSY_PROP = "busyProp";
    private static final String TITLE_UPDATE = "\u66f4\u65b0";
    private static final String TITLE = "\u53c2 \u7167";
    private List<IKarteViewer> karteList;
    private IKarteViewer selectedKarte;
    private boolean busy;
    private boolean ascending;
    private StateMgr stateMgr;
    private List<IKarteViewer> removed;
    private JPanel scrollerPanel;
    private static final String[] CHART_MENUS = new String[]{"openKarte", "save", "direction", "delete", "print", "modifyKarte", "ascending", "descending", "showModified", "showUnsend", "showSend", "showNewest", "insertText", "insertSchema", "insertStamp", "selectInsurance", "cut", "copy", "paste", "undo", "redo"};
    private IChart parent;
    private String title;
    private boolean dirty;
    protected Application app;
    protected ApplicationContext appCtx;
    protected TaskMonitor taskMonitor;
    protected TaskService taskService;
    private KarteEditor editor;

    public KarteDocumentViewer(IChart parent) {
        this.parent = parent;
        this.title = TITLE;
        this.initComponents();
        this.appCtx = GlobalConstants.getApplicationContext();
        this.app = this.appCtx.getApplication();
        this.taskMonitor = this.appCtx.getTaskMonitor();
        this.taskService = this.appCtx.getTaskService();
    }

    private void initComponents() {
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 400, Short.MAX_VALUE));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 300, Short.MAX_VALUE));
    }

    @Override
    public IChartDocument.TYPE getType() {
        return IChartDocument.TYPE.KarteDocumentViewer;
    }

    public boolean isBusy() {
        return this.busy;
    }

    @Override
    public void start() {
        this.karteList = new ArrayList<IKarteViewer>(1);
        this.stateMgr = new StateMgr();
        this.connect();
        this.enter();
    }

    @Override
    public void stop() {
        if (this.karteList != null) {
            for (IKarteViewer karte : this.karteList) {
                karte.stop();
            }
            this.karteList.clear();
        }
    }

    @Override
    public void enter() {
        this.parent.getStatusPanel().setMessage("");
        this.parent.getChartMediator().setAccepter(this);
        this.disableMenus();
        this.parent.enabledAction("newKarte", true);
        this.parent.enabledAction("newDocument", true);
        this.parent.enabledAction("addUser", GlobalVariables.isAdmin());
        this.stateMgr.enter();
    }

    public IKarteViewer getSelectedKarte() {
        return this.selectedKarte;
    }

    public void setSelectedKarte(IKarteViewer view) {
        IKarteViewer old = this.selectedKarte;
        this.selectedKarte = view;
        if (this.selectedKarte != old) {
            if (this.selectedKarte != null) {
                for (IKarteViewer karte : this.karteList) {
                    karte.setSelected(false);
                }
                this.selectedKarte.setSelected(true);
                this.stateMgr.processCleanEvent();
            } else {
                this.stateMgr.processEmptyEvent();
            }
        }
    }

    public IKarteViewer getBaseKarte() {
        IKarteViewer ret = this.getSelectedKarte();
        if (ret == null && this.karteList != null && this.karteList.size() > 0) {
            ret = this.ascending ? this.karteList.get(this.karteList.size() - 1) : this.karteList.get(0);
        }
        return ret;
    }

    @Override
    public void historyPeriodChanged() {
        if (this.karteList != null) {
            this.karteList.clear();
        }
        this.setSelectedKarte(null);
        this.parent.showDocument(TITLE);
    }

    private void connect() {
        DocumentHistoryPanel panel = this.parent.getDocumentHistory();
        this.ascending = panel.isAscending();
        this.parent.getDocumentHistory().setShowModified(GlobalVariables.getShowModifiedKarte(), false);
        this.parent.getDocumentHistory().setShowUnsend(GlobalVariables.getShowUnsendKarte(), false);
        this.parent.getDocumentHistory().setShowSend(GlobalVariables.getShowSendKarte(), false);
        this.parent.getDocumentHistory().setShowNewest(GlobalVariables.getShowNewestKarte());
    }

    @Override
    public void showDocuments(DocInfoModel[] selectedHistories, JScrollPane scroller) {
        if (selectedHistories == null || selectedHistories.length == 0) {
            return;
        }
        ArrayList<DocInfoModel> added = new ArrayList<DocInfoModel>(1);
        if (this.removed == null) {
            this.removed = new ArrayList<IKarteViewer>(1);
        } else {
            this.removed.clear();
        }
        for (DocInfoModel selectedDocInfo : selectedHistories) {
            boolean found = false;
            for (IKarteViewer viewer : this.karteList) {
                if (!viewer.getModel().getDocInfo().equals(selectedDocInfo)) continue;
                found = true;
                break;
            }
            if (found) continue;
            added.add(selectedDocInfo);
        }
        for (IKarteViewer viewer : this.karteList) {
            boolean found = false;
            for (DocInfoModel selectedDocInfo : selectedHistories) {
                if (!viewer.getModel().getDocInfo().equals(selectedDocInfo)) continue;
                found = true;
                break;
            }
            if (found) continue;
            this.removed.add(viewer);
        }
        if (this.removed != null && this.removed.size() > 0) {
            for (IKarteViewer karte : this.removed) {
                this.karteList.remove(karte);
            }
        }
        if (added == null || added.isEmpty()) {
            boolean vsc = GlobalVariables.getScrollKarteV();
            if (this.scrollerPanel != null) {
                this.scrollerPanel.removeAll();
            }
            this.scrollerPanel = new JPanel();
            if (vsc) {
                this.scrollerPanel.setLayout(new BoxLayout(this.scrollerPanel, 1));
            } else {
                this.scrollerPanel.setLayout(new BoxLayout(this.scrollerPanel, 0));
            }
            for (IKarteViewer view : this.karteList) {
                this.scrollerPanel.add((JPanel)((Object)view));
            }
            scroller.setViewportView(this.scrollerPanel);
            if (vsc) {
                this.showKarteListV();
            } else {
                this.showKarteListH();
            }
            return;
        }
        ArrayList<Long> docId = new ArrayList<Long>(added.size());
        for (DocInfoModel bean : added) {
            docId.add(new Long(bean.getDocPk()));
        }
        RemoteDocumentDelegater ddl = new RemoteDocumentDelegater();
        KarteTask task = new KarteTask(this.parent, docId, added, ddl, scroller);
        task.execute();
    }

    private IKarteViewer createKarteViewer(DocInfoModel docInfo) {
        if (docInfo != null && docInfo.getDocType().equals("s_karte")) {
            return new KarteViewerSingle(this.parent);
        }
        return new KarteViewerDouble(this.parent);
    }

    private void addKarteViewer(List<DocumentModel> models, List<DocInfoModel> docInfos, JScrollPane scroller) {
        if (models != null) {
            int index = 0;
            for (DocumentModel karteModel : models) {
                karteModel.setDocInfo(docInfos.get(index++));
                final IKarteViewer karteViewer = this.createKarteViewer(karteModel.getDocInfo());
                karteViewer.setModel(karteModel);
                karteViewer.setAvoidEnter(true);
                karteViewer.start();
                if (karteModel.getDocInfo().getDocType().equals("karte")) {
                    MouseAdapter ml = new MouseAdapter(){

                        @Override
                        public void mouseClicked(MouseEvent e) {
                            int cnt = e.getClickCount();
                            if (cnt == 2) {
                                KarteDocumentViewer.this.setSelectedKarte(karteViewer);
                                KarteDocumentViewer.this.openKarte();
                            } else if (cnt == 1) {
                                KarteDocumentViewer.this.setSelectedKarte(karteViewer);
                            }
                        }
                    };
                    karteViewer.addMouseListener(ml);
                }
                this.karteList.add(karteViewer);
            }
            if (this.ascending) {
                Collections.sort(this.karteList);
            } else {
                Collections.sort(this.karteList, Collections.reverseOrder());
            }
            if (this.karteList.size() > 0) {
                if (this.ascending) {
                    this.setSelectedKarte(this.karteList.get(this.karteList.size() - 1));
                } else {
                    this.setSelectedKarte(this.karteList.get(0));
                }
            }
        }
        boolean vsc = GlobalVariables.getScrollKarteV();
        if (this.scrollerPanel != null) {
            this.scrollerPanel.removeAll();
        }
        this.scrollerPanel = new JPanel();
        if (vsc) {
            this.scrollerPanel.setLayout(new BoxLayout(this.scrollerPanel, 1));
        } else {
            this.scrollerPanel.setLayout(new BoxLayout(this.scrollerPanel, 0));
        }
        for (IKarteViewer view : this.karteList) {
            this.scrollerPanel.add((JPanel)((Object)view));
        }
        scroller.setViewportView(this.scrollerPanel);
        if (vsc) {
            this.showKarteListV();
        } else {
            this.showKarteListH();
        }
    }

    private void showKarteListV() {
        Runnable awt = new Runnable(){

            @Override
            public void run() {
                if (KarteDocumentViewer.this.karteList.size() > 1) {
                    int totalHeight = 0;
                    for (IKarteViewer view : KarteDocumentViewer.this.karteList) {
                        int w = ((JPanel)((Object)view)).getPreferredSize().width;
                        int h = view.getActualHeight() + 30;
                        totalHeight += h;
                        ((JPanel)((Object)view)).setPreferredSize(new Dimension(w, h));
                    }
                    int spWidth = ((KarteDocumentViewer)KarteDocumentViewer.this).scrollerPanel.getPreferredSize().width;
                    KarteDocumentViewer.this.scrollerPanel.setPreferredSize(new Dimension(spWidth, totalHeight));
                }
                KarteDocumentViewer.this.scrollerPanel.scrollRectToVisible(new Rectangle(0, 0, KarteDocumentViewer.this.scrollerPanel.getWidth(), 100));
                if (KarteDocumentViewer.this.removed != null) {
                    for (IKarteViewer karte : KarteDocumentViewer.this.removed) {
                        karte.stop();
                    }
                    KarteDocumentViewer.this.removed.clear();
                }
            }
        };
        EventQueue.invokeLater(awt);
    }

    private void showKarteListH() {
        Runnable awt = new Runnable(){

            @Override
            public void run() {
                if (KarteDocumentViewer.this.karteList.size() > 1) {
                    int maxHeight = 0;
                    for (IKarteViewer view : KarteDocumentViewer.this.karteList) {
                        int w = ((JPanel)((Object)view)).getPreferredSize().width;
                        int h = view.getActualHeight() + 20;
                        maxHeight = maxHeight >= h ? maxHeight : h;
                        ((JPanel)((Object)view)).setPreferredSize(new Dimension(w, h));
                    }
                    int spWidth = ((KarteDocumentViewer)KarteDocumentViewer.this).scrollerPanel.getPreferredSize().width;
                    KarteDocumentViewer.this.scrollerPanel.setPreferredSize(new Dimension(spWidth, maxHeight));
                }
                KarteDocumentViewer.this.scrollerPanel.scrollRectToVisible(new Rectangle(0, 0, KarteDocumentViewer.this.scrollerPanel.getWidth(), 100));
                KarteDocumentViewer.this.parent.showDocument(KarteDocumentViewer.TITLE);
                if (KarteDocumentViewer.this.removed != null) {
                    for (IKarteViewer karte : KarteDocumentViewer.this.removed) {
                        karte.stop();
                    }
                    KarteDocumentViewer.this.removed.clear();
                }
            }
        };
        EventQueue.invokeLater(awt);
    }

    public boolean dispatchMainCommand(IMainCommandAccepter.MainCommand command) {
        switch (command) {
            case openKarte: {
                return this.openKarte();
            }
        }
        return false;
    }

    public boolean dispatchChartCommand(IChartCommandAccepter.ChartCommand command) {
        try {
            switch (command) {
                case modifyKarte: {
                    return this.modifyKarte();
                }
                case delete: {
                    return this.delete();
                }
                case print: {
                    return this.print();
                }
                case showModified: {
                    return this.showModified();
                }
                case hideModified: {
                    return this.hideModified();
                }
                case showUnsend: {
                    return this.showUnsend();
                }
                case hideUnsend: {
                    return this.hideUnsend();
                }
                case showSend: {
                    return this.showSend();
                }
                case hideSend: {
                    return this.hideSend();
                }
                case showNewest: {
                    return this.showNewest();
                }
                case hideNewest: {
                    return this.hideNewest();
                }
                case ascending: {
                    return this.ascending();
                }
                case descending: {
                    return this.descending();
                }
            }
        }
        catch (TooManyListenersException tooManyListenersException) {
            // empty catch block
        }
        return false;
    }

    private boolean modifyKarte() throws TooManyListenersException {
        if (this.getBaseKarte() == null) {
            return true;
        }
        this.parent.enabledAction("newKarte", false);
        String docType = this.getBaseKarte().getModel().getDocInfo().getDocType();
        ChartWindow chart = (ChartWindow)this.parent;
        String dept = this.parent.getPatientVisit().getDepartment();
        String deptCode = this.parent.getPatientVisit().getDepartmentCode();
        Preferences prefs = GlobalVariables.getPreferences();
        NewKarteParams params = new NewKarteParams(IChart.NewKarteOption.BROWSER_MODIFY);
        params.setDocType(docType);
        params.setDepartment(dept);
        params.setDepartmentCode(deptCode);
        params.setOpenFrame(prefs.getBoolean("karte.placeMode", true));
        DocumentModel editModel = chart.getKarteModelToEdit(this.getBaseKarte().getModel());
        int mode = docType.equals("karte") ? 2 : 1;
        this.editor = chart.createEditor(params.isOpenFrame(), editModel, this.parent, true, mode);
        this.editor.setModify(true);
        if (mode == 1) {
            params.setOpenFrame(false);
        }
        if (params.isOpenFrame()) {
            EditorFrame editorFrame = new EditorFrame(this.parent, this.editor);
            editorFrame.start();
        } else if (!chart.existEditorPane(2)) {
            this.editor.initialize();
            this.editor.start();
            chart.addChartDocument((IChartDocument)this.editor, TITLE_UPDATE);
        }
        return true;
    }

    private boolean print() {
        IKarteViewer view = this.getSelectedKarte();
        if (view != null) {
            view.dispatchChartCommand(IChartCommandAccepter.ChartCommand.print);
        }
        return true;
    }

    private boolean ascending() {
        this.ascending = true;
        this.parent.getDocumentHistory().setAscending(this.ascending);
        return true;
    }

    private boolean descending() {
        this.ascending = false;
        this.parent.getDocumentHistory().setAscending(this.ascending);
        return true;
    }

    private boolean showModified() {
        this.parent.getDocumentHistory().setShowModified(true);
        return true;
    }

    private boolean hideModified() {
        this.parent.getDocumentHistory().setShowModified(false);
        return true;
    }

    private boolean showUnsend() {
        this.parent.getDocumentHistory().setShowUnsend(true);
        return true;
    }

    private boolean hideUnsend() {
        this.parent.getDocumentHistory().setShowUnsend(false);
        return true;
    }

    private boolean showSend() {
        this.parent.getDocumentHistory().setShowSend(true);
        return true;
    }

    private boolean hideSend() {
        this.parent.getDocumentHistory().setShowSend(false);
        return true;
    }

    private boolean showNewest() {
        this.parent.getDocumentHistory().setShowNewest(true);
        return true;
    }

    private boolean hideNewest() {
        this.parent.getDocumentHistory().setShowNewest(false);
        return true;
    }

    private boolean openKarte() {
        if (this.getSelectedKarte() != null) {
            EditorFrame editorFrame = new EditorFrame(this.parent, null);
            DocumentModel model = this.getSelectedKarte().getModel();
            String docType = model.getDocInfo().getDocType();
            if (docType.equals("s_karte")) {
                KarteViewerSingle view = new KarteViewerSingle(this.parent);
                view.setModel(model);
                editorFrame.setKarteViewer(view);
                editorFrame.start();
            } else if (docType.equals("karte")) {
                KarteViewerDouble view = new KarteViewerDouble(this.parent);
                view.setModel(model);
                editorFrame.setKarteViewer(view);
                editorFrame.start();
            }
        }
        return true;
    }

    private boolean delete() {
        IKarteViewer delete = this.getBaseKarte();
        if (delete == null) {
            return true;
        }
        String message = "\u3053\u306e\u30c9\u30ad\u30e5\u30e1\u30f3\u30c8\u3092\u524a\u9664\u3057\u307e\u3059\u304b ?   ";
        final JCheckBox box1 = new JCheckBox("\u4f5c\u6210\u30df\u30b9");
        final JCheckBox box2 = new JCheckBox("\u8a3a\u5bdf\u30ad\u30e3\u30f3\u30bb\u30eb");
        final JCheckBox box3 = new JCheckBox("\u305d\u306e\u4ed6");
        box1.setSelected(true);
        ActionListener al = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (box1.isSelected() || box2.isSelected()) {
                    return;
                }
                if (!box3.isSelected()) {
                    box3.setSelected(true);
                }
            }
        };
        box1.addActionListener(al);
        box2.addActionListener(al);
        box3.addActionListener(al);
        Object[] msg = new Object[]{message, box1, box2, box3, new JLabel(" ")};
        String deleteText = "\u524a\u9664\u3059\u308b";
        String cancelText = (String)UIManager.get("OptionPane.cancelButtonText");
        int option = JOptionPane.showOptionDialog(this, msg, GlobalConstants.getFrameTitle("\u30c9\u30ad\u30e5\u30e1\u30f3\u30c8\u524a\u9664"), -1, 2, null, new String[]{deleteText, cancelText}, cancelText);
        if (option != 0) {
            return true;
        }
        long deletePk = delete.getModel().getId();
        RemoteDocumentDelegater ddl = new RemoteDocumentDelegater();
        DeleteTask task = new DeleteTask(this.parent, deletePk, ddl);
        task.execute();
        return true;
    }

    @Override
    public boolean itLayoutSaved() {
        return true;
    }

    @Override
    public String getTitle() {
        return this.title;
    }

    @Override
    public IChart getParentContext() {
        return this.parent;
    }

    @Override
    public boolean prepare() {
        return true;
    }

    @Override
    public boolean isDirty() {
        return this.dirty;
    }

    @Override
    public void setDirty(boolean dirty) {
        this.dirty = dirty;
    }

    public boolean isReadOnly() {
        return this.parent.isReadOnly();
    }

    public void disableMenus() {
        ChartMediator mediator = this.parent.getChartMediator();
        mediator.disableMenus(CHART_MENUS);
    }

    protected void warning(String title, String message) {
        Window parent = SwingUtilities.getWindowAncestor(this);
        JOptionPane.showMessageDialog(parent, message, GlobalConstants.getFrameTitle(title), 2);
    }

    @Override
    public List<JTabbedPane> getTabbedPanels() {
        return null;
    }

    @Override
    public boolean update(Object o) {
        return true;
    }

    protected final class StateMgr {
        private BrowserState emptyState;
        private BrowserState cleanState;
        private BrowserState currentState;

        public StateMgr() {
            this.emptyState = new EmptyState();
            this.cleanState = new ClaenState();
            this.currentState = this.emptyState;
        }

        public void processEmptyEvent() {
            this.currentState = this.emptyState;
            this.enter();
        }

        public void processCleanEvent() {
            this.currentState = this.cleanState;
            this.enter();
        }

        public void enter() {
            this.currentState.enter();
        }
    }

    protected final class ClaenState
    extends BrowserState {
        @Override
        public void enter() {
            String state2;
            boolean canEdit = !KarteDocumentViewer.this.isReadOnly();
            boolean tmpKarte = false;
            IKarteViewer base = KarteDocumentViewer.this.getBaseKarte();
            if (base != null && (state2 = base.getModel().getDocInfo().getStatus()).equals("T")) {
                tmpKarte = true;
            }
            boolean newOk = canEdit && !tmpKarte;
            KarteDocumentViewer.this.parent.enabledAction("newKarte", true);
            KarteDocumentViewer.this.parent.enabledAction("newDocument", canEdit);
            KarteDocumentViewer.this.parent.enabledAction("modifyKarte", canEdit);
            KarteDocumentViewer.this.parent.enabledAction("delete", canEdit);
            KarteDocumentViewer.this.parent.enabledAction("print", true);
            KarteDocumentViewer.this.parent.enabledAction("ascending", true);
            KarteDocumentViewer.this.parent.enabledAction("descending", true);
            KarteDocumentViewer.this.parent.enabledAction("showModified", true);
            KarteDocumentViewer.this.parent.enabledAction("showUnsend", true);
            KarteDocumentViewer.this.parent.enabledAction("showSend", true);
            KarteDocumentViewer.this.parent.enabledAction("showNewest", true);
        }
    }

    protected final class EmptyState
    extends BrowserState {
        @Override
        public void enter() {
            KarteDocumentViewer.this.parent.enabledAction("newKarte", true);
            KarteDocumentViewer.this.parent.enabledAction("modifyKarte", false);
            KarteDocumentViewer.this.parent.enabledAction("delete", false);
            KarteDocumentViewer.this.parent.enabledAction("print", false);
            KarteDocumentViewer.this.parent.enabledAction("addUser", GlobalVariables.isAdmin());
        }
    }

    protected abstract class BrowserState {
        public abstract void enter();
    }

    class DeleteTask
    extends DBTask<Boolean> {
        private RemoteDocumentDelegater ddl;
        private long docPk;

        public DeleteTask(IChart ctx, long docPk, RemoteDocumentDelegater ddl) {
            super(ctx);
            this.docPk = docPk;
            this.ddl = ddl;
        }

        protected Boolean doInBackground() throws Exception {
            this.ddl.deleteDocument(this.docPk);
            return !this.ddl.isError();
        }

        protected void succeeded(Boolean result) {
            if (result.booleanValue()) {
                IChart chart = KarteDocumentViewer.this.parent;
                chart.getDocumentHistory().getDocumentHistory();
            } else {
                KarteDocumentViewer.this.warning("\u30c9\u30ad\u30e5\u30e1\u30f3\u30c8\u524a\u9664", this.ddl.getErrorMessage());
            }
        }
    }

    class KarteTask
    extends DBTask<List<DocumentModel>> {
        private RemoteDocumentDelegater ddl;
        private List<Long> docId;
        private List<DocInfoModel> docInfos;
        private JScrollPane scroller;

        public KarteTask(IChart ctx, List<Long> docId, List<DocInfoModel> docInfos, RemoteDocumentDelegater ddl, JScrollPane scroller) {
            super(ctx);
            this.docId = docId;
            this.ddl = ddl;
            this.docInfos = docInfos;
            this.scroller = scroller;
        }

        protected List<DocumentModel> doInBackground() {
            List result = this.ddl.getDocuments(this.docId);
            if (!this.ddl.isError()) {
                return result;
            }
            return null;
        }

        protected void succeeded(List<DocumentModel> list) {
            if (list != null) {
                KarteDocumentViewer.this.addKarteViewer(list, this.docInfos, this.scroller);
            }
        }
    }
}

