/*
 * Decompiled with CFR 0.152.
 */
package open.dolphin.client;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.im.InputSubset;
import java.util.Set;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import open.dolphin.client.RegexConstrainedDocument;
import open.dolphin.delegater.remote.RemoteUserDelegater;
import open.dolphin.helper.ComponentMemory;
import open.dolphin.infomodel.DepartmentModel;
import open.dolphin.infomodel.LicenseModel;
import open.dolphin.infomodel.RoleModel;
import open.dolphin.infomodel.UserModel;
import open.dolphin.log.LogWriter;
import open.dolphin.project.DolphinPrincipal;
import open.dolphin.project.GlobalConstants;
import open.dolphin.project.GlobalVariables;
import open.dolphin.security.EncryptUtil;

public class ProfileDialog
extends JDialog {
    private static final String TITLE = "\u30d7\u30ed\u30d5\u30a3\u30fc\u30eb\u5909\u66f4";
    private static int DEFAULT_WIDTH = 568;
    private static int DEFAULT_HEIGHT = 300;
    private static final String PROGRESS_NOTE = "\u30e6\u30fc\u30b6\u60c5\u5831\u3092\u5909\u66f4\u3057\u3066\u3044\u307e\u3059...";
    private static final String UPDATE_BTN_TEXT = "\u5909\u66f4";
    private static final String CLOSE_BTN_TEXT = "\u9589\u3058\u308b";
    private static final String USER_ID_TEXT = "\u30e6\u30fc\u30b6ID:";
    private static final String PASSWORD_TEXT = "\u30d1\u30b9\u30ef\u30fc\u30c9:";
    private static final String CONFIRM_TEXT = "\u78ba\u8a8d:";
    private static final String SIR_NAME_TEXT = "\u59d3:";
    private static final String GIVEN_NAME_TEXT = "\u540d:";
    private static final String EMAIL_TEXT = "\u96fb\u5b50\u30e1\u30fc\u30eb:";
    private static final String LISENCE_TEXT = "\u533b\u7642\u8cc7\u683c:";
    private static final String DEPT_TEXT = "\u8a3a\u7642\u79d1:";
    private static final String PASSWORD_ASSIST_1 = "\u30d1\u30b9\u30ef\u30fc\u30c9(\u534a\u89d2\u82f1\u6570\u3067";
    private static final String PASSWORD_ASSIST_2 = "\u6587\u5b57\u4ee5\u4e0a";
    private static final String PASSWORD_ASSIST_3 = "\u6587\u5b57\u4ee5\u5185) \u5909\u66f4\u3057\u306a\u3044\u5834\u5408\u306f\u7a7a\u767d\u306b\u3057\u3066\u304a\u304d\u307e\u3059\u3002";
    private static final String SUCCESS_MESSAGE = "\u30e6\u30fc\u30b6\u60c5\u5831\u3092\u5909\u66f4\u3057\u307e\u3057\u305f\u3002";
    private static final String ERROR_MESSAGE = "\u30e6\u30fc\u30b6\u60c5\u5831\u306e\u5909\u66f4\u306b\u5931\u6557\u3057\u307e\u3057\u305f\u3002";
    private static final String DUMMY_PASSWORD = "";
    private JDialog dialog;
    protected JButton okButton;

    public ProfileDialog() {
        this.setName(TITLE);
    }

    public void start() {
        String title = GlobalConstants.getFrameTitle(this.getName());
        this.dialog = this;
        this.setTitle(title);
        this.setModal(true);
        ImageIcon icon = GlobalConstants.getImageIcon("web_32.gif");
        this.setIconImage(icon.getImage());
        this.setDefaultCloseOperation(0);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                ProfileDialog.this.stop();
            }
        });
        ComponentMemory cm = new ComponentMemory((Component)this, new Point(0, 0), new Dimension(new Dimension(DEFAULT_WIDTH, DEFAULT_HEIGHT)), (Object)this);
        cm.putCenter();
        ProfilePanel cp = new ProfilePanel();
        cp.get();
        this.getContentPane().add((Component)cp, "Center");
        this.getRootPane().setDefaultButton(this.okButton);
        this.setVisible(true);
    }

    public void stop() {
        this.setVisible(false);
        this.dispose();
    }

    private JTextField createTextField(int val, Insets margin, FocusAdapter fa, DocumentListener dl) {
        if (val == 0) {
            val = 30;
        }
        JTextField tf = new JTextField(val);
        if (margin == null) {
            margin = new Insets(1, 2, 1, 2);
        }
        tf.setMargin(margin);
        if (dl != null) {
            tf.getDocument().addDocumentListener(dl);
        }
        if (fa != null) {
            tf.addFocusListener(fa);
        }
        return tf;
    }

    private JPasswordField createPassField(int val, Insets margin, FocusAdapter fa, DocumentListener dl) {
        if (val == 0) {
            val = 30;
        }
        JPasswordField tf = new JPasswordField(val);
        if (margin == null) {
            margin = new Insets(1, 2, 1, 2);
        }
        tf.setMargin(margin);
        if (dl != null) {
            tf.getDocument().addDocumentListener(dl);
        }
        if (fa != null) {
            tf.addFocusListener(fa);
        }
        return tf;
    }

    private void constrain(JPanel container, Component cmp, int x, int y, int width, int height, int fill, int anchor) {
        GridBagConstraints c = new GridBagConstraints();
        c.gridx = x;
        c.gridy = y;
        c.gridwidth = width;
        c.gridheight = height;
        c.fill = fill;
        c.anchor = anchor;
        c.insets = new Insets(0, 0, 5, 7);
        ((GridBagLayout)container.getLayout()).setConstraints(cmp, c);
        container.add(cmp);
    }

    protected class ProfilePanel
    extends JPanel {
        private JTextField uid;
        private JPasswordField userPassword1;
        private JPasswordField userPassword2;
        private JTextField sn;
        private JTextField givenName;
        private JTextField email;
        private LicenseModel[] licenses;
        private JComboBox licenseCombo;
        private DepartmentModel[] depts;
        private JComboBox deptCombo;
        private JButton okButton;
        private JButton cancelButton;
        private boolean ok;
        private int[] userIdLength = GlobalConstants.getIntArray("addUser.userId.length");
        private int[] passwordLength = GlobalConstants.getIntArray("addUser.password.length");

        public ProfilePanel() {
            FocusAdapter imeOn = new FocusAdapter(){

                @Override
                public void focusGained(FocusEvent event) {
                    JTextField tf = (JTextField)event.getSource();
                    tf.getInputContext().setCharacterSubsets(new Character.Subset[]{InputSubset.KANJI});
                }
            };
            FocusAdapter imeOff = new FocusAdapter(){

                @Override
                public void focusGained(FocusEvent event) {
                    JTextField tf = (JTextField)event.getSource();
                    tf.getInputContext().setCharacterSubsets(null);
                }
            };
            DocumentListener dl = new DocumentListener(){

                @Override
                public void changedUpdate(DocumentEvent e) {
                }

                @Override
                public void insertUpdate(DocumentEvent e) {
                    ProfilePanel.this.checkButton();
                }

                @Override
                public void removeUpdate(DocumentEvent e) {
                    ProfilePanel.this.checkButton();
                }
            };
            this.uid = ProfileDialog.this.createTextField(10, null, imeOff, null);
            String pattern = "[A-Za-z0-9_+\\-.#$&@]*";
            RegexConstrainedDocument userIdDoc = new RegexConstrainedDocument(pattern);
            this.uid.setEditable(false);
            this.uid.setDocument(userIdDoc);
            this.uid.getDocument().addDocumentListener(dl);
            this.userPassword1 = ProfileDialog.this.createPassField(10, null, imeOff, null);
            this.userPassword1.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    ProfilePanel.this.userPassword2.requestFocus();
                }
            });
            this.userPassword2 = ProfileDialog.this.createPassField(10, null, imeOff, null);
            this.userPassword2.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    ProfilePanel.this.sn.requestFocus();
                }
            });
            RegexConstrainedDocument passwordDoc1 = new RegexConstrainedDocument(pattern);
            this.userPassword1.setDocument(passwordDoc1);
            this.userPassword1.setToolTipText(pattern);
            this.userPassword1.getDocument().addDocumentListener(dl);
            RegexConstrainedDocument passwordDoc2 = new RegexConstrainedDocument(pattern);
            this.userPassword2.setDocument(passwordDoc2);
            this.userPassword2.getDocument().addDocumentListener(dl);
            this.userPassword2.setToolTipText(pattern);
            this.sn = ProfileDialog.this.createTextField(10, null, imeOn, dl);
            this.sn.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    ProfilePanel.this.givenName.requestFocus();
                }
            });
            this.givenName = ProfileDialog.this.createTextField(10, null, imeOn, dl);
            this.givenName.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    ProfilePanel.this.userPassword1.requestFocus();
                }
            });
            this.email = ProfileDialog.this.createTextField(20, null, imeOff, null);
            pattern = "[A-Za-z0-9_\\-.@]*";
            RegexConstrainedDocument emailDoc = new RegexConstrainedDocument(pattern);
            this.email.setDocument(emailDoc);
            this.email.getDocument().addDocumentListener(dl);
            this.licenses = GlobalConstants.getLicenseModel();
            this.licenseCombo = new JComboBox<LicenseModel>(this.licenses);
            boolean readOnly = GlobalVariables.isReadOnly();
            this.licenseCombo.setEnabled(!readOnly);
            this.depts = GlobalConstants.getDepartmentModel();
            this.deptCombo = new JComboBox<DepartmentModel>(this.depts);
            this.deptCombo.setEnabled(true);
            ActionListener al = new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    ProfilePanel.this.changePassword();
                }
            };
            this.okButton = new JButton(ProfileDialog.UPDATE_BTN_TEXT);
            this.okButton.addActionListener(al);
            this.okButton.setEnabled(false);
            this.cancelButton = new JButton(ProfileDialog.CLOSE_BTN_TEXT);
            this.cancelButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    ProfileDialog.this.stop();
                }
            });
            JPanel content = new JPanel(new GridBagLayout());
            int x = 0;
            int y = 0;
            JLabel label = new JLabel(ProfileDialog.USER_ID_TEXT, 4);
            ProfileDialog.this.constrain(content, label, x, y, 1, 1, 0, 13);
            ProfileDialog.this.constrain(content, this.uid, x + 1, y, 1, 1, 0, 17);
            x = 0;
            label = new JLabel(ProfileDialog.PASSWORD_TEXT, 4);
            ProfileDialog.this.constrain(content, label, x, ++y, 1, 1, 0, 13);
            ProfileDialog.this.constrain(content, this.userPassword1, x + 1, y, 1, 1, 0, 17);
            label = new JLabel(ProfileDialog.CONFIRM_TEXT, 4);
            ProfileDialog.this.constrain(content, label, x + 2, y, 1, 1, 0, 13);
            ProfileDialog.this.constrain(content, this.userPassword2, x + 3, y, 1, 1, 0, 17);
            x = 0;
            label = new JLabel(ProfileDialog.SIR_NAME_TEXT, 4);
            ProfileDialog.this.constrain(content, label, x, ++y, 1, 1, 0, 13);
            ProfileDialog.this.constrain(content, this.sn, x + 1, y, 1, 1, 0, 17);
            label = new JLabel(ProfileDialog.GIVEN_NAME_TEXT, 4);
            ProfileDialog.this.constrain(content, label, x + 2, y, 1, 1, 0, 13);
            ProfileDialog.this.constrain(content, this.givenName, x + 3, y, 1, 1, 0, 17);
            x = 0;
            label = new JLabel(ProfileDialog.EMAIL_TEXT, 4);
            ProfileDialog.this.constrain(content, label, x, ++y, 1, 1, 0, 13);
            ProfileDialog.this.constrain(content, this.email, x + 1, y, 2, 1, 0, 17);
            x = 0;
            label = new JLabel(ProfileDialog.LISENCE_TEXT, 4);
            ProfileDialog.this.constrain(content, label, x, ++y, 1, 1, 0, 13);
            ProfileDialog.this.constrain(content, this.licenseCombo, x + 1, y, 1, 1, 0, 17);
            label = new JLabel(ProfileDialog.DEPT_TEXT, 4);
            ProfileDialog.this.constrain(content, label, x + 2, y, 1, 1, 0, 13);
            ProfileDialog.this.constrain(content, this.deptCombo, x + 3, y, 1, 1, 0, 17);
            x = 0;
            label = new JLabel(" ", 4);
            ProfileDialog.this.constrain(content, label, x, ++y, 4, 1, 1, 13);
            x = 0;
            label = new JLabel(ProfileDialog.PASSWORD_ASSIST_1 + this.passwordLength[0] + ProfileDialog.PASSWORD_ASSIST_2 + this.passwordLength[1] + ProfileDialog.PASSWORD_ASSIST_3);
            ProfileDialog.this.constrain(content, label, x, ++y, 4, 1, 2, 13);
            JPanel btnPanel = null;
            btnPanel = GlobalConstants.isMac() ? this.createCommandButtonPanel(new JPanel(), new JButton[]{this.cancelButton, this.okButton}) : this.createCommandButtonPanel(new JPanel(), new JButton[]{this.okButton, this.cancelButton});
            this.setLayout(new BorderLayout(0, 17));
            this.add((Component)content, "Center");
            this.add((Component)btnPanel, "South");
            this.setBorder(BorderFactory.createEmptyBorder(12, 12, 11, 11));
        }

        private JPanel createCommandButtonPanel(JPanel p, JButton[] btns) {
            p.setLayout(new BoxLayout(p, 0));
            p.add(Box.createHorizontalGlue());
            p.add(btns[0]);
            for (int i = 1; i < btns.length; ++i) {
                p.add(Box.createHorizontalStrut(5));
                p.add(btns[i]);
            }
            return p;
        }

        public void get() {
            UserModel user = GlobalVariables.getUserModel();
            this.uid.setText(user.idAsLocal());
            this.sn.setText(user.getSirName());
            this.givenName.setText(user.getGivenName());
            this.userPassword1.setText(ProfileDialog.DUMMY_PASSWORD);
            this.userPassword2.setText(ProfileDialog.DUMMY_PASSWORD);
            this.email.setText(user.getEmail());
            String license = user.getLicenseModel().getLicense();
            for (int i = 0; i < this.licenses.length; ++i) {
                if (!license.equals(this.licenses[i].getLicense())) continue;
                this.licenseCombo.setSelectedIndex(i);
                break;
            }
            String deptStr = user.getDepartmentModel().getDepartment();
            for (int i = 0; i < this.depts.length; ++i) {
                if (!deptStr.equals(this.depts[i].getDepartment())) continue;
                this.deptCombo.setSelectedIndex(i);
                break;
            }
            this.checkButton();
        }

        private void changePassword() {
            if (!this.passwordOk()) {
                return;
            }
            UserModel user = GlobalVariables.getUserModel();
            UserModel updateModel = new UserModel();
            updateModel.setId(user.getId());
            updateModel.setFacility(user.getFacility());
            updateModel.setMemberType(user.getFacility().getMemberType());
            String userId = user.getFacility().getFacilityId() + ":" + this.uid.getText().trim();
            updateModel.setUserId(userId);
            String password = new String(this.userPassword1.getPassword());
            if (!password.equals(ProfileDialog.DUMMY_PASSWORD)) {
                Object charset = null;
                String hashPass = EncryptUtil.createPasswordHash(password);
                updateModel.setPassword(hashPass);
            } else {
                updateModel.setPassword(user.getPassword());
            }
            String snSt = this.sn.getText().trim();
            updateModel.setSirName(snSt);
            String givenNameSt = this.givenName.getText().trim();
            updateModel.setGivenName(givenNameSt);
            updateModel.setCommonName(snSt + " " + givenNameSt);
            updateModel.setEmail(this.email.getText().trim());
            int selected = this.licenseCombo.getSelectedIndex();
            updateModel.setLicenseModel(this.licenses[selected]);
            selected = this.deptCombo.getSelectedIndex();
            updateModel.setDepartmentModel(this.depts[selected]);
            Set<RoleModel> roles = user.getRoles();
            for (RoleModel role : roles) {
                role.setUserId(user.getUserId());
                RoleModel updateRole = new RoleModel();
                updateRole.setId(role.getId());
                updateRole.setRole(role.getRole());
                updateRole.setUser(updateModel);
                updateRole.setUserId(updateModel.getUserId());
                updateModel.addRole(updateRole);
            }
            RemoteUserDelegater udl = new RemoteUserDelegater();
            try {
                Boolean result;
                int cnt = udl.updateUser(updateModel);
                Boolean bl = result = cnt > 0 ? new Boolean(true) : new Boolean(false);
                if (!udl.isError()) {
                    GlobalVariables.setUserModel(updateModel);
                    DolphinPrincipal principal = new DolphinPrincipal();
                    principal.setUserId(updateModel.idAsLocal());
                    principal.setFacilityId(updateModel.getFacility().getFacilityId());
                    GlobalVariables.setUserId(updateModel.idAsLocal());
                    GlobalVariables.setDolphinPrincipal(principal);
                    JOptionPane.showMessageDialog(ProfileDialog.this.dialog, ProfileDialog.SUCCESS_MESSAGE, GlobalConstants.getFrameTitle("\u30d1\u30b9\u30ef\u30fc\u30c9\u5909\u66f4"), 1);
                    ProfileDialog.this.stop();
                } else {
                    JOptionPane.showMessageDialog(ProfileDialog.this.dialog, ProfileDialog.ERROR_MESSAGE, GlobalConstants.getFrameTitle("\u30d1\u30b9\u30ef\u30fc\u30c9\u5909\u66f4"), 2);
                    ProfileDialog.this.stop();
                }
            }
            catch (Exception ex) {
                LogWriter.error(this.getClass(), ex);
            }
        }

        private void setBusy(boolean busy) {
            if (busy) {
                this.okButton.setEnabled(false);
            } else {
                this.okButton.setEnabled(true);
            }
        }

        private boolean userIdOk() {
            String userId = this.uid.getText().trim();
            if (userId.equals(ProfileDialog.DUMMY_PASSWORD)) {
                return false;
            }
            return userId.length() >= this.userIdLength[0] && userId.length() <= this.userIdLength[1];
        }

        private boolean passwordOk() {
            String passwd1 = new String(this.userPassword1.getPassword());
            String passwd2 = new String(this.userPassword2.getPassword());
            if (passwd1.equals(ProfileDialog.DUMMY_PASSWORD) && passwd2.equals(ProfileDialog.DUMMY_PASSWORD)) {
                return true;
            }
            if (passwd1.length() < this.passwordLength[0] || passwd1.length() > this.passwordLength[1]) {
                return false;
            }
            if (passwd2.length() < this.passwordLength[0] || passwd2.length() > this.passwordLength[1]) {
                return false;
            }
            return passwd1.equals(passwd2);
        }

        private void checkButton() {
            boolean newOk;
            boolean uidOk = this.userIdOk();
            boolean passwordOk = this.passwordOk();
            boolean snOk = !this.sn.getText().trim().equals(ProfileDialog.DUMMY_PASSWORD);
            boolean givenOk = !this.givenName.getText().trim().equals(ProfileDialog.DUMMY_PASSWORD);
            boolean emailOk = !this.email.getText().trim().equals(ProfileDialog.DUMMY_PASSWORD);
            boolean bl = newOk = uidOk && passwordOk && snOk && givenOk && emailOk;
            if (this.ok != newOk) {
                this.ok = newOk;
                this.okButton.setEnabled(this.ok);
            }
        }
    }
}

