/*
 * Decompiled with CFR 0.152.
 */
package fr.apteryx.imageio.dicom;

import fr.apteryx.imageio.dicom.AbstractSyntax;
import fr.apteryx.imageio.dicom.DataSet;
import fr.apteryx.imageio.dicom.DicomException;
import fr.apteryx.imageio.dicom.DicomWriter;
import fr.apteryx.imageio.dicom.PDU;
import fr.apteryx.imageio.dicom.PeerAE;
import fr.apteryx.imageio.dicom.Plugin;
import fr.apteryx.imageio.dicom.ReceivedMessage;
import fr.apteryx.imageio.dicom.SecureTransport;
import fr.apteryx.imageio.dicom.Server;
import fr.apteryx.imageio.dicom.TransferSyntax;
import java.io.IOException;
import java.io.InputStream;
import java.io.InterruptedIOException;
import java.io.OutputStream;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.net.SocketException;
import java.net.SocketTimeoutException;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import javax.imageio.stream.ImageOutputStream;
import javax.imageio.stream.ImageOutputStreamImpl;

final class Association
extends Thread {
    private static final String[][] ASSOCIATION_REJECTION_REASON = new String[][]{{"no reason given", "application context name not supported", "calling AE title not recognized", "reserved", "reserved", "reserved", "called AE title not recognized"}, {"no reason given", "protocol version not supported"}, {"reserved", "temporary congestion", "local limit exceeded"}};
    private final Server server;
    private int state;
    private Socket sock;
    private InputStream sockIS;
    private OutputStream sockOS;
    String callingAE;
    String calledAE;
    final InetAddress addr;
    final int port;
    private final SecureTransport st;
    private boolean aborted = false;
    private boolean released = false;
    private boolean expired = false;
    private final boolean requestor;
    private PDU.AssociateRqAc associate_rq;
    private AbstractSyntax[] syntaxes;
    final HashMap syn_id_hash = new HashMap();
    final HashMap syn_name_hash = new HashMap();
    final Map sent_messages = Collections.synchronizedMap(new HashMap());
    final Map rcv_messages = Collections.synchronizedMap(new HashMap());
    private final LinkedList receivedMessages;
    private ReceivedMessage messageBeingReceived;
    private int maxPDUSent = 65536;
    private final int maxPDUReceived = 32768;
    IOException pendingExc;
    private Object mid_lock = new Object();
    private int mid = 1;
    private byte[] header = new byte[6];
    private byte[] pdu = new byte[32768];

    Association(Socket socket, Server server) throws IOException {
        super("Association Acceptor");
        this.setDaemon(false);
        this.server = server;
        this.receivedMessages = null;
        this.createSock(socket);
        InetSocketAddress inetSocketAddress = (InetSocketAddress)socket.getRemoteSocketAddress();
        this.addr = inetSocketAddress.getAddress();
        this.port = inetSocketAddress.getPort();
        this.st = null;
        this.requestor = false;
        this.state = 2;
        this.start();
    }

    Association(PeerAE peerAE, AbstractSyntax[] abstractSyntaxArray) {
        super("Association Requestor");
        this.setDaemon(false);
        this.receivedMessages = new LinkedList();
        this.server = null;
        this.calledAE = peerAE.calledAE;
        this.callingAE = peerAE.callingAE;
        this.port = peerAE.port;
        this.addr = peerAE.addr;
        this.st = peerAE.secureTransport;
        this.setSyntaxes(abstractSyntaxArray);
        this.requestor = true;
        this.state = 4;
        this.start();
    }

    private void setState(int n) {
        this.state = n;
        this.notifyAll();
    }

    private void checkPendingExc() throws IOException {
        if (this.pendingExc != null) {
            try {
                throw this.pendingExc;
            }
            catch (Throwable throwable) {
                this.pendingExc = null;
                throw throwable;
            }
        }
    }

    private void setPendingExc(IOException iOException) {
        if (this.server != null) {
            this.server.exceptionOccured(this, iOException);
        }
        if (this.pendingExc == null) {
            this.pendingExc = iOException;
        }
    }

    void sendMessage(String string, DataSet dataSet) throws IOException {
        this.sendMessage(string, dataSet, null, false, null);
    }

    synchronized void sendMessage(String string, DataSet dataSet, DataSet dataSet2, boolean bl, DicomWriter dicomWriter) throws IOException {
        while (this.state != 6 && this.state != 8) {
            this.checkPendingExc();
            if (this.state == 1 || this.state == 13) {
                throw new IOException("The association no longer exists");
            }
            try {
                this.wait();
            }
            catch (InterruptedException interruptedException) {
                throw new InterruptedIOException();
            }
        }
        this.checkPendingExc();
        LinkedList linkedList = (LinkedList)this.syn_name_hash.get(string);
        if (linkedList == null) {
            throw new DicomException("ServiceRefused", "Association does not support abstract syntax " + string);
        }
        AbstractSyntax abstractSyntax = null;
        Object object = linkedList.iterator();
        while (object.hasNext()) {
            abstractSyntax = (AbstractSyntax)object.next();
            if (abstractSyntax.selected_ts == null) continue;
        }
        if (dataSet2 != null && abstractSyntax.selected_ts == null) {
            throw new DicomException("ServiceRefused", "No transfer syntax successfully negociated for abstract syntax " + string + " (" + AbstractSyntax.REASONS[abstractSyntax.reason] + ")");
        }
        object = new Fragmenter(this.sockOS, abstractSyntax.id);
        dataSet.write((ImageOutputStream)object, TransferSyntax.IMPLICIT_LITTLEENDIAN, false, null, true);
        if (dataSet2 != null) {
            ((Fragmenter)object).setData();
            dataSet2.write((ImageOutputStream)object, abstractSyntax.selected_ts, bl, dicomWriter, false);
        }
        ((Fragmenter)object).close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    ReceivedMessage receiveMessage() throws IOException {
        Association association = this;
        synchronized (association) {
            while (this.receivedMessages.isEmpty()) {
                this.checkPendingExc();
                if (this.state >= 8 && this.state <= 12) {
                    return null;
                }
                if (this.state == 1 || this.state == 13) {
                    throw new IOException("The association no longer exists");
                }
                try {
                    this.wait();
                }
                catch (InterruptedException interruptedException) {
                    throw new InterruptedIOException();
                }
            }
            return (ReceivedMessage)this.receivedMessages.removeFirst();
        }
    }

    synchronized void release() throws IOException {
        if (this.released) {
            return;
        }
        this.checkPendingExc();
        while (this.state != 6 && this.state != 8 && this.state != 1) {
            try {
                this.wait();
            }
            catch (InterruptedException interruptedException) {
                throw new InterruptedIOException();
            }
        }
        this.checkPendingExc();
        this.released = true;
        if (this.state == 6) {
            this.sendReleaseRqPDU();
            this.setState(7);
        } else if (this.state == 8) {
            try {
                this.sendReleaseRpPDU();
                this.startARTIM();
            }
            catch (SocketException socketException) {
                // empty catch block
            }
            this.setState(13);
        } else if (this.state == 1) {
            return;
        }
        this.notifyAll();
    }

    synchronized void abort() {
        this.aborted = true;
        this.interrupt();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    int newMessageID() {
        Object object = this.mid_lock;
        synchronized (object) {
            return this.mid++;
        }
    }

    private void setSyntaxes(AbstractSyntax[] abstractSyntaxArray) {
        this.syntaxes = abstractSyntaxArray;
        for (int i = 0; i < abstractSyntaxArray.length; ++i) {
            this.syn_id_hash.put(new Integer(abstractSyntaxArray[i].id), abstractSyntaxArray[i]);
            LinkedList<AbstractSyntax> linkedList = (LinkedList<AbstractSyntax>)this.syn_name_hash.get(abstractSyntaxArray[i].name);
            if (linkedList == null) {
                linkedList = new LinkedList<AbstractSyntax>();
                this.syn_name_hash.put(abstractSyntaxArray[i].name, linkedList);
            }
            linkedList.addLast(abstractSyntaxArray[i]);
        }
    }

    private void createSock(Socket socket) throws IOException {
        socket.setSoLinger(false, 0);
        this.sock = socket;
        this.sockIS = this.sock.getInputStream();
        this.sockOS = this.sock.getOutputStream();
    }

    private synchronized void closeSock() throws IOException {
        if (this.sock != null) {
            this.sockIS.close();
            this.sockOS.close();
            this.sock.close();
            this.sock = null;
        }
    }

    private void AA1() throws IOException {
        this.sendAbortPDU(true, 0);
        this.startARTIM();
    }

    private void AA2() throws IOException {
        this.stopARTIM();
        this.closeSock();
    }

    private void AA3() throws IOException {
        this.closeSock();
    }

    private void AA4() {
    }

    private void AA5() throws SocketException {
        this.stopARTIM();
    }

    private void AA7() throws IOException {
        this.sendAbortPDU(false, 2);
    }

    private void AA8() throws IOException {
        this.sendAbortPDU(false, 2);
        this.startARTIM();
    }

    private void startARTIM() throws SocketException {
        this.sock.setSoTimeout(Plugin.ARTIM);
    }

    private void stopARTIM() throws SocketException {
        this.sock.setSoTimeout(0);
    }

    private PDU receivePDU() {
        if (this.aborted || this.expired) {
            return null;
        }
        try {
            int n;
            int by;
            int n2 = 0;
            do {
                try {
                    by = this.sockIS.read(this.header, n2, 6 - n2);
                }
                catch (SocketException n3) {
                    return null;
                }
                if (by >= 0) continue;
                return null;
            } while ((n2 += by) < 6);
            byte by2 = this.header[0];
            int n3 = (this.header[2] & 0xFF) << 24 | (this.header[3] & 0xFF) << 16 | (this.header[4] & 0xFF) << 8 | this.header[5] & 0xFF;
            if (n3 < 0 || n3 > 32768) {
                throw new DicomException("ProtocoleViolation", "Received PDU is too big (" + n3 + ")");
            }
            n2 = 0;
            do {
                if ((n = this.sockIS.read(this.pdu, n2, n3 - n2)) >= 0) continue;
                return null;
            } while ((n2 += n) < n3);
            return PDU.create(by2, this.pdu, n3);
        }
        catch (SocketTimeoutException socketTimeoutException) {
            this.expired = true;
            return null;
        }
        catch (IOException iOException) {
            this.setPendingExc(iOException);
            return null;
        }
    }

    private void sendAssociateRqPDU() throws IOException {
        PDU.AssociateRqAc associateRqAc = new PDU.AssociateRqAc(1, this.calledAE, this.callingAE, this.syntaxes, 32768L);
        associateRqAc.send(this.sockOS);
    }

    private void sendAbortPDU(boolean bl, int n) throws IOException {
        PDU.AssociateRjReleaseRqReleaseRpAbort associateRjReleaseRqReleaseRpAbort = new PDU.AssociateRjReleaseRqReleaseRpAbort(7, 0, bl ? 0 : 2, n);
        associateRjReleaseRqReleaseRpAbort.send(this.sockOS);
    }

    private void sendAssociateAcPDU() throws IOException {
        PDU.AssociateRqAc associateRqAc = new PDU.AssociateRqAc(2, this.calledAE, this.callingAE, this.syntaxes, 32768L);
        associateRqAc.send(this.sockOS);
    }

    private void sendAssociateRjPDU(int n) throws IOException {
        PDU.AssociateRjReleaseRqReleaseRpAbort associateRjReleaseRqReleaseRpAbort = new PDU.AssociateRjReleaseRqReleaseRpAbort(3, 1, 1, n);
        associateRjReleaseRqReleaseRpAbort.send(this.sockOS);
    }

    private void sendReleaseRqPDU() throws IOException {
        PDU.AssociateRjReleaseRqReleaseRpAbort associateRjReleaseRqReleaseRpAbort = new PDU.AssociateRjReleaseRqReleaseRpAbort(5, 0, 0, 0);
        associateRjReleaseRqReleaseRpAbort.send(this.sockOS);
    }

    private void sendReleaseRpPDU() throws IOException {
        PDU.AssociateRjReleaseRqReleaseRpAbort associateRjReleaseRqReleaseRpAbort = new PDU.AssociateRjReleaseRqReleaseRpAbort(6, 0, 0, 0);
        associateRjReleaseRqReleaseRpAbort.send(this.sockOS);
    }

    private void PDataReceived(PDU.DataTf dataTf) throws IOException {
        if (this.messageBeingReceived == null) {
            this.messageBeingReceived = new ReceivedMessage(this);
        }
        if (this.messageBeingReceived.add(dataTf)) {
            if (this.server != null) {
                this.server.messageReceived(this, this.messageBeingReceived);
            } else {
                this.receivedMessages.addLast(this.messageBeingReceived);
                this.notifyAll();
            }
            this.messageBeingReceived = null;
        }
    }

    private void clipMaxPDUSent(long l) {
        if (l > 0L && l < (long)this.maxPDUSent) {
            if ((l & 1L) == 1L) {
                --l;
            }
            this.maxPDUSent = (int)l;
        }
    }

    private boolean selectTS(TransferSyntax[] transferSyntaxArray, AbstractSyntax abstractSyntax) {
        for (int i = 0; i < transferSyntaxArray.length; ++i) {
            TransferSyntax transferSyntax = transferSyntaxArray[i];
            if (!abstractSyntax.ts.contains(transferSyntax.uid)) continue;
            abstractSyntax.selected_ts = transferSyntax;
            abstractSyntax.reason = 0;
            break;
        }
        if (abstractSyntax.selected_ts == null) {
            abstractSyntax.reason = 4;
            return false;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    public void run() {
        try {
            block89: while (true) lbl-1000:
            // 24 sources

            {
                switch (this.state) {
                    case 2: {
                        var1_1 = this.receivePDU();
                        var2_5 = this;
                        synchronized (var2_5) {
                            if (this.expired) {
                                this.AA2();
                                this.setState(1);
                                return;
                            }
                            if (var1_1 == null) {
                                this.AA5();
                                this.setState(1);
                                return;
                            }
                            switch (var1_1.type) {
                                case 1: {
                                    this.stopARTIM();
                                    this.associate_rq = (PDU.AssociateRqAc)var1_1;
                                    this.calledAE = this.associate_rq.calledAE;
                                    this.callingAE = this.associate_rq.callingAE;
                                    var3_9 = this.server.acceptsAE(this.callingAE, this.calledAE);
                                    if (var3_9 != 0) {
                                        this.sendAssociateRjPDU(var3_9);
                                        this.startARTIM();
                                        this.setState(13);
                                        continue block89;
                                    }
                                    this.setSyntaxes(this.associate_rq.syntaxes);
                                    var4_13 = 0;
                                    block90: for (var5_15 = 0; var5_15 < this.syntaxes.length; ++var5_15) {
                                        var6_18 = this.syntaxes[var5_15].name;
                                        block91: while (true) {
                                            switch (this.syntaxes[var5_15].role) {
                                                case 0: 
                                                case 1: {
                                                    var7_20 = this.server.getSCPSupportingAsSCP(var6_18);
                                                    if (var7_20 == null) {
                                                        this.syntaxes[var5_15].reason = 3;
                                                        continue block90;
                                                    }
                                                    if (!this.selectTS(var7_20.getPreferredTSAsSCP(var6_18), this.syntaxes[var5_15])) continue block90;
                                                    var4_13 = 1;
                                                    continue block90;
                                                }
                                                case 2: {
                                                    var7_20 = this.server.getSCPSupportingAsSCU(var6_18);
                                                    if (var7_20 == null) {
                                                        this.syntaxes[var5_15].reason = 3;
                                                        continue block90;
                                                    }
                                                    if (!this.selectTS(var7_20.getPreferredTSAsSCU(var6_18), this.syntaxes[var5_15])) continue block90;
                                                    var4_13 = 1;
                                                    continue block90;
                                                }
                                                default: {
                                                    if (this.server.getSCPSupportingAsSCP(var6_18) == null) {
                                                        this.syntaxes[var5_15].role = 2;
                                                        continue block91;
                                                    }
                                                    var7_20 = this.server.getSCPSupportingAsSCU(var6_18);
                                                    if (var7_20 == null) {
                                                        this.syntaxes[var5_15].role = 1;
                                                        continue block91;
                                                    }
                                                    if (!this.selectTS(var7_20.getPreferredTSAsSCU(var6_18), this.syntaxes[var5_15])) continue block90;
                                                    var4_13 = 1;
                                                    continue block90;
                                                }
                                            }
                                            break;
                                        }
                                    }
                                    this.clipMaxPDUSent(this.associate_rq.maxLength);
                                    this.sendAssociateAcPDU();
                                    this.setState(6);
                                    continue block89;
                                }
                                case 7: {
                                    this.AA2();
                                    this.setState(1);
                                    return;
                                }
                            }
                            this.AA1();
                            this.setState(13);
                            continue block89;
                        }
                    }
                    case 4: {
                        try {
                            if (this.st == null) {
                                this.createSock(new Socket(this.addr, this.port));
                            } else {
                                this.createSock(this.st.createSocket(this.addr, this.port));
                            }
                        }
                        catch (InterruptedIOException var1_2) {
                            var2_5 = this;
                            synchronized (var2_5) {
                                this.AA2();
                                this.setState(1);
                                return;
                            }
                        }
                        catch (IOException var1_3) {
                            var2_5 = this;
                            synchronized (var2_5) {
                                this.setPendingExc(var1_3);
                                this.AA4();
                                this.setState(1);
                                return;
                            }
                        }
                        var1_1 = this;
                        synchronized (var1_1) {
                            this.sendAssociateRqPDU();
                            this.setState(5);
                            continue block89;
                        }
                    }
                    case 5: {
                        var1_1 = this.receivePDU();
                        var2_5 = this;
                        synchronized (var2_5) {
                            if (this.aborted) {
                                this.AA1();
                                this.setState(13);
                                continue block89;
                            }
                            if (var1_1 == null) {
                                this.setPendingExc(new DicomException("IOException", "Connection closed"));
                                this.AA4();
                                this.setState(1);
                                return;
                            }
                            switch (var1_1.type) {
                                case 2: {
                                    var3_10 = (PDU.AssociateRqAc)var1_1;
                                    for (var4_13 = 0; var4_13 < var3_10.syntaxes.length; ++var4_13) {
                                        var5_16 = var3_10.syntaxes[var4_13];
                                        var6_19 = var5_16.id;
                                        var7_20 = (AbstractSyntax)this.syn_id_hash.get(new Integer(var6_19));
                                        if (var7_20 == null) continue;
                                        v0 = var7_20.reason = var5_16.reason < 0 || var5_16.reason >= AbstractSyntax.REASONS.length ? 2 : var5_16.reason;
                                        if (var5_16.ts.size() == 0 || !var7_20.ts.contains(var8_21 = (String)var5_16.ts.get(0))) continue;
                                        var7_20.selected_ts = TransferSyntax.getInstance(var8_21);
                                    }
                                    this.clipMaxPDUSent(var3_10.maxLength);
                                    this.setState(6);
                                    continue block89;
                                }
                                case 3: {
                                    this.closeSock();
                                    var4_14 = (PDU.AssociateRjReleaseRqReleaseRpAbort)var1_1;
                                    try {
                                        this.setPendingExc(new DicomException("AssociationRejection", Association.ASSOCIATION_REJECTION_REASON[var4_14.source - 1][var4_14.reason - 1]));
                                    }
                                    catch (ArrayIndexOutOfBoundsException var5_17) {
                                        this.setPendingExc(new DicomException("AssociationRejection", "Unrecognized reason"));
                                    }
                                    this.setState(1);
                                    return;
                                }
                                case 7: {
                                    this.AA3();
                                    this.setState(1);
                                    return;
                                }
                            }
                            this.AA8();
                            this.setState(13);
                            continue block89;
                        }
                    }
                    case 6: 
                    case 7: {
                        var1_1 = this.receivePDU();
                        var2_5 = this;
                        synchronized (var2_5) {
                            if (this.aborted) {
                                this.AA1();
                                this.setState(13);
                                continue block89;
                            }
                            if (var1_1 == null) {
                                this.AA4();
                                this.setState(1);
                                return;
                            }
                            switch (var1_1.type) {
                                case 4: {
                                    this.PDataReceived((PDU.DataTf)var1_1);
                                    continue block89;
                                }
                                case 5: {
                                    if (this.state == 6) {
                                        this.setState(8);
                                        if (this.server != null) {
                                            this.server.messageReceived(this, null);
                                        }
                                    } else {
                                        this.setState(this.requestor != false ? 9 : 10);
                                    }
                                    continue block89;
                                }
                                case 6: {
                                    if (this.state == 7) {
                                        this.closeSock();
                                        this.setState(1);
                                    } else {
                                        this.AA8();
                                        this.setState(13);
                                    }
                                    return;
                                }
                                case 7: {
                                    this.AA3();
                                    this.setState(1);
                                    return;
                                }
                            }
                            this.AA8();
                            this.setState(13);
                            continue block89;
                        }
                    }
                    case 8: {
                        var1_1 = this;
                        synchronized (var1_1) {
                            try {
                                this.wait();
                            }
                            catch (InterruptedException var2_6) {
                                if (!this.aborted) ** GOTO lbl-1000
                                this.AA1();
                                this.setState(13);
                            }
                            continue block89;
                        }
                    }
                    case 9: {
                        var1_1 = this;
                        synchronized (var1_1) {
                            this.sendReleaseRpPDU();
                            this.setState(11);
                            continue block89;
                        }
                    }
                    case 10: 
                    case 11: {
                        var1_1 = this.receivePDU();
                        var2_5 = this;
                        synchronized (var2_5) {
                            if (this.aborted) {
                                this.AA1();
                                this.setState(13);
                                continue block89;
                            }
                            if (var1_1 == null) {
                                this.AA4();
                                this.setState(1);
                                return;
                            }
                            switch (var1_1.type) {
                                case 6: {
                                    if (this.state == 10) {
                                        this.setState(12);
                                        continue block89;
                                    }
                                    this.closeSock();
                                    this.setState(1);
                                    return;
                                }
                                case 7: {
                                    this.AA3();
                                    this.setState(1);
                                    return;
                                }
                            }
                            this.AA8();
                            this.setState(13);
                            continue block89;
                        }
                    }
                    case 12: {
                        var1_1 = this;
                        synchronized (var1_1) {
                            this.sendReleaseRpPDU();
                            this.startARTIM();
                            this.setState(13);
                            continue block89;
                        }
                    }
                    case 13: {
                        var1_1 = this.receivePDU();
                        var2_5 = this;
                        synchronized (var2_5) {
                            if (this.expired) {
                                this.AA2();
                                this.setState(1);
                                return;
                            }
                            if (var1_1 == null) {
                                try {
                                    this.stopARTIM();
                                }
                                catch (SocketException var3_11) {
                                    // empty catch block
                                }
                                this.setState(1);
                                try {
                                    this.closeSock();
                                }
                                catch (IOException var3_12) {
                                    // empty catch block
                                }
                                return;
                            }
                            switch (var1_1.type) {
                                case 2: 
                                case 3: 
                                case 4: 
                                case 5: 
                                case 6: {
                                    continue block89;
                                }
                                case 7: {
                                    this.AA2();
                                    this.setState(1);
                                    return;
                                }
                            }
                            this.AA7();
                            continue block89;
                        }
                    }
                }
            }
        }
        catch (IOException var1_4) {
            var2_7 = this;
            synchronized (var2_7) {
                this.setPendingExc(var1_4);
                this.setState(1);
            }
            try {
                this.closeSock();
            }
            catch (IOException var2_8) {
                // empty catch block
            }
            return;
        }
    }

    boolean isClosed() {
        return this.state == 1 || this.state == 13;
    }

    private final void debug(String string) {
        System.err.println(new Date() + " " + this.getName() + ":" + string);
    }

    boolean supportsSyntax(String string) {
        LinkedList linkedList = (LinkedList)this.syn_name_hash.get(string);
        if (linkedList == null) {
            return false;
        }
        Iterator iterator = linkedList.iterator();
        while (iterator.hasNext()) {
            if (((AbstractSyntax)iterator.next()).selected_ts == null) continue;
            return true;
        }
        return false;
    }

    private class Fragmenter
    extends ImageOutputStreamImpl {
        final OutputStream os;
        final byte[] pdu;
        int pos;
        boolean isCommand;
        int syn_pid;
        boolean newItem;
        int item_start;
        boolean firstDataItem;
        private byte[] header;
        final byte[] b1;

        Fragmenter(OutputStream outputStream, int n) {
            this.pdu = new byte[Association.this.maxPDUSent];
            this.isCommand = true;
            this.newItem = true;
            this.item_start = -1;
            this.firstDataItem = false;
            this.header = new byte[]{4, 0, 0, 0, 0, 0};
            this.b1 = new byte[1];
            this.os = outputStream;
            this.syn_pid = n;
        }

        void setData() {
            this.isCommand = false;
            this.newItem = true;
            this.firstDataItem = true;
        }

        private void setLength(byte[] byArray, int n, long l) {
            byArray[n] = (byte)(l >> 24);
            byArray[n + 1] = (byte)(l >> 16);
            byArray[n + 2] = (byte)(l >> 8);
            byArray[n + 3] = (byte)l;
        }

        private void sendPDU() throws IOException {
            this.setLength(this.header, 2, this.pos);
            this.os.write(this.header, 0, 6);
            this.os.write(this.pdu, 0, this.pos);
            this.pos = 0;
        }

        private void closeItem() {
            this.setLength(this.pdu, this.item_start, this.pos - this.item_start - 4);
            if (this.firstDataItem) {
                int n = this.item_start + 5;
                this.pdu[n] = (byte)(this.pdu[n] | 2);
                this.firstDataItem = false;
            }
            this.item_start = -1;
        }

        private void openItem() {
            this.item_start = this.pos;
            this.pdu[this.pos + 4] = (byte)this.syn_pid;
            this.pdu[this.pos + 5] = this.isCommand ? (byte)1 : 0;
            this.pos += 6;
        }

        public void write(byte[] byArray, int n, int n2) throws IOException {
            int n3;
            if (n2 == 0) {
                return;
            }
            if (this.newItem) {
                if (this.item_start >= 0) {
                    this.closeItem();
                }
                if (Association.this.maxPDUSent - this.pos < 8) {
                    this.sendPDU();
                }
                this.openItem();
                this.newItem = false;
            }
            while (n2 > (n3 = Association.this.maxPDUSent - this.pos)) {
                System.arraycopy(byArray, n, this.pdu, this.pos, n3);
                n += n3;
                this.pos = Association.this.maxPDUSent;
                this.closeItem();
                this.sendPDU();
                if ((n2 -= n3) == 0) {
                    return;
                }
                this.openItem();
            }
            System.arraycopy(byArray, n, this.pdu, this.pos, n2);
            this.pos += n2;
        }

        public void write(int n) throws IOException {
            this.b1[0] = (byte)n;
            this.write(this.b1, 0, 1);
        }

        public int read(byte[] byArray, int n, int n2) throws IOException {
            throw new IOException("Impossible, write-only stream");
        }

        public int read() throws IOException {
            throw new IOException("Impossible, write-only stream");
        }

        public void close() throws IOException {
            if (this.item_start >= 0) {
                this.firstDataItem = true;
                this.closeItem();
            }
            if (this.pos > 0) {
                this.sendPDU();
            }
            super.close();
        }
    }
}

